/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.PutRepositoryRefDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PutRepositoryRefRequest
extends BmcRequest<PutRepositoryRefDetails> {
    private String repositoryId;
    private String refName;
    private PutRepositoryRefDetails putRepositoryRefDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRefName() {
        return this.refName;
    }

    public PutRepositoryRefDetails getPutRepositoryRefDetails() {
        return this.putRepositoryRefDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PutRepositoryRefDetails getBody$() {
        return this.putRepositoryRefDetails;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).refName(this.refName).putRepositoryRefDetails(this.putRepositoryRefDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",refName=").append(String.valueOf(this.refName));
        sb.append(",putRepositoryRefDetails=").append(String.valueOf((Object)this.putRepositoryRefDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutRepositoryRefRequest)) {
            return false;
        }
        PutRepositoryRefRequest other = (PutRepositoryRefRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.refName, other.refName) && Objects.equals((Object)this.putRepositoryRefDetails, (Object)other.putRepositoryRefDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.refName == null ? 43 : this.refName.hashCode());
        result = result * 59 + (this.putRepositoryRefDetails == null ? 43 : this.putRepositoryRefDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PutRepositoryRefRequest, PutRepositoryRefDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String refName = null;
        private PutRepositoryRefDetails putRepositoryRefDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder putRepositoryRefDetails(PutRepositoryRefDetails putRepositoryRefDetails) {
            this.putRepositoryRefDetails = putRepositoryRefDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutRepositoryRefRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.refName(o.getRefName());
            this.putRepositoryRefDetails(o.getPutRepositoryRefDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutRepositoryRefRequest build() {
            PutRepositoryRefRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PutRepositoryRefDetails body) {
            this.putRepositoryRefDetails(body);
            return this;
        }

        public PutRepositoryRefRequest buildWithoutInvocationCallback() {
            PutRepositoryRefRequest request = new PutRepositoryRefRequest();
            request.repositoryId = this.repositoryId;
            request.refName = this.refName;
            request.putRepositoryRefDetails = this.putRepositoryRefDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

