/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MonitorContendedEnteredRequest;
import com.sun.jdi.request.StepRequest;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SingleThreadWatcher;
import org.netbeans.modules.debugger.jpda.impl.StepUtils;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MonitorInfoWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMOutOfMemoryExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.MonitorContendedEnteredRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.MonitorInfoImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class JPDAThreadImpl
implements JPDAThread,
Customizer,
BeanContextChild {
    private static final String PROP_LOCKER_THREADS = "lockerThreads";
    private static final String PROP_STEP_SUSPENDED_BY_BREAKPOINT = "stepSuspendedByBreakpoint";
    public static final String PROP_OPERATIONS_SET = "operationsSet";
    public static final String PROP_OPERATIONS_UPDATE = "operationsUpdate";
    private static final Logger logger = Logger.getLogger(JPDAThreadImpl.class.getName());
    private static final Logger loggerS = Logger.getLogger(JPDAThreadImpl.class.getName() + ".suspend");
    private final ThreadReference threadReference;
    private final JPDADebuggerImpl debugger;
    private boolean suspended;
    private boolean suspendedOnAnEvent;
    private boolean suspendedNoFire;
    private boolean suspendRequested;
    private boolean initiallySuspended;
    private int suspendCount;
    private EditorContext.Operation currentOperation;
    private List<EditorContext.Operation> lastOperations;
    private boolean doKeepLastOperations;
    private ReturnVariableImpl returnVariable;
    private PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private PropertyChangeSupport operationsPch = new PropertyChangeSupport(this);
    private int stackDepth = -1;
    private CallStackFrame[] cachedFrames;
    private int cachedFramesFrom = -1;
    private int cachedFramesTo = -1;
    private final Object cachedFramesLock = new Object();
    private JPDABreakpoint currentBreakpoint;
    private JPDABreakpointEvent breakpointEvent;
    private String threadName;
    private final Object lockerThreadsLock = new Object();
    private ObjectReference lockerThreadsMonitor;
    private List<JPDAThread> lockerThreadsList;
    private List<ThreadReference> resumedBlockingThreads;
    private final Object stepBreakpointLock = new Object();
    private JPDABreakpoint stepSuspendedByBreakpoint;
    private Set<JPDAThreadImpl> suspendedSteppingThreads;
    private Set<JPDAThreadImpl> steppingSuspendedByBptsInThreads;
    private VirtualMachine vm;
    private final Object suspendToCheckForMonitorsLock = new Object();
    private boolean canSuspendToCheckForMonitors;
    public final ReadWriteLock accessLock = new ThreadReentrantReadWriteLock();
    private final Object ownedMonitorsAndFramesSingleAccessLock = new Object();
    private List<PropertyChangeEvent> resumeChangeEvents;
    private SingleThreadWatcher watcher = null;
    private boolean methodInvoking;
    private boolean methodInvokingDisabledUntilResumed;
    private boolean resumedToFinishMethodInvocation;
    private boolean unsuspendedStateWhenInvoking;
    private List<StepRequest> stepsDeletedDuringMethodInvoke;
    private boolean inStep = false;
    private final Object pendingActionsLock = new Object();
    private Object pendingAction;
    private Variable pendingVariable;

    public JPDAThreadImpl(ThreadReference threadReference, JPDADebuggerImpl debugger) {
        this.threadReference = threadReference;
        this.debugger = debugger;
        boolean initFailed = false;
        this.threadName = "";
        try {
            this.vm = MirrorWrapper.virtualMachine(threadReference);
            this.threadName = ThreadReferenceWrapper.name(threadReference);
            this.suspended = ThreadReferenceWrapper.isSuspended(threadReference);
            this.suspendCount = this.suspended ? ThreadReferenceWrapper.suspendCount(threadReference) : 0;
            this.initiallySuspended = this.suspended;
        }
        catch (IllegalThreadStateExceptionWrapper itsex) {
            initFailed = true;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            initFailed = true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            initFailed = true;
        }
        catch (InternalExceptionWrapper ex) {
            initFailed = true;
        }
        if (initFailed) {
            this.suspended = false;
            this.suspendCount = 0;
        }
    }

    public Lock getReadAccessLock() {
        return this.accessLock.readLock();
    }

    public String getName() {
        return this.threadName;
    }

    public JPDAThreadGroup getParentThreadGroup() {
        try {
            ThreadGroupReference tgr = ThreadReferenceWrapper.threadGroup(this.threadReference);
            if (tgr == null) {
                return null;
            }
            return this.debugger.getThreadGroup(tgr);
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (VMOutOfMemoryExceptionWrapper ex) {
            return null;
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineNumber(String stratum) {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended) {
                if (!this.suspendedNoFire) return -1;
            }
            try {
                CallStackFrame[] topStackRef = this.getCallStack(0, 1);
                if (topStackRef.length > 0) {
                    int n = topStackRef[0].getLineNumber(stratum);
                    return n;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                if (this.stackDepth < 0) {
                    this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                }
                if (this.stackDepth < 1) {
                    int n = -1;
                    return n;
                }
            }
            int n = LocationWrapper.lineNumber(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)), stratum);
            return n;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return -1;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return -1;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return -1;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return -1;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return -1;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return -1;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Method getTopMethod() {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended) {
                if (!this.suspendedNoFire) return null;
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                if (this.stackDepth < 0) {
                    this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                }
                if (this.stackDepth < 1) {
                    Method method = null;
                    return method;
                }
            }
            object = LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)));
            return object;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return null;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return null;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public synchronized EditorContext.Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
        this.fireOperationsChanged(PROP_OPERATIONS_SET);
    }

    public synchronized List<EditorContext.Operation> getLastOperations() {
        return this.lastOperations;
    }

    public synchronized void addLastOperation(EditorContext.Operation operation) {
        if (this.lastOperations == null) {
            this.lastOperations = new ArrayList<EditorContext.Operation>();
        }
        this.lastOperations.add(operation);
        this.fireOperationsChanged(PROP_OPERATIONS_SET);
    }

    public synchronized void updateLastOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
        if (this.lastOperations == null) {
            this.lastOperations = new ArrayList<EditorContext.Operation>();
        }
        this.fireOperationsChanged(PROP_OPERATIONS_UPDATE);
    }

    public synchronized void clearLastOperations() {
        if (this.lastOperations != null) {
            for (EditorContext.Operation last : this.lastOperations) {
                last.setReturnValue(null);
            }
        }
        this.lastOperations = null;
        this.fireOperationsChanged(PROP_OPERATIONS_SET);
    }

    public synchronized void holdLastOperations(boolean doHold) {
        this.doKeepLastOperations = doHold;
    }

    public synchronized JPDABreakpoint getCurrentBreakpoint() {
        if (this.currentBreakpoint != null && this.currentBreakpoint.isHidden()) {
            return null;
        }
        return this.currentBreakpoint;
    }

    public synchronized JPDABreakpointEvent getCurrentBreakpointEvent() {
        return this.breakpointEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentBreakpoint(JPDABreakpoint currentBreakpoint, JPDABreakpointEvent breakpointEvent) {
        JPDABreakpoint oldBreakpoint;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            oldBreakpoint = this.currentBreakpoint;
            this.currentBreakpoint = currentBreakpoint;
            this.breakpointEvent = breakpointEvent;
        }
        this.pch.firePropertyChange("currentBreakpoint", oldBreakpoint, currentBreakpoint);
    }

    public int getState() {
        try {
            return ThreadReferenceWrapper.status(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        return -1;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isSuspendedNoFire() {
        return this.suspendedNoFire;
    }

    public boolean isThreadSuspended() {
        try {
            return ThreadReferenceWrapper.isSuspended(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return false;
    }

    public boolean isSuspendedOnAnEvent() {
        return this.suspendedOnAnEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getClassName() {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended) {
                if (!this.suspendedNoFire) return "";
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                if (this.stackDepth < 0) {
                    this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                }
                if (this.stackDepth < 1) {
                    String string = "";
                    return string;
                }
            }
            object = ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0))));
            return object;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return "";
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return "";
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMethodName() {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended) {
                if (!this.suspendedNoFire) return "";
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                if (this.stackDepth < 0) {
                    this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                }
                if (this.stackDepth < 1) {
                    String string = "";
                    return string;
                }
            }
            object = TypeComponentWrapper.name(LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0))));
            return object;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return "";
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return "";
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSourceName(String stratum) throws AbsentInformationException {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended) {
                if (!this.suspendedNoFire) return "";
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                if (this.stackDepth < 0) {
                    this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                }
                if (this.stackDepth < 1) {
                    String string = "";
                    return string;
                }
            }
            object = LocationWrapper.sourceName(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)), stratum);
            return object;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return "";
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return "";
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSourcePath(String stratum) throws AbsentInformationException {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended) {
                if (!this.suspendedNoFire) return "";
            }
            Object object = this.cachedFramesLock;
            synchronized (object) {
                if (this.stackDepth < 0) {
                    this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                }
                if (this.stackDepth < 1) {
                    String string = "";
                    return string;
                }
            }
            object = LocationWrapper.sourcePath(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)), stratum);
            return object;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return "";
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return "";
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public CallStackFrame[] getCallStack() throws AbsentInformationException {
        this.accessLock.readLock().lock();
        try {
            CallStackFrame[] callStackFrameArray = this.getCallStack(0, this.getStackDepth());
            return callStackFrameArray;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public CallStackFrame[] getCallStack(int from, int to) throws AbsentInformationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCachedFrames() {
        Object object = this.cachedFramesLock;
        synchronized (object) {
            this.stackDepth = -1;
            this.cachedFrames = null;
            this.cachedFramesFrom = -1;
            this.cachedFramesTo = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStackDepth() {
        this.accessLock.readLock().lock();
        try {
            if (!this.suspended && !this.suspendedNoFire) return 0;
            Object object = this.cachedFramesLock;
            synchronized (object) {
                try {
                    if (this.stackDepth < 0) {
                        this.stackDepth = ThreadReferenceWrapper.frameCount0(this.threadReference);
                    }
                    int n = this.stackDepth;
                    return n;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                        return 0;
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                        return 0;
                    }
                    catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                        return 0;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public void popFrames(StackFrame sf) throws IncompatibleThreadStateException {
        try {
            this.notifyToBeResumed();
            this.accessLock.writeLock().lock();
            try {
                ThreadReferenceWrapper.popFrames(this.threadReference, sf);
            }
            finally {
                this.accessLock.writeLock().unlock();
            }
            this.cleanCachedFrames();
            this.setReturnVariable(null);
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            throw new IncompatibleThreadStateException("Thread exited.");
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw new IncompatibleThreadStateException("Thread died.");
        }
        catch (NativeMethodExceptionWrapper nmex) {
            this.cleanCachedFrames();
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)nmex, (String)NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NativeMethodPop")));
        }
        catch (InternalExceptionWrapper iex) {
            this.cleanCachedFrames();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        finally {
            this.notifySuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        logger.fine("JPDAThreadImpl.suspend() called.");
        Boolean suspendedToFire = null;
        boolean isCurrent = this.debugger.getCurrentThread() == this;
        this.accessLock.writeLock().lock();
        try {
            logger.fine("  write lock acquired, is suspended = " + this.suspended + ", suspendedNoFire = " + this.suspendedNoFire);
            if (!this.isSuspended()) {
                if (this.suspendedNoFire) {
                    loggerS.fine("[" + this.threadName + "]: suspend(): SETTING suspendRequested = " + true);
                    this.suspendRequested = true;
                    return;
                }
                logger.fine("Suspending thread " + this.threadName);
                ThreadReferenceWrapper.suspend(this.threadReference);
                suspendedToFire = Boolean.TRUE;
                ++this.suspendCount;
                this.threadName = ThreadReferenceWrapper.name(this.threadReference);
            }
            this.suspended = true;
            this.initiallySuspended = false;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        if (isCurrent) {
            this.debugger.setStoppedState(this.threadReference, false);
        }
        if (suspendedToFire != null) {
            this.pch.firePropertyChange("suspended", (Object)(suspendedToFire == false ? 1 : 0), suspendedToFire);
        }
    }

    public void resume() {
        boolean can = this.cleanBeforeResume();
        if (can) {
            try {
                this.resumeAfterClean();
                this.setAsResumed(false);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            finally {
                this.fireAfterResume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanBeforeResume() {
        boolean can22;
        if (this == this.debugger.getCurrentThread() && !(can22 = this.debugger.currentThreadToBeResumed())) {
            return false;
        }
        this.accessLock.writeLock().lock();
        this.waitUntilMethodInvokeDone();
        this.setReturnVariable(null);
        this.setCurrentOperation(null);
        JPDAThreadImpl can22 = this;
        synchronized (can22) {
            this.currentBreakpoint = null;
            this.breakpointEvent = null;
        }
        if (!this.doKeepLastOperations) {
            this.clearLastOperations();
        }
        this.cleanCachedFrames();
        JPDABreakpoint brkp = this.removeSuspendedByBreakpoint();
        PropertyChangeEvent suspEvt = new PropertyChangeEvent(this, "suspended", true, false);
        if (brkp != null) {
            PropertyChangeEvent brkpEvt = new PropertyChangeEvent(this, PROP_STEP_SUSPENDED_BY_BREAKPOINT, brkp, null);
            this.resumeChangeEvents = this.isSuspended() ? Arrays.asList(brkpEvt, suspEvt) : Collections.singletonList(brkpEvt);
        } else {
            this.resumeChangeEvents = this.isSuspended() ? Collections.singletonList(suspEvt) : Collections.emptyList();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAfterClean() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        block10: {
            logger.fine("Resuming thread " + this.threadName);
            boolean resumed = false;
            try {
                for (int count = ThreadReferenceWrapper.suspendCount(this.threadReference); count > 0; --count) {
                    ThreadReferenceWrapper.resume(this.threadReference);
                }
                resumed = true;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                if (resumed) break block10;
                for (PropertyChangeEvent pchEvt : this.resumeChangeEvents) {
                    if (!"suspended".equals(pchEvt.getPropertyName())) continue;
                    this.resumeChangeEvents = new ArrayList<PropertyChangeEvent>(this.resumeChangeEvents);
                    this.resumeChangeEvents.remove(pchEvt);
                    break;
                }
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                if (resumed) break block10;
                for (PropertyChangeEvent pchEvt : this.resumeChangeEvents) {
                    if (!"suspended".equals(pchEvt.getPropertyName())) continue;
                    this.resumeChangeEvents = new ArrayList<PropertyChangeEvent>(this.resumeChangeEvents);
                    this.resumeChangeEvents.remove(pchEvt);
                    break;
                }
            }
            finally {
                if (!resumed) {
                    for (PropertyChangeEvent pchEvt : this.resumeChangeEvents) {
                        if (!"suspended".equals(pchEvt.getPropertyName())) continue;
                        this.resumeChangeEvents = new ArrayList<PropertyChangeEvent>(this.resumeChangeEvents);
                        this.resumeChangeEvents.remove(pchEvt);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reduceThreadSuspendCount() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        boolean reduced;
        block10: {
            reduced = true;
            try {
                int count;
                boolean bl = reduced = count == 1;
                for (count = ThreadReferenceWrapper.suspendCount(this.threadReference); count > 1; --count) {
                    ThreadReferenceWrapper.resume(this.threadReference);
                }
                reduced = true;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                if (reduced) break block10;
                for (PropertyChangeEvent pchEvt : this.resumeChangeEvents) {
                    if (!"suspended".equals(pchEvt.getPropertyName())) continue;
                    this.resumeChangeEvents = new ArrayList<PropertyChangeEvent>(this.resumeChangeEvents);
                    this.resumeChangeEvents.remove(pchEvt);
                    break;
                }
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                if (reduced) break block10;
                for (PropertyChangeEvent pchEvt : this.resumeChangeEvents) {
                    if (!"suspended".equals(pchEvt.getPropertyName())) continue;
                    this.resumeChangeEvents = new ArrayList<PropertyChangeEvent>(this.resumeChangeEvents);
                    this.resumeChangeEvents.remove(pchEvt);
                    break;
                }
            }
            finally {
                if (!reduced) {
                    for (PropertyChangeEvent pchEvt : this.resumeChangeEvents) {
                        if (!"suspended".equals(pchEvt.getPropertyName())) continue;
                        this.resumeChangeEvents = new ArrayList<PropertyChangeEvent>(this.resumeChangeEvents);
                        this.resumeChangeEvents.remove(pchEvt);
                        break;
                    }
                }
            }
        }
        return reduced;
    }

    public void setAsResumed(boolean reduceSuspendCountOnly) {
        this.suspendCount = reduceSuspendCountOnly ? --this.suspendCount : 0;
        if (this.suspendCount == 0) {
            this.suspended = false;
            this.suspendedOnAnEvent = false;
            this.suspendedNoFire = false;
            this.debugger.setCurrentSuspendedNoFireThread(null);
            this.methodInvokingDisabledUntilResumed = false;
        }
    }

    public void fireAfterResume() {
        List<PropertyChangeEvent> evts = this.resumeChangeEvents;
        this.resumeChangeEvents = null;
        boolean fire = this.suspendCount == 0;
        this.accessLock.writeLock().unlock();
        if (fire) {
            for (PropertyChangeEvent evt : evts) {
                this.pch.firePropertyChange(evt);
            }
        }
    }

    public void notifyToBeResumed() {
        List<PropertyChangeEvent> evts = this.notifyToBeRunning(true, true);
        for (PropertyChangeEvent evt : evts) {
            this.pch.firePropertyChange(evt);
        }
    }

    public void fireAfterNotifyToBeResumedNoFire() {
        List<PropertyChangeEvent> evts = this.resumeChangeEvents;
        this.resumeChangeEvents = null;
        if (evts != null) {
            for (PropertyChangeEvent evt : evts) {
                this.pch.firePropertyChange(evt);
            }
        }
    }

    public boolean notifyToBeResumedNoFire() {
        logger.fine("notifyToBeResumedNoFire(" + this.getName() + ")");
        this.accessLock.writeLock().lock();
        loggerS.fine("[" + this.threadName + "]: notifyToBeResumedNoFire() suspended = " + this.suspended + ", suspendRequested = " + this.suspendRequested);
        try {
            logger.fine("   suspendRequested = " + this.suspendRequested);
            if (this.suspendRequested) {
                this.suspendRequested = false;
                boolean bl = false;
                return bl;
            }
            this.resumeChangeEvents = this.notifyToBeRunning(true, true);
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyChangeEvent> notifyToBeRunning(boolean clearVars, boolean resumed) {
        if (resumed) {
            this.setPendingAction(null);
        }
        Boolean suspendedToFire = null;
        this.accessLock.writeLock().lock();
        try {
            if (resumed) {
                this.waitUntilMethodInvokeDone();
            }
            if (resumed && --this.suspendCount > 0) {
                List<PropertyChangeEvent> list = Collections.emptyList();
                return list;
            }
            this.suspendCount = 0;
            if (clearVars) {
                this.setCurrentOperation(null);
                this.setReturnVariable(null);
                this.currentBreakpoint = null;
                if (!this.doKeepLastOperations) {
                    this.clearLastOperations();
                }
            }
            if (this.suspended) {
                this.suspended = false;
                suspendedToFire = Boolean.FALSE;
                this.methodInvokingDisabledUntilResumed = false;
            }
            if (resumed) {
                this.suspendedNoFire = false;
                this.suspendedOnAnEvent = false;
                this.debugger.setCurrentSuspendedNoFireThread(null);
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        this.cleanCachedFrames();
        PropertyChangeEvent stepBrkpEvt = null;
        JPDABreakpoint stepBrkp = this.removeSuspendedByBreakpoint();
        if (stepBrkp != null) {
            stepBrkpEvt = new PropertyChangeEvent(this, PROP_STEP_SUSPENDED_BY_BREAKPOINT, stepBrkp, null);
        }
        if (suspendedToFire != null) {
            PropertyChangeEvent suspEvt = new PropertyChangeEvent(this, "suspended", suspendedToFire == false, suspendedToFire);
            if (!resumed) {
                suspEvt.setPropagationId("methodInvoke");
            }
            if (stepBrkpEvt != null) {
                return Arrays.asList(stepBrkpEvt, suspEvt);
            }
            return Collections.singletonList(suspEvt);
        }
        if (stepBrkpEvt != null) {
            return Collections.singletonList(stepBrkpEvt);
        }
        return Collections.emptyList();
    }

    public void updateSuspendCount(int suspendCount) {
        this.accessLock.writeLock().lock();
        try {
            this.suspendCount = suspendCount;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    public void notifySuspended() {
        this.notifySuspended(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuspendedNoFire(boolean eventInThisThread, boolean threadDied) {
        this.accessLock.writeLock().lock();
        try {
            if (eventInThisThread) {
                this.suspendedOnAnEvent = eventInThisThread;
            }
            if (loggerS.isLoggable(Level.FINE)) {
                loggerS.fine("[" + this.threadName + "]: notifySuspendedNoFire() suspended = " + this.suspended + ", suspendCount = " + this.suspendCount + ", suspendedOnAnEvent = " + eventInThisThread);
            }
            if (this.suspended && this.suspendCount > 0 && !this.initiallySuspended) {
                if (loggerS.isLoggable(Level.FINE)) {
                    loggerS.fine("[" + this.threadName + "]: notifySuspendedNoFire(): SETTING suspendRequested = " + true);
                }
                this.suspendRequested = true;
            }
            if (!threadDied) {
                try {
                    this.suspendCount = ThreadReferenceWrapper.suspendCount(this.threadReference);
                    this.threadName = ThreadReferenceWrapper.name(this.threadReference);
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {}
            } else {
                this.suspendCount = 1;
            }
            this.suspendedNoFire = true;
            this.debugger.setCurrentSuspendedNoFireThread(this);
            if (loggerS.isLoggable(Level.FINE)) {
                loggerS.fine("[" + this.threadName + "]: (notifySuspendedNoFire() END) suspended = " + this.suspended + ", suspendedNoFire = " + this.suspendedNoFire + ", suspendRequested = " + this.suspendRequested);
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    public PropertyChangeEvent notifySuspended(boolean doFire, boolean explicitelyPaused) {
        return this.notifySuspended(doFire, explicitelyPaused, true);
    }

    /*
     * Exception decompiling
     */
    private PropertyChangeEvent notifySuspended(boolean doFire, boolean explicitelyPaused, boolean verifyStatusAndName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void fireEvent(PropertyChangeEvent event) {
        this.pch.firePropertyChange(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void notifyMethodInvoking() throws PropertyVetoException {
        List<Object> evts;
        SingleThreadWatcher watcherToDestroy = null;
        this.accessLock.writeLock().lock();
        try {
            logger.log(Level.FINE, "Invoking a method in thread {0}", this.threadName);
            if (loggerS.isLoggable(Level.FINE)) {
                loggerS.fine("[" + this.threadName + "]: Invoking a method, suspended = " + this.suspended + ", suspendedNoFire = " + this.suspendedNoFire + ", suspendRequested = " + this.suspendRequested);
            }
            if (this.methodInvokingDisabledUntilResumed) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_DisabledUntilResumed"), null);
            }
            if (this.methodInvoking) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_AlreadyInvoking"), null);
            }
            if (!this.suspended && !this.suspendedNoFire) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"), null);
            }
            if (loggerS.isLoggable(Level.FINE)) {
                loggerS.fine("Suspend count of " + this + " before notifyMethodInvoking() is: " + this.suspendCount);
            }
            try {
                void var4_15;
                int tsc = ThreadReferenceWrapper.suspendCount(this.threadReference);
                if (this.suspendCount != tsc) {
                    logger.log(Level.INFO, this.getThreadStateLog(), new IllegalStateException("Different suspend counts! JPDA Thread = " + this.suspendCount + ", thread " + this.threadReference + " = " + tsc + ", thread's state: " + JPDAThreadImpl.getThreadStateLog(this.threadReference)));
                    this.suspendCount = tsc;
                }
                boolean bl = true;
                while (var4_15 < this.suspendCount) {
                    ThreadReferenceWrapper.resume(this.threadReference);
                    ++var4_15;
                }
            }
            catch (InternalExceptionWrapper tsc) {
            }
            catch (VMDisconnectedExceptionWrapper tsc) {
            }
            catch (VMDisconnectedException tsc) {
            }
            catch (ObjectCollectedExceptionWrapper tsc) {
            }
            catch (IllegalThreadStateExceptionWrapper tsc) {
                // empty catch block
            }
            this.debugger.getOperator().notifyMethodInvoking(this.threadReference);
            if (this.vm != null) {
                try {
                    EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(this.vm);
                    List<StepRequest> list = EventRequestManagerWrapper.stepRequests0(erm);
                    ArrayList<StepRequest> stepsToDelete = null;
                    for (StepRequest sr : list) {
                        ThreadReference t = StepRequestWrapper.thread(sr);
                        if (!this.threadReference.equals(t)) continue;
                        if (stepsToDelete == null) {
                            stepsToDelete = new ArrayList<StepRequest>();
                        }
                        if (!JPDAThreadImpl.checkToDisableStep(sr, t)) continue;
                        stepsToDelete.add(sr);
                    }
                    if (stepsToDelete != null) {
                        for (StepRequest sr : stepsToDelete) {
                            boolean wasEnabled = EventRequestWrapper.isEnabled0(sr);
                            EventRequestWrapper.putProperty(sr, "methodInvoking.wasEnabled", wasEnabled);
                            EventRequestWrapper.disable(sr);
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("DISABLED Step Request: " + sr);
                        }
                    }
                    this.stepsDeletedDuringMethodInvoke = stepsToDelete;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                }
                catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    // empty catch block
                }
            }
            this.methodInvoking = true;
            this.unsuspendedStateWhenInvoking = !this.isSuspended();
            evts = this.unsuspendedStateWhenInvoking ? Collections.emptyList() : this.notifyToBeRunning(false, false);
            watcherToDestroy = this.watcher;
            this.watcher = new SingleThreadWatcher(this);
        }
        finally {
            if (loggerS.isLoggable(Level.FINE)) {
                loggerS.fine("[" + this.threadName + "]: unsuspendedStateWhenInvoking = " + this.unsuspendedStateWhenInvoking);
            }
            this.accessLock.writeLock().unlock();
        }
        if (watcherToDestroy != null) {
            watcherToDestroy.destroy();
        }
        for (PropertyChangeEvent propertyChangeEvent : evts) {
            this.pch.firePropertyChange(propertyChangeEvent);
        }
        Object object = this.suspendToCheckForMonitorsLock;
        synchronized (object) {
            this.canSuspendToCheckForMonitors = true;
        }
    }

    private static boolean checkToDisableStep(StepRequest sr, ThreadReference t) {
        int threadDepth;
        int stepKind;
        try {
            stepKind = StepRequestWrapper.depth(sr);
        }
        catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        if (stepKind == 1) {
            return true;
        }
        try {
            threadDepth = ThreadReferenceWrapper.frameCount(t);
        }
        catch (IncompatibleThreadStateException | IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | InvalidStackFrameExceptionWrapper ex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        int stepDepth = StepUtils.getOriginalStepDepth(sr);
        if (stepDepth > 0) {
            return stepDepth >= threadDepth;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone() {
        PropertyChangeEvent evt;
        boolean wasUnsuspendedStateWhenInvoking;
        Object object = this.suspendToCheckForMonitorsLock;
        synchronized (object) {
            this.canSuspendToCheckForMonitors = false;
        }
        SingleThreadWatcher watcherToDestroy = null;
        this.accessLock.writeLock().lock();
        try {
            logger.log(Level.FINE, "Method invoke done in thread {0}", this.threadName);
            if (loggerS.isLoggable(Level.FINE)) {
                loggerS.fine("[" + this.threadName + "]: Method invoke done, suspended = " + this.suspended + ", suspendedNoFire = " + this.suspendedNoFire + ", suspendRequested = " + this.suspendRequested + ", unsuspendedStateWhenInvoking = " + this.unsuspendedStateWhenInvoking);
            }
            try {
                if (this.resumedToFinishMethodInvocation) {
                    ThreadReferenceWrapper.suspend(this.threadReference);
                    this.resumedToFinishMethodInvocation = false;
                }
                for (int sc = 1; sc < this.suspendCount; ++sc) {
                    ThreadReferenceWrapper.suspend(this.threadReference);
                }
            }
            catch (InternalExceptionWrapper sc) {
            }
            catch (VMDisconnectedExceptionWrapper sc) {
            }
            catch (ObjectCollectedExceptionWrapper sc) {
            }
            catch (IllegalThreadStateExceptionWrapper sc) {
                // empty catch block
            }
            this.debugger.getOperator().notifyMethodInvokeDone(this.threadReference);
            if (this.stepsDeletedDuringMethodInvoke != null) {
                try {
                    for (StepRequest sr : this.stepsDeletedDuringMethodInvoke) {
                        block27: {
                            try {
                                Object wasEnabled = EventRequestWrapper.getProperty(sr, "methodInvoking.wasEnabled");
                                if (!Boolean.TRUE.equals(wasEnabled)) break block27;
                                EventRequestWrapper.enable(sr);
                            }
                            catch (ObjectCollectedExceptionWrapper ex) {
                                continue;
                            }
                            catch (InvalidRequestStateExceptionWrapper irse) {
                                continue;
                            }
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("ENABLED Step Request: " + sr);
                    }
                }
                catch (InternalExceptionWrapper sc) {
                }
                catch (VMDisconnectedExceptionWrapper sc) {
                    // empty catch block
                }
                this.stepsDeletedDuringMethodInvoke = null;
            }
            this.methodInvoking = false;
            wasUnsuspendedStateWhenInvoking = this.unsuspendedStateWhenInvoking;
            this.unsuspendedStateWhenInvoking = false;
            JPDAThreadImpl sc = this;
            synchronized (sc) {
                this.notifyAll();
            }
            watcherToDestroy = this.watcher;
            this.watcher = null;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        if (watcherToDestroy != null) {
            watcherToDestroy.destroy();
        }
        if (!wasUnsuspendedStateWhenInvoking && (evt = this.notifySuspended(false, false, false)) != null) {
            evt.setPropagationId("methodInvoke");
            this.pch.firePropertyChange(evt);
        }
    }

    public boolean isMethodInvoking() {
        return this.methodInvoking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilMethodInvokeDone() {
        this.accessLock.readLock().lock();
        try {
            while (this.methodInvoking) {
                JPDAThreadImpl jPDAThreadImpl = this;
                synchronized (jPDAThreadImpl) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException iex) {
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilMethodInvokeDone(long timeout) throws InterruptedException {
        if (!this.accessLock.readLock().tryLock(timeout, TimeUnit.MILLISECONDS)) {
            return;
        }
        try {
            while (this.methodInvoking) {
                JPDAThreadImpl jPDAThreadImpl = this;
                synchronized (jPDAThreadImpl) {
                    this.wait(timeout);
                }
            }
            return;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public void disableMethodInvokeUntilResumed() {
        this.accessLock.writeLock().lock();
        this.methodInvokingDisabledUntilResumed = true;
        this.accessLock.writeLock().unlock();
    }

    public void setInStep(boolean inStep, EventRequest stepRequest) {
        SingleThreadWatcher watcherToDestroy = null;
        this.inStep = inStep;
        watcherToDestroy = this.watcher;
        if (inStep) {
            boolean suspendThread;
            try {
                suspendThread = EventRequestWrapper.suspendPolicy(stepRequest) == 1;
            }
            catch (InternalExceptionWrapper ex) {
                suspendThread = false;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                suspendThread = false;
            }
            if (suspendThread) {
                this.watcher = new SingleThreadWatcher(this);
            }
        } else {
            this.watcher = null;
        }
        if (watcherToDestroy != null) {
            watcherToDestroy.destroy();
        }
    }

    public boolean isInStep() {
        return this.inStep;
    }

    public void interrupt() {
        try {
            if (this.isSuspended()) {
                return;
            }
            ThreadReferenceWrapper.interrupt(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    public void makeCurrent() {
        if (Mutex.EVENT.isReadAccess()) {
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    JPDAThreadImpl.this.doMakeCurrent();
                }
            });
        } else {
            this.doMakeCurrent();
        }
    }

    private void doMakeCurrent() {
        this.debugger.setCurrentThread(this);
        Session session = this.debugger.getSession();
        DebuggerManager manager = DebuggerManager.getDebuggerManager();
        if (session != manager.getCurrentSession()) {
            manager.setCurrentSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectVariable getContendedMonitor() {
        if (!VirtualMachineWrapper.canGetCurrentContendedMonitor0(this.vm)) {
            return null;
        }
        try {
            ObjectReference or;
            this.accessLock.readLock().lock();
            try {
                if (!this.isSuspended() && !this.suspendedNoFire) {
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                if ("DestroyJavaVM".equals(this.threadName)) {
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                try {
                    or = ThreadReferenceWrapper.currentContendedMonitor(this.threadReference);
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                catch (IncompatibleThreadStateException e) {
                    Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, this.getThreadStateLog(), e);
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                catch (InternalException iex) {
                    Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, this.getThreadStateLog(), iex);
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
            }
            finally {
                this.accessLock.readLock().unlock();
            }
            if (or != null) return new ThisVariable(this.debugger, or, "" + ObjectReferenceWrapper.uniqueID(or));
            return null;
        }
        catch (InternalExceptionWrapper e) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
    }

    public MonitorInfo getContendedMonitorAndOwner() {
        ObjectVariable monitor = this.getContendedMonitor();
        if (monitor == null) {
            return null;
        }
        MonitorInfo monitorInfo = null;
        JPDAThread thread = null;
        List<JPDAThread> threads = this.debugger.getThreadsCollector().getAllThreads();
        for (JPDAThread t : threads) {
            ObjectVariable[] ms;
            if (this == t) continue;
            block1: for (ObjectVariable m : ms = t.getOwnedMonitors()) {
                if (!monitor.equals((Object)m)) continue;
                thread = t;
                List mf = t.getOwnedMonitorsAndFrames();
                for (MonitorInfo mi : mf) {
                    if (!monitor.equals((Object)mi.getMonitor())) continue;
                    monitorInfo = mi;
                    break block1;
                }
                break;
            }
            if (thread == null) continue;
            break;
        }
        if (monitorInfo != null) {
            return monitorInfo;
        }
        return new MonitorInfoImpl(thread, null, monitor);
    }

    /*
     * Exception decompiling
     */
    public ObjectVariable[] getOwnedMonitors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public synchronized ReturnVariableImpl getReturnVariable() {
        return this.returnVariable;
    }

    public synchronized void setReturnVariable(ReturnVariableImpl returnVariable) {
        this.returnVariable = returnVariable;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pch.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pch.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        if (PROP_OPERATIONS_SET.equals(name) || PROP_OPERATIONS_UPDATE.equals(name)) {
            this.operationsPch.addPropertyChangeListener(name, pcl);
        } else {
            this.pch.addPropertyChangeListener(name, pcl);
        }
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        if (PROP_OPERATIONS_SET.equals(name) || PROP_OPERATIONS_UPDATE.equals(name)) {
            this.operationsPch.removePropertyChangeListener(name, pcl);
        } else {
            this.pch.removePropertyChangeListener(name, pcl);
        }
    }

    private void fireSuspended(boolean suspended) {
        this.pch.firePropertyChange("suspended", (Object)(!suspended ? 1 : 0), (Object)suspended);
    }

    private void fireOperationsChanged(String name) {
        this.operationsPch.firePropertyChange(name, null, null);
    }

    @Override
    public void setObject(Object bean) {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing Customizer interface just because of add/remove PropertyChangeListener.");
    }

    @Override
    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing BeanContextChild interface just because of add/remove PropertyChangeListener.");
    }

    @Override
    public BeanContext getBeanContext() {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing BeanContextChild interface just because of add/remove PropertyChangeListener.");
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing BeanContextChild interface just because of add/remove PropertyChangeListener.");
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing BeanContextChild interface just because of add/remove PropertyChangeListener.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitorInfo> getOwnedMonitorsAndFrames() {
        if (VirtualMachineWrapper.canGetMonitorFrameInfo0(this.vm)) {
            this.accessLock.readLock().lock();
            try {
                if (!this.isSuspended() && !this.suspendedNoFire || this.getState() == 0) {
                    List<MonitorInfo> list = Collections.emptyList();
                    return list;
                }
                Object object = this.ownedMonitorsAndFramesSingleAccessLock;
                synchronized (object) {
                    block15: {
                        List<com.sun.jdi.MonitorInfo> monitorInfos = ThreadReferenceWrapper.ownedMonitorsAndFrames0(this.threadReference);
                        if (monitorInfos == null || monitorInfos.size() <= 0) break block15;
                        ArrayList<MonitorInfo> mis = new ArrayList<MonitorInfo>(monitorInfos.size());
                        for (com.sun.jdi.MonitorInfo monitorInfo : monitorInfos) {
                            MonitorInfo mi = this.createMonitorInfo(monitorInfo);
                            if (mi == null) continue;
                            mis.add(mi);
                        }
                        List list = Collections.unmodifiableList(mis);
                        return list;
                    }
                }
            }
            catch (IncompatibleThreadStateException ex) {
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, this.getThreadStateLog(), ex);
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            }
            finally {
                this.accessLock.readLock().unlock();
            }
        }
        return Collections.emptyList();
    }

    private MonitorInfo createMonitorInfo(com.sun.jdi.MonitorInfo mi) {
        try {
            int depth = MonitorInfoWrapper.stackDepth(mi);
            CallStackFrame frame = null;
            if (depth >= 0) {
                try {
                    CallStackFrame[] frames = this.getCallStack(depth, depth + 1);
                    if (frames.length > 0) {
                        frame = frames[0];
                    }
                }
                catch (AbsentInformationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ObjectReference or = MonitorInfoWrapper.monitor(mi);
            ThisVariable monitor = new ThisVariable(this.debugger, or, "" + ObjectReferenceWrapper.uniqueID(or));
            return new MonitorInfoImpl(this, frame, monitor);
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean checkForBlockingThreads() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 37[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<List<JPDAThread>, List<JPDAThread>> updateLockerThreads(Map<ThreadReference, ObjectReference> lockedThreadsWithMonitors, ObjectReference waitingMonitor) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        List<JPDAThread> newLockerThreadsList;
        List<JPDAThread> oldLockerThreadsList;
        Object object = this.lockerThreadsLock;
        synchronized (object) {
            oldLockerThreadsList = this.lockerThreadsList;
            if (lockedThreadsWithMonitors != null) {
                this.lockerThreadsMonitor = waitingMonitor;
                if (!this.submitMonitorEnteredFor(waitingMonitor)) {
                    this.submitCheckForMonitorEntered(waitingMonitor);
                }
                this.lockerThreadsList = new ThreadListDelegate(this.debugger, new ArrayList<ThreadReference>(lockedThreadsWithMonitors.keySet()));
            } else {
                this.lockerThreadsMonitor = null;
                this.lockerThreadsList = null;
            }
            newLockerThreadsList = this.lockerThreadsList;
        }
        return Pair.of(oldLockerThreadsList, newLockerThreadsList);
    }

    private static Map<ThreadReference, ObjectReference> findLockPath(VirtualMachine vm, ThreadReference tr, boolean suspendedAll, ObjectReference waitingMonitor) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        ThreadReference t;
        LinkedHashMap<ThreadReference, ObjectReference> threadsWithMonitors = new LinkedHashMap<ThreadReference, ObjectReference>();
        HashMap<ObjectReference, ThreadReference> monitorMap = new HashMap<ObjectReference, ThreadReference>();
        for (ThreadReference t2 : VirtualMachineWrapper.allThreads(vm)) {
            List<ObjectReference> monitors;
            if (!suspendedAll && !ThreadReferenceWrapper.isSuspended0(t2)) continue;
            try {
                monitors = ThreadReferenceWrapper.ownedMonitors0(t2);
            }
            catch (IncompatibleThreadStateException | IllegalThreadStateExceptionWrapper ex) {
                continue;
            }
            if (monitors == null) continue;
            for (ObjectReference m : monitors) {
                monitorMap.put(m, t2);
            }
        }
        while (waitingMonitor != null && (t = (ThreadReference)monitorMap.get(waitingMonitor)) != null) {
            if (ThreadReferenceWrapper.suspendCount(t) > (suspendedAll ? 1 : 0)) {
                threadsWithMonitors.put(t, waitingMonitor);
            }
            waitingMonitor = ThreadReferenceWrapper.currentContendedMonitor(t);
        }
        if (threadsWithMonitors.size() > 0) {
            return threadsWithMonitors;
        }
        return null;
    }

    public synchronized List<JPDAThread> getLockerThreads() {
        return this.lockerThreadsList;
    }

    public JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeBlockingThreads() {
        ArrayList<JPDAThread> blockingThreads;
        Object object = this.lockerThreadsLock;
        synchronized (object) {
            if (this.lockerThreadsList == null) {
                return;
            }
            blockingThreads = new ArrayList<JPDAThread>(this.lockerThreadsList);
        }
        ArrayList<ThreadReference> resumedThreads = new ArrayList<ThreadReference>(blockingThreads.size());
        for (JPDAThread t : blockingThreads) {
            if (!t.isSuspended()) continue;
            t.resume();
            resumedThreads.add(((JPDAThreadImpl)t).getThreadReference());
        }
        Object object2 = this.lockerThreadsLock;
        synchronized (object2) {
            this.resumedBlockingThreads = resumedThreads;
        }
    }

    private void submitMonitorEnteredRequest(EventRequest monitorEnteredRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        EventRequestWrapper.setSuspendPolicy(monitorEnteredRequest, 2);
        EventRequestWrapper.putProperty(monitorEnteredRequest, "silent", Boolean.TRUE);
        this.debugger.getOperator().register(monitorEnteredRequest, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean exec(Event event) {
                List threadsToSuspend;
                List oldLockerThreadsList;
                try {
                    try {
                        EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(JPDAThreadImpl.this.vm), EventWrapper.request(event));
                    }
                    catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                        // empty catch block
                    }
                    JPDAThreadImpl.this.debugger.getOperator().unregister(EventWrapper.request(event));
                }
                catch (InternalExceptionWrapper ex) {
                    return true;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return true;
                }
                Iterator iterator = JPDAThreadImpl.this.lockerThreadsLock;
                synchronized (iterator) {
                    oldLockerThreadsList = JPDAThreadImpl.this.lockerThreadsList;
                    JPDAThreadImpl.this.lockerThreadsMonitor = null;
                    JPDAThreadImpl.this.lockerThreadsList = null;
                    threadsToSuspend = JPDAThreadImpl.this.resumedBlockingThreads;
                }
                JPDAThreadImpl.this.pch.firePropertyChange(JPDAThreadImpl.PROP_LOCKER_THREADS, oldLockerThreadsList, null);
                if (threadsToSuspend != null) {
                    for (ThreadReference tr : threadsToSuspend) {
                        JPDAThreadImpl t;
                        try {
                            ThreadReferenceWrapper.suspend(tr);
                        }
                        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                        }
                        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            // empty catch block
                        }
                        if ((t = JPDAThreadImpl.this.debugger.getExistingThread(tr)) == null) continue;
                        t.notifySuspended();
                    }
                }
                if (JPDAThreadImpl.this.isMethodInvoking()) {
                    JPDAThreadImpl.this.debugger.getRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            JPDAThreadImpl.this.accessLock.writeLock().lock();
                            try {
                                logger.fine("Resuming thread " + JPDAThreadImpl.this.threadName + " to finish method invoke...");
                                JPDAThreadImpl.this.resumedToFinishMethodInvocation = true;
                                ThreadReferenceWrapper.resume(JPDAThreadImpl.this.threadReference);
                            }
                            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                            }
                            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            }
                            catch (Exception e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                            finally {
                                JPDAThreadImpl.this.accessLock.writeLock().unlock();
                            }
                        }
                    }, 200);
                }
                return true;
            }

            @Override
            public void removed(EventRequest eventRequest) {
            }
        });
        try {
            EventRequestWrapper.enable(monitorEnteredRequest);
        }
        catch (InternalExceptionWrapper ex) {
            this.debugger.getOperator().unregister(monitorEnteredRequest);
            throw ex;
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            this.debugger.getOperator().unregister(monitorEnteredRequest);
            throw ocex;
        }
        catch (InvalidRequestStateExceptionWrapper irse) {
            Exceptions.printStackTrace((Throwable)irse);
        }
    }

    private boolean submitMonitorEnteredFor(ObjectReference waitingMonitor) {
        if (!VirtualMachineWrapper.canRequestMonitorEvents0(this.vm)) {
            return false;
        }
        try {
            MonitorContendedEnteredRequest monitorEnteredRequest = EventRequestManagerWrapper.createMonitorContendedEnteredRequest(VirtualMachineWrapper.eventRequestManager(this.vm));
            MonitorContendedEnteredRequestWrapper.addThreadFilter(monitorEnteredRequest, this.threadReference);
            this.submitMonitorEnteredRequest(monitorEnteredRequest);
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCheckForMonitorEntered(ObjectReference waitingMonitor) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        try {
            ThreadReferenceWrapper.suspend(this.threadReference);
            logger.fine("submitCheckForMonitorEntered(): suspending " + this.threadName);
            ObjectReference monitor = ThreadReferenceWrapper.currentContendedMonitor(this.threadReference);
            if (monitor == null) {
                return;
            }
            Location loc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0));
            if ((loc = MethodWrapper.locationOfCodeIndex(LocationWrapper.method(loc), LocationWrapper.codeIndex(loc) + 1L)) == null) {
                return;
            }
            BreakpointRequest br = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(this.threadReference)), loc);
            BreakpointRequestWrapper.addThreadFilter(br, this.threadReference);
            this.submitMonitorEnteredRequest(br);
        }
        catch (IncompatibleThreadStateException itex) {
            Exceptions.printStackTrace((Throwable)itex);
        }
        catch (InvalidStackFrameExceptionWrapper isex) {
            Exceptions.printStackTrace((Throwable)isex);
        }
        finally {
            logger.fine("submitCheckForMonitorEntered(): resuming " + this.threadName);
            ThreadReferenceWrapper.resume(this.threadReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepSuspendedBy(JPDABreakpoint breakpoint, boolean fire, List<JPDAThreadImpl> steppingThreads) {
        Iterator<JPDAThreadImpl> iterator = this.stepBreakpointLock;
        synchronized (iterator) {
            this.stepSuspendedByBreakpoint = breakpoint;
            if (this.suspendedSteppingThreads == null) {
                this.suspendedSteppingThreads = new HashSet<JPDAThreadImpl>();
            }
            this.suspendedSteppingThreads.addAll(steppingThreads);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("setStepSuspendedBy(" + this.threadReference + "): stepSuspendedByBreakpoint = " + this.stepSuspendedByBreakpoint + ", steppingThreads = " + steppingThreads);
            }
        }
        for (JPDAThreadImpl st : steppingThreads) {
            st.addSteppingSuspendedBy(this);
        }
        if (fire) {
            this.pch.firePropertyChange(PROP_STEP_SUSPENDED_BY_BREAKPOINT, null, breakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSteppingSuspendedBy(JPDAThreadImpl thread) {
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            if (this.steppingSuspendedByBptsInThreads == null) {
                this.steppingSuspendedByBptsInThreads = new HashSet<JPDAThreadImpl>();
            }
            this.steppingSuspendedByBptsInThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetSteppingSuspendedByBpts() {
        Set<JPDAThreadImpl> suspByThreads;
        Iterator<JPDAThreadImpl> iterator = this.stepBreakpointLock;
        synchronized (iterator) {
            suspByThreads = this.steppingSuspendedByBptsInThreads;
            this.steppingSuspendedByBptsInThreads = null;
        }
        if (suspByThreads != null) {
            for (JPDAThreadImpl t : suspByThreads) {
                t.unsetStepSuspendedByBpIn(this);
            }
        }
        return suspByThreads != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetStepSuspendedByBpIn(JPDAThreadImpl thread) {
        JPDABreakpoint oldBp;
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            oldBp = this.stepSuspendedByBreakpoint;
            this.stepSuspendedByBreakpoint = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("unsetStepSuspendedByBp(" + this.threadReference + "): stepSuspendedByBreakpoint = " + this.stepSuspendedByBreakpoint);
            }
            if (this.suspendedSteppingThreads != null) {
                this.suspendedSteppingThreads.remove(thread);
                if (this.suspendedSteppingThreads.isEmpty()) {
                    this.suspendedSteppingThreads = null;
                }
            }
        }
        if (oldBp != null) {
            this.pch.firePropertyChange(PROP_STEP_SUSPENDED_BY_BREAKPOINT, oldBp, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPDABreakpoint removeSuspendedByBreakpoint() {
        JPDABreakpoint brkp = null;
        Set<JPDAThreadImpl> steppingThreads = null;
        Iterator<JPDAThreadImpl> iterator = this.stepBreakpointLock;
        synchronized (iterator) {
            if (this.stepSuspendedByBreakpoint != null) {
                brkp = this.stepSuspendedByBreakpoint;
                this.stepSuspendedByBreakpoint = null;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("removeSuspendedByBreakpoint(" + this.threadReference + "): stepSuspendedByBreakpoint = " + this.stepSuspendedByBreakpoint);
                }
            }
            if (this.suspendedSteppingThreads != null) {
                steppingThreads = this.suspendedSteppingThreads;
                this.suspendedSteppingThreads = null;
            }
        }
        if (steppingThreads != null) {
            for (JPDAThreadImpl t : steppingThreads) {
                t.removeSteppingSuspendedBy(this);
            }
        }
        return brkp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSteppingSuspendedBy(JPDAThreadImpl thread) {
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            if (this.steppingSuspendedByBptsInThreads != null) {
                this.steppingSuspendedByBptsInThreads.remove(thread);
                if (this.steppingSuspendedByBptsInThreads.isEmpty()) {
                    this.steppingSuspendedByBptsInThreads = null;
                }
            }
        }
    }

    public String getThreadStateLog() {
        return JPDAThreadImpl.getThreadStateLog(this.threadReference) + ", internal suspend status = " + this.suspended + ", suspendedNoFire = " + this.suspendedNoFire + ", suspendedOnAnEvent = " + this.suspendedOnAnEvent + ", invoking a method = " + this.methodInvoking + ", is in step = " + this.inStep;
    }

    public static String getThreadStateLog(ThreadReference threadReference) {
        String isAtBreakpoint;
        String suspendCount;
        String isSuspended;
        String status;
        String name;
        try {
            name = ThreadReferenceWrapper.name(threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            Throwable t = ex.getCause();
            name = "<" + t.getClass() + ":" + t.getLocalizedMessage() + ">";
        }
        try {
            status = Integer.toString(ThreadReferenceWrapper.status(threadReference));
        }
        catch (IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            Throwable t = ex.getCause();
            status = "<" + t.getClass() + ":" + t.getLocalizedMessage() + ">";
        }
        try {
            isSuspended = Boolean.toString(ThreadReferenceWrapper.isSuspended(threadReference));
        }
        catch (IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            Throwable t = ex.getCause();
            isSuspended = "<" + t.getClass() + ":" + t.getLocalizedMessage() + ">";
        }
        try {
            suspendCount = Integer.toString(ThreadReferenceWrapper.suspendCount(threadReference));
        }
        catch (IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            Throwable t = ex.getCause();
            suspendCount = "<" + t.getClass() + ":" + t.getLocalizedMessage() + ">";
        }
        try {
            isAtBreakpoint = Boolean.toString(ThreadReferenceWrapper.isAtBreakpoint(threadReference));
        }
        catch (IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            Throwable t = ex.getCause();
            isAtBreakpoint = "<" + t.getClass() + ":" + t.getLocalizedMessage() + ">";
        }
        String msg = "Thread '" + name + "': status = " + status + ", is suspended = " + isSuspended + ", suspend count = " + suspendCount + ", is at breakpoint = " + isAtBreakpoint;
        return msg;
    }

    public String toString() {
        return "'" + this.getName() + "' (" + Integer.toHexString(System.identityHashCode(this)) + ") from DBG(" + Integer.toHexString(((Object)((Object)this.debugger)).hashCode()) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingAction(Object action) {
        Object object = this.pendingActionsLock;
        synchronized (object) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} setPendingAction({1})", new Object[]{this.threadName, action});
            }
            this.pendingAction = action;
            this.pendingVariable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPendingAction() {
        Object object = this.pendingActionsLock;
        synchronized (object) {
            return this.pendingAction;
        }
    }

    public String getPendingString(Object action) {
        return NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_PendingAction", (Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable getPendingVariable(Object action) {
        Variable var;
        Object object = this.pendingActionsLock;
        synchronized (object) {
            var = action == this.pendingAction ? this.pendingVariable : null;
        }
        if (var == null) {
            StringReference sr = this.threadReference.virtualMachine().mirrorOf(this.getPendingString(action));
            var = new AbstractObjectVariable(this.debugger, sr, null);
        }
        object = this.pendingActionsLock;
        synchronized (object) {
            if (action == this.pendingAction) {
                this.pendingVariable = var;
            }
        }
        return var;
    }

    private class ThreadReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        private final ReentrantReadWriteLock.ReadLock readerLock;
        private final ReentrantReadWriteLock.WriteLock writerLock;

        private ThreadReentrantReadWriteLock() {
            super(true);
            this.readerLock = new ThreadReadLock();
            this.writerLock = new ThreadWriteLock();
        }

        @Override
        public ReentrantReadWriteLock.ReadLock readLock() {
            return this.readerLock;
        }

        @Override
        public ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writerLock;
        }

        private class ThreadReadLock
        extends ReentrantReadWriteLock.ReadLock {
            private ThreadReadLock() {
                super(ThreadReentrantReadWriteLock.this);
            }

            @Override
            public void lock() {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lock();
                super.lock();
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lockInterruptibly();
                try {
                    super.lockInterruptibly();
                }
                catch (InterruptedException iex) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                    throw iex;
                }
            }

            @Override
            public boolean tryLock() {
                boolean locked = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock();
                if (locked && !(locked = super.tryLock())) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return locked;
            }

            @Override
            public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
                boolean locked = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock(timeout, unit);
                if (locked && !(locked = super.tryLock(timeout, unit))) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return locked;
            }

            @Override
            public void unlock() {
                super.unlock();
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
            }
        }

        private class ThreadWriteLock
        extends ReentrantReadWriteLock.WriteLock {
            private ThreadWriteLock() {
                super(ThreadReentrantReadWriteLock.this);
            }

            @Override
            public void lock() {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lock();
                super.lock();
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lockInterruptibly();
                try {
                    super.lockInterruptibly();
                }
                catch (InterruptedException iex) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                    throw iex;
                }
            }

            @Override
            public boolean tryLock() {
                boolean locked = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock();
                if (locked && !(locked = super.tryLock())) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return locked;
            }

            @Override
            public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
                boolean locked = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock(timeout, unit);
                if (locked && !(locked = super.tryLock(timeout, unit))) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return locked;
            }

            @Override
            public void unlock() {
                super.unlock();
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
            }
        }
    }

    private static class ThreadListDelegate
    extends AbstractList<JPDAThread> {
        private List<ThreadReference> threads;
        private JPDADebuggerImpl debugger;

        public ThreadListDelegate(JPDADebuggerImpl debugger, List<ThreadReference> threads) {
            this.debugger = debugger;
            this.threads = threads;
        }

        @Override
        public JPDAThread get(int index) {
            return this.debugger.getThread(this.threads.get(index));
        }

        @Override
        public int size() {
            return this.threads.size();
        }
    }
}

