/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import javax.lang.model.element.Element;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.beans.BeanPanel;
import org.netbeans.modules.beans.BeanScanningTask;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.PatternNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BeanPanelUI
extends JPanel
implements ExplorerManager.Provider {
    private static WaitNode WAIT_NODE;
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private JLabel filtersLbl;
    private Lookup lookup = null;
    private Action[] actions;
    private static final Rectangle ZERO;

    public BeanPanelUI() {
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.manager.setRootContext(BeanPanelUI.getWaitNode());
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return result;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public BeanScanningTask getTask() {
        return new BeanScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BeanPanelUI.this.elementView.setRootVisible(true);
                BeanPanelUI.this.manager.setRootContext(BeanPanelUI.getWaitNode());
            }
        });
    }

    public void selectElementNode(ElementHandle<Element> eh) {
    }

    public void refresh(final ClassPattern pa) {
        final PatternNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getPattern().getPatternAnalyser().getFileObject().equals(pa.getPatternAnalyser().getFileObject())) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ BeanPanelUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    rootNode.updateRecursively(pa);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ BeanPanelUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.elementView.setRootVisible(false);
                    this.this$0.manager.setRootContext((Node)new PatternNode(pa, true));
                    boolean scrollOnExpand = this.this$0.elementView.getScrollOnExpand();
                    this.this$0.elementView.setScrollOnExpand(false);
                    this.this$0.elementView.expandAll();
                    this.this$0.elementView.setScrollOnExpand(scrollOnExpand);
                }
            });
        }
    }

    public void sort() {
        throw new UnsupportedOperationException();
    }

    public void expandNode(Node n) {
        this.elementView.expandNode(n);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getPattern().getPatternAnalyser().getFileObject();
    }

    public void filterStateChanged(ChangeEvent e) {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private PatternNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof PatternNode) {
            return (PatternNode)n;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView btv = new MyBeanTreeView();
        return btv;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    static {
        ZERO = new Rectangle(0, 0, 1, 1);
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(BeanPanel.class, (String)"LBL_WaitNode");
        }
    }
}

