/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.nodejs;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.api.DebuggerOptions;
import org.netbeans.modules.javascript.nodejs.spi.DebuggerStartModifier;
import org.netbeans.modules.javascript.v8debug.api.Connector;
import org.netbeans.modules.javascript.v8debug.nodejs.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class DebuggerStartModifierImpl
implements DebuggerStartModifier {
    private static final Logger LOG = Logger.getLogger(DebuggerStartModifierImpl.class.getName());
    private static final String DEBUG_BRK_COMMAND = "--debug-brk=%d";
    private static final String DEBUG_COMMAND = "--debug=%d";
    private final List<String> localPaths;
    private final List<String> serverPaths;
    private final List<String> localPathsExclusionFilter;
    private final Project project;
    private final AtomicReference<Future<Integer>> taskRef;
    private boolean processingDone;
    private int port;

    public DebuggerStartModifierImpl(Project project, List<String> localPaths, List<String> serverPaths, List<String> localPathsExclusionFilter, AtomicReference<Future<Integer>> taskRef) {
        this.localPaths = localPaths;
        this.serverPaths = serverPaths;
        this.localPathsExclusionFilter = localPathsExclusionFilter;
        this.project = project;
        this.taskRef = taskRef;
    }

    void connectDebugger() {
        Connector.Properties props = new Connector.Properties("localhost", this.port, this.localPaths, this.serverPaths, this.localPathsExclusionFilter);
        try {
            Connector.connect(props, new Runnable(){

                @Override
                public void run() {
                    Future task = (Future)DebuggerStartModifierImpl.this.taskRef.get();
                    assert (task != null) : DebuggerStartModifierImpl.access$100(DebuggerStartModifierImpl.this).getProjectDirectory();
                    task.cancel(true);
                }
            });
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "cannot run node.js debugger", ex);
            this.warnCannotDebug(ex);
        }
    }

    public List<String> getArguments(Lookup context) {
        this.port = this.allocateServerPort();
        if (DebuggerOptions.getInstance().isBreakAtFirstLine()) {
            return Collections.singletonList(String.format(DEBUG_BRK_COMMAND, this.port));
        }
        return Collections.singletonList(String.format(DEBUG_COMMAND, this.port));
    }

    public void processOutputLine(String line) {
        if (line != null && line.toLowerCase(Locale.US).startsWith("debugger listening on ")) {
            this.connectDebugger();
            this.processingDone = true;
        }
    }

    public boolean startProcessingDone() {
        return this.processingDone;
    }

    private int allocateServerPort() {
        int n;
        ServerSocket ss = new ServerSocket(0);
        try {
            ss.setReuseAddress(true);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return 0;
            }
        }
        ss.close();
        return n;
    }

    protected void warnCannotDebug(IOException ex) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)Bundle.warn_debug(ex), 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
    }

    static /* synthetic */ Project access$100(DebuggerStartModifierImpl x0) {
        return x0.project;
    }
}

