/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.vp;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Optional;
import org.keycloak.sdjwt.ClaimVerifier;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;

public class KeyBindingJwtVerificationOpts
extends IssuerSignedJwtVerificationOpts {
    private final boolean keyBindingRequired;
    private final int allowedMaxAge;

    public KeyBindingJwtVerificationOpts(boolean keyBindingRequired, int allowedMaxAge, List<ClaimVerifier.Predicate<ObjectNode>> headerVerifiers, List<ClaimVerifier.Predicate<ObjectNode>> contentVerifiers) {
        super(headerVerifiers, contentVerifiers);
        this.keyBindingRequired = keyBindingRequired;
        this.allowedMaxAge = allowedMaxAge;
    }

    public boolean isKeyBindingRequired() {
        return this.keyBindingRequired;
    }

    public int getAllowedMaxAge() {
        return this.allowedMaxAge;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Integer clockSkew) {
        return new Builder(clockSkew);
    }

    public static class Builder
    extends IssuerSignedJwtVerificationOpts.Builder {
        private boolean keyBindingRequired = true;

        public Builder() {
        }

        public Builder(Integer clockSkew) {
            super(clockSkew);
        }

        public Builder withKeyBindingRequired(boolean keyBindingRequired) {
            this.keyBindingRequired = keyBindingRequired;
            return this;
        }

        public Builder withNonceCheck(String expectedNonce) {
            return this.withClaimCheck("nonce", expectedNonce, true);
        }

        @Override
        public Builder withAudCheck(String expectedAud) {
            return (Builder)super.withAudCheck(expectedAud);
        }

        @Override
        public Builder withIatCheck(Integer allowedMaxAge) {
            return (Builder)super.withIatCheck(allowedMaxAge);
        }

        @Override
        public Builder withIatCheck(boolean isCheckOptional) {
            return (Builder)super.withIatCheck(isCheckOptional);
        }

        @Override
        public Builder withIatCheck(Integer allowedMaxAge, boolean isCheckOptional) {
            return (Builder)super.withIatCheck(allowedMaxAge, isCheckOptional);
        }

        @Override
        public Builder withNbfCheck() {
            return (Builder)super.withNbfCheck();
        }

        @Override
        public Builder withNbfCheck(boolean isCheckOptional) {
            return (Builder)super.withNbfCheck(isCheckOptional);
        }

        @Override
        public Builder withExpCheck() {
            return (Builder)super.withExpCheck();
        }

        @Override
        public Builder withExpCheck(boolean isCheckOptional) {
            return (Builder)super.withExpCheck(isCheckOptional);
        }

        @Override
        public Builder withClockSkew(int clockSkew) {
            return (Builder)super.withClockSkew(clockSkew);
        }

        @Override
        public Builder withClaimCheck(String claimName, String expectedValue) {
            return (Builder)super.withClaimCheck(claimName, expectedValue);
        }

        @Override
        public Builder withClaimCheck(String claimName, String expectedValue, boolean isOptionalCheck) {
            return (Builder)super.withClaimCheck(claimName, expectedValue, isOptionalCheck);
        }

        @Override
        public Builder withContentVerifiers(List<ClaimVerifier.Predicate<ObjectNode>> contentVerifiers) {
            return (Builder)super.withContentVerifiers((List)contentVerifiers);
        }

        @Override
        public Builder addContentVerifiers(List<ClaimVerifier.Predicate<ObjectNode>> contentVerifiers) {
            return (Builder)super.addContentVerifiers((List)contentVerifiers);
        }

        @Override
        public KeyBindingJwtVerificationOpts build() {
            boolean isAudCheckPresent = this.contentVerifiers.stream().anyMatch(verifier -> verifier instanceof ClaimVerifier.AudienceCheck || verifier instanceof ClaimVerifier.ClaimCheck && ((ClaimVerifier.ClaimCheck)verifier).getClaimName().equals("aud"));
            boolean isNonceCheckPresent = this.contentVerifiers.stream().anyMatch(verifier -> verifier instanceof ClaimVerifier.ClaimCheck && ((ClaimVerifier.ClaimCheck)verifier).getClaimName().equals("nonce") && Optional.ofNullable(((ClaimVerifier.ClaimCheck)verifier).getExpectedClaimValue()).map(s -> !s.isEmpty()).orElse(false) != false);
            if (!(!this.keyBindingRequired || isAudCheckPresent && isNonceCheckPresent)) {
                throw new IllegalArgumentException("Missing `nonce` and `aud` claims for replay protection");
            }
            return new KeyBindingJwtVerificationOpts(this.keyBindingRequired, this.allowedMaxAge, this.headerVerifiers, this.contentVerifiers);
        }
    }
}

