/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M34;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

class PointGroup {
    private Lst<Operation> operations;
    static final Map<Integer, BS> bsUnique = new Hashtable<Integer, BS>();
    static final int OPERATION_PLANE = 0;
    static final int OPERATION_PROPER_AXIS = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames = new String[]{"plane", "proper axis", "improper axis", "center of inversion"};
    static final M3 mInv = M3.newA9(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f});
    private static final int[] axesMaxN = new int[]{49, 0, 0, 1, 3, 1, 10, 1, 1, 0, 6, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 49, 10, 6, 6, 10, 1, 1};
    private static final int[] nUnique = new int[]{1, 0, 0, 2, 2, 4, 2, 1, 1, 0, 6, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 2, 2, 4, 2, 6, 4};
    private static final int cs = 0;
    private static final int ci = 1;
    private static final int s3 = 3;
    private static final int s4 = 4;
    private static final int s5 = 5;
    private static final int s6 = 6;
    private static final int s7 = 6;
    private static final int s8 = 8;
    private static final int s10 = 10;
    private static final int s12 = 12;
    private static final int s14 = 14;
    private static final int s16 = 16;
    private static final int firstProper = 20;
    private static final int c2 = 22;
    private static final int c3 = 23;
    private static final int c4 = 24;
    private static final int c5 = 25;
    private static final int c6 = 26;
    private static final int c7 = 27;
    private static final int c8 = 28;
    private static final int maxAxis = axesMaxN.length;
    private int maxAtoms = 250;
    private int maxElement = 0;
    private int[] eCounts;
    private int nOps = 0;
    private boolean isAtoms;
    private CubeIterator iter;
    private String drawType = "";
    private int drawIndex;
    private float scale = Float.NaN;
    private int[] nAxes = new int[maxAxis];
    private Operator[][] axes = new Operator[maxAxis][];
    private int nAtoms;
    private float radius;
    protected float distanceTolerance = 0.25f;
    private float distanceTolerance2;
    private float linearTolerance = 8.0f;
    private float cosTolerance = 0.99f;
    private String name = "C_1?";
    private Operator principalAxis;
    private Operator principalPlane;
    private Lst<Operator> highOperations;
    private String drawInfo;
    private Map<String, Object> info;
    private String textInfo;
    private static final int CONVENTION_SCHOENFLIES = 0;
    private static final int CONVENTION_HERMANN_MAUGUIN = 1;
    private int convention = 0;
    private final V3 vTemp = new V3();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private T3 center;
    protected T3[] points;
    private int[] elements;
    private int[] atomMap;
    private BS bsAtoms;
    private boolean haveVibration;
    private boolean localEnvOnly;
    private boolean isLinear;
    private float sppa;
    private boolean isSpinGroup;
    private int highestOrder;
    private int modelIndex;
    private String drawID;
    private String type;
    private int index;
    private float scaleFactor;
    private static final String[] SF2HM = "Cn,1,2,3,4,5,6,7,8,9,10,11,12|Cnv,m,2m,3m,4mm,5m,6mm,7m,8mm,9m,10mm,11m,12mm,\u221em|Sn,,-1,-6,-4,(-10),-3,(-14),-8,(-18),-5,(-22),(-12)|Cnh,m,2/m,-6,4/m,-10,6/m,-14,8/m,-18,10/m,-22,12/m|Dn,,222,32,422,52,622,72,822,92,(10)22,(11)2,(12)22|Dnd,,-42m,-3m,-82m,-5m,(-12)2m,-7m,(-16)2m,-9m,(-20)2m,(-11)m,(-24)2m|Dnh,,mmm,-6m2,4/mmm,(-10)m2,6/mmm,(-14)m2,8/mmm,(-18)m2,10/mmm,(-22)m2,12/mmm,\u221e/mm|Ci,-1|Cs,m|T,23|Th,m-3|Td,-43m|O,432|Oh,m-3m".split("\\|");
    private static Map<String, String> htSFToHM;

    Operator newInversionCenter(int index) {
        return new Operator(index, null, -1);
    }

    Operator newPlane(int index, V3 v) {
        return new Operator(index, v, -1);
    }

    Operator newAxis(int index, V3 v, int arrayIndex) {
        return new Operator(index, v, arrayIndex);
    }

    protected static BS getUniqueFractions(int order) {
        BS bs = bsUnique.get(order);
        if (bs != null) {
            return bs;
        }
        bs = BSUtil.newBitSet2(1, order);
        int n = order / 2;
        for (int i = 1; i <= n; ++i) {
            int f = order / i;
            if (f * i != order || !bs.get(f)) continue;
            for (int j = f; j <= n; j += f) {
                bs.clear(j);
                bs.clear(order - j);
            }
        }
        bsUnique.put(order, bs);
        return bs;
    }

    static PointGroup getPointGroup(PointGroup pgLast, T3 center, T3[] atomset, BS bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance, int maxAtoms, boolean localEnvOnly, boolean isHM, float sppa) {
        PointGroup pg = new PointGroup(isHM);
        if (distanceTolerance <= 0.0f) {
            distanceTolerance = 0.01f;
        }
        if (linearTolerance <= 0.0f) {
            linearTolerance = 0.5f;
        }
        if (maxAtoms <= 0) {
            maxAtoms = 250;
        }
        pg.distanceTolerance = distanceTolerance;
        pg.distanceTolerance2 = distanceTolerance * distanceTolerance;
        pg.linearTolerance = linearTolerance;
        pg.maxAtoms = maxAtoms;
        pg.isAtoms = bsAtoms != null;
        pg.bsAtoms = pg.isAtoms ? bsAtoms : BSUtil.newBitSet2(0, atomset.length);
        pg.haveVibration = haveVibration;
        pg.center = center;
        pg.localEnvOnly = localEnvOnly;
        pg.sppa = sppa;
        if (Logger.debugging) {
            pgLast = null;
        }
        return pg.set(pgLast, atomset) ? pg : pgLast;
    }

    private PointGroup(boolean isHM) {
        this.convention = isHM ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(PointGroup pgLast, T3[] atomset) {
        boolean i;
        this.cosTolerance = (float)Math.cos((double)(this.linearTolerance / 180.0f) * Math.PI);
        if (!this.getPointsAndElements(atomset)) {
            Logger.error("Too many atoms for point group calculation");
            this.name = "point group not determined -- ac > " + this.maxAtoms + " -- select fewer atoms and try again.";
            return true;
        }
        this.getElementCounts();
        P3[] atomVibs = new P3[this.points.length];
        for (i = false; i < this.points.length; i += 1) {
            atomVibs[i] = P3.newP(this.points[i]);
            Vibration v = ((Atom)this.points[i]).getVibrationVector();
            if (v == null) continue;
            if (v.isFrom000) {
                this.isSpinGroup = true;
                atomVibs = null;
                this.haveVibration = true;
                break;
            }
            if (!this.haveVibration) break;
            atomVibs[i].add(v);
        }
        if (this.haveVibration && atomVibs != null) {
            this.points = atomVibs;
        }
        if (this.isEqual(pgLast)) {
            return false;
        }
        try {
            this.findInversionCenter();
            this.isLinear = this.isLinear(this.points);
            if (this.isLinear) {
                this.name = this.haveInversionCenter ? "D\u221eh" : "C\u221ev";
                this.vTemp.sub2(this.points[1], this.points[0]);
                this.addAxis(22, this.vTemp);
                this.principalAxis = this.axes[22][0];
                if (this.haveInversionCenter) {
                    this.axes[0] = new Operator[]{this.principalPlane = this.newPlane(++this.nOps, this.vTemp)};
                    this.nAxes[0] = 1;
                }
                i = true;
                return i;
            }
            this.axes[0] = new Operator[axesMaxN[0]];
            int nPlanes = 0;
            this.findCAxes();
            nPlanes = this.findPlanes();
            this.findAdditionalAxes(nPlanes);
            int n = this.getHighestOrder();
            if (this.nAxes[23] > 1) {
                this.name = this.nAxes[25] > 1 ? (this.haveInversionCenter ? "Ih" : "I") : (this.nAxes[24] > 1 ? (this.haveInversionCenter ? "Oh" : "O") : (nPlanes > 0 ? (this.haveInversionCenter ? "Th" : "Td") : "T"));
            } else {
                int n2 = this.nAxes[22];
                if (n < 2) {
                    if (nPlanes == 1) {
                        this.name = "Cs";
                        boolean bl = true;
                        return bl;
                    }
                    if (this.haveInversionCenter) {
                        this.name = "Ci";
                        boolean bl = true;
                        return bl;
                    }
                    this.name = "C1";
                } else if (n % 2 == 1 && n2 > 0 || n % 2 == 0 && n2 > 1) {
                    this.principalAxis = this.setPrincipalAxis(n, nPlanes);
                    if (nPlanes == 0) {
                        this.name = n < 20 ? "S" + n : "D" + (n - 20);
                    } else {
                        int arrayIndexTop = n;
                        n = n < 20 ? (n /= 2) : (n -= 20);
                        if (n2 > n + 1) {
                            this.addHighOperations(n2, nPlanes, arrayIndexTop, n);
                            n = this.principalPlane == null ? nPlanes : nPlanes - 1;
                        }
                        this.name = nPlanes == n ? "D" + n + "d" : "D" + n + "h";
                    }
                } else if (nPlanes == 0) {
                    this.principalAxis = this.axes[n][0];
                    this.name = n < 20 ? "S" + n : "C" + (n - 20);
                } else if (nPlanes > 1) {
                    this.principalAxis = this.axes[n][0];
                    this.name = "C" + nPlanes + "v";
                } else {
                    this.principalPlane = this.axes[0][0];
                    this.principalAxis = this.axes[n < 20 ? n + 20 : n][0];
                    n = n < 20 ? (n /= 2) : (n -= 20);
                    this.name = "C" + n + "h";
                }
            }
        }
        catch (Exception e) {
            this.name = "??";
        }
        finally {
            Logger.info("Point group found: " + this.name);
        }
        return true;
    }

    private void addHighOperations(int n2, int nPlanes, int arrayIndexTop, int nTop) {
        boolean isS;
        boolean bl = isS = arrayIndexTop < 20;
        if (isS) {
            // empty if block
        }
    }

    private boolean getPointsAndElements(T3[] atomset) {
        boolean needCenter;
        int ac = this.bsAtoms.cardinality();
        if (this.isAtoms && ac > this.maxAtoms) {
            return false;
        }
        this.points = new P3[ac];
        this.elements = new int[ac];
        if (ac == 0) {
            return true;
        }
        int atomIndexMax = 0;
        int i = this.bsAtoms.nextSetBit(0);
        while (i >= 0) {
            T3 p = atomset[i];
            if (p instanceof Node) {
                atomIndexMax = Math.max(atomIndexMax, ((Point3fi)p).i);
            }
            i = this.bsAtoms.nextSetBit(i + 1);
        }
        this.atomMap = new int[atomIndexMax + 1];
        this.nAtoms = 0;
        boolean bl = needCenter = this.center == null;
        if (needCenter) {
            this.center = new P3();
        }
        Bspt bspt = new Bspt(3, 0);
        int i2 = this.bsAtoms.nextSetBit(0);
        while (i2 >= 0) {
            T3 p = atomset[i2];
            if (p instanceof Node) {
                int bondIndex = this.localEnvOnly ? 1 : 1 + Math.max(3, ((Node)((Object)p)).getCovalentBondCount());
                this.elements[this.nAtoms] = ((Node)((Object)p)).getElementNumber() * bondIndex;
                this.atomMap[((Point3fi)p).i] = this.nAtoms + 1;
            } else {
                Point3fi newPt = Point3fi.newPF(p, -1 - this.nAtoms);
                if (p instanceof Point3fi) {
                    this.elements[this.nAtoms] = Math.max(0, ((Point3fi)p).sD);
                }
                p = newPt;
            }
            bspt.addTuple(p);
            if (needCenter) {
                this.center.add(p);
            }
            this.points[this.nAtoms] = p;
            i2 = this.bsAtoms.nextSetBit(i2 + 1);
            ++this.nAtoms;
        }
        this.iter = bspt.allocateCubeIterator();
        if (needCenter) {
            this.center.scale(1.0f / (float)this.nAtoms);
        }
        i2 = this.nAtoms;
        while (--i2 >= 0) {
            float r2 = this.center.distanceSquared(this.points[i2]);
            if (this.isAtoms && r2 < this.distanceTolerance2) {
                this.centerAtomIndex = i2;
            }
            this.radius = Math.max(this.radius, r2);
        }
        this.radius = (float)Math.sqrt(this.radius);
        if (this.radius > 90.0f) {
            this.distanceTolerance = 0.3f;
        }
        if (this.radius > 90.0f || this.radius < 1.5f && this.distanceTolerance > 0.15f) {
            this.distanceTolerance = this.radius / 10.0f;
            this.distanceTolerance2 = this.distanceTolerance * this.distanceTolerance;
            System.out.println("PointGroup calculation adjusting distanceTolerance to " + this.distanceTolerance);
        }
        return true;
    }

    private boolean checkOperation(Quat q, T3 center, int arrayIndex) {
        int n;
        P3 pt = new P3();
        int nFound = 0;
        boolean isInversion = arrayIndex < 20;
        int i = n = this.points.length;
        block0: while (--i >= 0 && nFound < n) {
            if (i == this.centerAtomIndex) continue;
            T3 a1 = this.points[i];
            int e1 = this.elements[i];
            if (q != null) {
                pt.sub2(a1, center);
                q.transform2(pt, pt).add(center);
            } else {
                pt.setT(a1);
            }
            if (isInversion) {
                this.vTemp.sub2(center, pt);
                pt.scaleAdd2(2.0f, this.vTemp, pt);
            }
            if ((q != null || isInversion) && pt.distanceSquared(a1) < this.distanceTolerance2) {
                ++nFound;
                continue;
            }
            this.iter.initialize(pt, this.distanceTolerance, false);
            while (this.iter.hasMoreElements()) {
                T3 a2 = this.iter.nextElement();
                if (a2 == a1) continue;
                int j = this.getPointIndex(((Point3fi)a2).i);
                if (this.centerAtomIndex >= 0 && j == this.centerAtomIndex || j >= this.elements.length || this.elements[j] != e1 || !(pt.distanceSquared(a2) < this.distanceTolerance2)) continue;
                ++nFound;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private void findInversionCenter() {
        this.haveInversionCenter = this.checkOperation(null, this.center, -1);
        if (this.haveInversionCenter) {
            this.axes[1] = new Operator[]{this.newInversionCenter(++this.nOps)};
            this.nAxes[1] = 1;
        }
    }

    private Operator setPrincipalAxis(int n, int nPlanes) {
        this.principalPlane = this.setPrincipalPlane(n, nPlanes);
        if (nPlanes == 0 && n < 20 || this.nAxes[n] == 1) {
            return this.axes[n][0];
        }
        if (this.principalPlane == null) {
            return null;
        }
        Operator[] c2axes = this.axes[22];
        for (int i = 0; i < this.nAxes[22]; ++i) {
            if (!this.isParallel(this.principalPlane.normalOrAxis, c2axes[i].normalOrAxis)) continue;
            if (i != 0) {
                Operator o = c2axes[0];
                c2axes[0] = c2axes[i];
                c2axes[i] = o;
            }
            return c2axes[0];
        }
        return null;
    }

    private Operator setPrincipalPlane(int n, int nPlanes) {
        Operator[] planes = this.axes[0];
        if (nPlanes == 1) {
            this.principalPlane = planes[0];
            return this.principalPlane;
        }
        if (nPlanes == 0 || nPlanes == n - 20) {
            return null;
        }
        for (int i = 0; i < nPlanes; ++i) {
            int nPerp = 0;
            for (int j = 0; j < nPlanes; ++j) {
                if (!this.isPerpendicular(planes[i].normalOrAxis, planes[j].normalOrAxis) || ++nPerp <= 2) continue;
                if (i != 0) {
                    Operator o = planes[0];
                    planes[0] = planes[i];
                    planes[i] = o;
                }
                this.principalPlane = planes[0];
                return this.principalPlane;
            }
        }
        return null;
    }

    private int getPointIndex(int j) {
        return (j < 0 ? -j : this.atomMap[j]) - 1;
    }

    private void getElementCounts() {
        int i = this.points.length;
        while (--i >= 0) {
            int e1 = this.elements[i];
            if (e1 <= this.maxElement) continue;
            this.maxElement = e1;
        }
        this.eCounts = new int[++this.maxElement];
        i = this.points.length;
        while (--i >= 0) {
            int n = this.elements[i];
            this.eCounts[n] = this.eCounts[n] + 1;
        }
    }

    private int findCAxes() {
        int i;
        int i2;
        int j;
        V3 v1 = new V3();
        V3 v2 = new V3();
        V3 v3 = new V3();
        int i3 = this.points.length;
        while (--i3 >= 0) {
            if (i3 == this.centerAtomIndex) continue;
            T3 a1 = this.points[i3];
            int e1 = this.elements[i3];
            j = this.points.length;
            while (--j > i3) {
                int iOrder;
                float order;
                T3 a2 = this.points[j];
                if (this.elements[j] != e1) continue;
                v1.sub2(a1, this.center);
                v2.sub2(a2, this.center);
                v1.normalize();
                v2.normalize();
                if (this.isParallel(v1, v2)) {
                    this.getAllAxes(v1);
                    continue;
                }
                if (this.nAxes[22] < axesMaxN[22]) {
                    v3.ave(a1, a2);
                    v3.sub(this.center);
                    this.getAllAxes(v3);
                }
                boolean isIntegerOrder = (order = (float)(Math.PI * 2 / (double)v1.angle(v2))) - (float)(iOrder = (int)Math.floor(order + 0.01f)) <= 0.02f;
                int arrayIndex = iOrder + 20;
                if (!isIntegerOrder || arrayIndex >= maxAxis || this.nAxes[arrayIndex] >= axesMaxN[arrayIndex]) continue;
                v3.cross(v1, v2);
                this.checkForAxis(arrayIndex, v3);
            }
        }
        V3[] vs = new V3[this.nAxes[22] * 2];
        for (int i4 = 0; i4 < vs.length; ++i4) {
            vs[i4] = new V3();
        }
        int n = 0;
        for (i2 = 0; i2 < this.nAxes[22]; ++i2) {
            vs[n++].setT(this.axes[22][i2].normalOrAxis);
            vs[n].setT(this.axes[22][i2].normalOrAxis);
            vs[n++].scale(-1.0f);
        }
        i2 = vs.length;
        while (--i2 >= 2) {
            j = i2;
            while (--j >= 1) {
                int k = j;
                while (--k >= 0) {
                    v3.add2(vs[i2], vs[j]);
                    v3.add(vs[k]);
                    if (v3.length() < 1.0f) continue;
                    this.checkForAxis(23, v3);
                }
            }
        }
        int nMin = Integer.MAX_VALUE;
        int iMin = -1;
        for (i = 0; i < this.maxElement; ++i) {
            if (this.eCounts[i] >= nMin || this.eCounts[i] <= 2) continue;
            nMin = this.eCounts[i];
            iMin = i;
        }
        block8: for (i = 0; i < this.points.length - 2; ++i) {
            if (this.elements[i] != iMin) continue;
            for (int j2 = i + 1; j2 < this.points.length - 1; ++j2) {
                if (this.elements[j2] != iMin) continue;
                for (int k = j2 + 1; k < this.points.length; ++k) {
                    if (this.elements[k] != iMin) continue;
                    v1.sub2(this.points[i], this.points[j2]);
                    v2.sub2(this.points[i], this.points[k]);
                    v1.normalize();
                    v2.normalize();
                    v3.cross(v1, v2);
                    this.getAllAxes(v3);
                    v1.add2(this.points[i], this.points[j2]);
                    v1.add(this.points[k]);
                    v1.normalize();
                    if (!this.isParallel(v1, v3)) {
                        this.getAllAxes(v1);
                    }
                    if (this.nAxes[25] == axesMaxN[25]) break block8;
                }
            }
        }
        vs = new V3[this.maxElement];
        i = this.points.length;
        while (--i >= 0) {
            int e1 = this.elements[i];
            if (vs[e1] == null) {
                vs[e1] = new V3();
            } else if (this.haveInversionCenter) continue;
            vs[e1].add(this.points[i]);
        }
        if (!this.haveInversionCenter) {
            for (i = 0; i < this.maxElement; ++i) {
                if (vs[i] == null) continue;
                vs[i].scale(1.0f / (float)this.eCounts[i]);
            }
        }
        for (i = 0; i < this.maxElement; ++i) {
            if (vs[i] == null) continue;
            for (int j3 = 0; j3 < this.maxElement; ++j3) {
                if (i == j3 || vs[j3] == null) continue;
                if (this.haveInversionCenter) {
                    v1.cross(vs[i], vs[j3]);
                } else {
                    v1.sub2(vs[i], vs[j3]);
                }
                this.checkForAxis(22, v1);
            }
        }
        return this.getHighestOrder();
    }

    private void getAllAxes(V3 v3) {
        for (int o = 22; o < maxAxis; ++o) {
            if (this.nAxes[o] >= axesMaxN[o]) continue;
            this.checkForAxis(o, v3);
        }
    }

    private int getHighestOrder() {
        int n = 0;
        n = 20;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        if (n > 1) {
            return n + 20 < maxAxis && this.nAxes[n + 20] > 0 ? n + 20 : n;
        }
        n = maxAxis;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        return n;
    }

    private boolean checkForAxis(int arrayIndex, V3 v) {
        if (!this.isCompatible(arrayIndex)) {
            return false;
        }
        v.normalize();
        if (this.haveAxis(arrayIndex, v)) {
            return false;
        }
        Quat q = PointGroup.getQuaternion(v, arrayIndex);
        if (!this.checkOperation(q, this.center, arrayIndex)) {
            return false;
        }
        this.addAxis(arrayIndex, v);
        this.checkForAssociatedAxes(arrayIndex, v);
        return true;
    }

    private void checkForAssociatedAxes(int arrayIndex, V3 v) {
        switch (arrayIndex) {
            case 22: {
                this.checkForAxis(4, v);
                break;
            }
            case 23: {
                this.checkForAxis(3, v);
                if (!this.haveInversionCenter) break;
                this.addAxis(6, v);
                break;
            }
            case 24: {
                this.addAxis(22, v);
                this.checkForAxis(4, v);
                this.checkForAxis(8, v);
                break;
            }
            case 25: {
                this.checkForAxis(5, v);
                if (!this.haveInversionCenter) break;
                this.addAxis(10, v);
                break;
            }
            case 26: {
                this.addAxis(22, v);
                this.addAxis(23, v);
                this.checkForAxis(3, v);
                this.checkForAxis(6, v);
                this.checkForAxis(12, v);
                break;
            }
            case 27: {
                this.checkForAxis(6, v);
                if (!this.haveInversionCenter) break;
                this.addAxis(14, v);
                break;
            }
            case 28: {
                this.addAxis(22, v);
                this.addAxis(24, v);
                this.checkForAxis(4, v);
                this.checkForAxis(8, v);
                this.checkForAxis(16, v);
            }
        }
    }

    private boolean isCompatible(int arrayIndex) {
        switch (arrayIndex) {
            case 28: {
                if (this.nAxes[7] > 0 || this.nAxes[23] > 0) {
                    return false;
                }
            }
            case 24: 
            case 26: {
                if (this.nAxes[27] <= 0 && this.nAxes[25] <= 0) break;
                return false;
            }
            case 22: {
                break;
            }
            case 23: {
                if (this.nAxes[27] <= 0 && this.nAxes[28] <= 0) break;
                return false;
            }
            case 25: {
                if (this.nAxes[24] <= 0 && this.nAxes[26] <= 0 && this.nAxes[27] <= 0 && this.nAxes[28] <= 0) break;
                return false;
            }
            case 27: {
                if (this.nAxes[23] <= 0 && this.nAxes[24] <= 0 && this.nAxes[25] <= 0 && this.nAxes[26] <= 0 && this.nAxes[28] <= 0) break;
                return false;
            }
        }
        return true;
    }

    private boolean haveAxis(int arrayIndex, V3 v) {
        if (this.nAxes[arrayIndex] == axesMaxN[arrayIndex]) {
            return true;
        }
        if (this.nAxes[arrayIndex] > 0) {
            int i = this.nAxes[arrayIndex];
            while (--i >= 0) {
                if (!this.isParallel(v, this.axes[arrayIndex][i].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAxis(int arrayIndex, V3 v) {
        if (this.haveAxis(arrayIndex, v)) {
            return;
        }
        if (this.axes[arrayIndex] == null) {
            this.axes[arrayIndex] = new Operator[axesMaxN[arrayIndex]];
        }
        int n = arrayIndex;
        int n2 = this.nAxes[n];
        this.nAxes[n] = n2 + 1;
        this.axes[arrayIndex][n2] = this.newAxis(++this.nOps, v, arrayIndex);
    }

    private int findPlanes() {
        P3 pt = new P3();
        V3 v1 = new V3();
        V3 v2 = new V3();
        V3 v3 = new V3();
        int nPlanes = 0;
        boolean haveAxes = this.getHighestOrder() > 1;
        int i = this.points.length;
        while (--i >= 0) {
            if (i == this.centerAtomIndex) continue;
            T3 a1 = this.points[i];
            int e1 = this.elements[i];
            int j = this.points.length;
            while (--j > i) {
                if (haveAxes && this.elements[j] != e1) continue;
                T3 a2 = this.points[j];
                pt.add2(a1, a2);
                pt.scale(0.5f);
                v1.sub2(a1, this.center);
                v2.sub2(a2, this.center);
                v1.normalize();
                v2.normalize();
                if (!this.isParallel(v1, v2)) {
                    v3.cross(v1, v2);
                    v3.normalize();
                    nPlanes = this.addPlane(v3);
                }
                v3.sub2(a2, a1);
                v3.normalize();
                nPlanes = this.addPlane(v3);
                if (nPlanes != axesMaxN[0]) continue;
                return nPlanes;
            }
        }
        if (haveAxes) {
            for (i = 22; i < maxAxis; ++i) {
                for (int j = 0; j < this.nAxes[i]; ++j) {
                    nPlanes = this.addPlane(this.axes[i][j].normalOrAxis);
                }
            }
        }
        return nPlanes;
    }

    private void findAdditionalAxes(int nPlanes) {
        Operator[] planes = this.axes[0];
        int Cn = 0;
        if (nPlanes > 1 && (Cn = nPlanes + 20) < maxAxis && this.nAxes[Cn] == 0) {
            this.vTemp.cross(planes[0].normalOrAxis, planes[1].normalOrAxis);
            if (!this.checkForAxis(Cn, this.vTemp) && nPlanes > 2) {
                this.vTemp.cross(planes[1].normalOrAxis, planes[2].normalOrAxis);
                this.checkForAxis(Cn - 1, this.vTemp);
            }
        }
        if (this.nAxes[22] == 0 && nPlanes > 2) {
            for (int i = 0; i < nPlanes - 1; ++i) {
                for (int j = i + 1; j < nPlanes; ++j) {
                    this.vTemp.add2(planes[1].normalOrAxis, planes[2].normalOrAxis);
                    this.checkForAxis(22, this.vTemp);
                }
            }
        }
    }

    private int addPlane(V3 v3) {
        if (!this.haveAxis(0, v3) && this.checkOperation(Quat.newVA(v3, 180.0f), this.center, -1)) {
            int n = this.nAxes[0];
            this.nAxes[0] = n + 1;
            this.axes[0][n] = this.newPlane(++this.nOps, v3);
        }
        return this.nAxes[0];
    }

    String getName() {
        return this.getNameByConvention(this.name);
    }

    String updateDraw() {
        return null;
    }

    Object getInfo(int modelIndex, T3 a1, T3 a2, String drawID, boolean asMap, String type, int index, float scaleFactor) {
        String ctype;
        Operation operationInv;
        boolean justThisUVW;
        if (drawID == null && type == null && !asMap && this.textInfo != null) {
            return this.textInfo;
        }
        if (drawID != null) {
            this.modelIndex = modelIndex;
            this.drawID = drawID;
            this.type = type;
            this.index = index;
            this.scaleFactor = scaleFactor;
        }
        this.operations = new Lst();
        boolean bl = justThisUVW = type != null && type.indexOf("u") >= 0;
        if (a1 == null && a2 == null && drawID == null && this.drawInfo != null && this.drawIndex == index && this.scale == this.scale && this.drawType.equals(type == null ? "" : type)) {
            return this.drawInfo;
        }
        if (asMap && this.info != null) {
            return this.info;
        }
        boolean asDraw = drawID != null;
        this.info = null;
        Lst<Hashtable<String, Object>> elements = null;
        V3 v = new V3();
        if (scaleFactor == 0.0f) {
            scaleFactor = 1.0f;
        }
        this.scale = scaleFactor;
        int[][] nType = new int[4][2];
        for (int i = 1; i < maxAxis; ++i) {
            int j = this.nAxes[i];
            while (--j >= 0) {
                int[] nArray = nType[this.axes[i][j].type];
                nArray[0] = nArray[0] + 1;
            }
        }
        SB sb = new SB().append("# ").appendI(this.nAtoms).append(" atoms\n");
        String name = this.getNameByConvention(this.name);
        boolean haveThisType = false;
        Operation operation = operationInv = this.haveInversionCenter ? new Operation(null) : null;
        if (operationInv != null) {
            this.operations.addLast(operationInv);
        }
        if (asDraw) {
            Operator op;
            boolean haveType = type != null && type.length() > 0;
            type = haveType ? type : "";
            this.drawType = type;
            this.drawIndex = index;
            boolean anyProperAxis = type.equalsIgnoreCase(this.getNameByConvention("Cn"));
            boolean anyImproperAxis = type.equalsIgnoreCase(this.getNameByConvention("Sn"));
            String head = "set perspectivedepth off;draw " + drawID + " delete;\n";
            String m = "_" + modelIndex + "_";
            if (justThisUVW || !haveType) {
                sb.append(this.getDrawID("pg0" + m + "* delete;") + this.getDrawID("pgva" + m + "* delete;") + this.getDrawID("pgvp" + m + "* delete;"));
            }
            if (!haveType || type.equalsIgnoreCase("Ci") || type.equalsIgnoreCase("-u,-v,-w")) {
                int pt = sb.length();
                sb.append(this.getDrawID("pg0" + m + (this.haveInversionCenter ? "inv" : "")));
                if (operationInv != null) {
                    operationInv.drawID = sb.substring(pt);
                    haveThisType = justThisUVW;
                }
                sb.append(" ").append(Escape.eP(this.center)).append(this.haveInversionCenter ? "\"i\";\n" : ";\n");
                if (operationInv != null) {
                    operationInv.drawStr = sb.substring(pt);
                    System.out.println(operationInv);
                }
            }
            float offset = 0.1f;
            float axisWidth = this.isSpinGroup ? 1.9f : 0.05f;
            for (int i = 2; i < maxAxis && !haveThisType; ++i) {
                if (i == 20) {
                    offset = 0.1f;
                }
                if (this.nAxes[i] == 0) continue;
                String sglabel = this.isLinear ? "C\u221e" : this.getOpName(this.axes[i][0], false);
                String label = this.isLinear ? "\u221e" : this.getOpName(this.axes[i][0], true);
                offset = (float)((double)offset + 0.25);
                float scale = scaleFactor * 1.05f * this.radius + offset * 80.0f / this.sppa;
                boolean isProper = i >= 20;
                this.highestOrder = this.getHighestOrder();
                if (!justThisUVW && haveType && !type.equalsIgnoreCase(label) && (!anyProperAxis || !isProper) && (!anyImproperAxis || isProper)) continue;
                for (int j = 0; j < this.nAxes[i]; ++j) {
                    if (index > 0 && j + 1 != index) continue;
                    op = this.axes[i][j];
                    if (justThisUVW && !op.isUVW(type)) continue;
                    haveThisType = justThisUVW;
                    op.operation = new Operation(op);
                    this.operations.addLast(op.operation);
                    int pt = sb.length();
                    String s = this.getDrawID("pgva" + m + sglabel.replace("\u221e", "infinity") + (j + 1) + "\u0001");
                    op.operation.drawID = sb.substring(pt).replace('\u0001', ' ');
                    this.drawAxis(sb, op, s, label, axisWidth, scale, isProper, 'a', v);
                    this.drawAxis(sb, op, s, label, axisWidth, scale, isProper, 'b', v);
                    op.operation.drawStr = sb.substring(pt);
                    if (!Logger.debugging) continue;
                    Logger.debug(op.operation.toString());
                }
            }
            if (justThisUVW || !haveType || type.equalsIgnoreCase(this.getNameByConvention("Cs"))) {
                for (int j = 0; j < this.nAxes[0] && !haveThisType; ++j) {
                    if (index > 0 && j + 1 != index) continue;
                    op = this.axes[0][j];
                    if (justThisUVW && !op.isUVW(type)) continue;
                    haveThisType = justThisUVW;
                    op.operation = new Operation(op);
                    this.operations.addLast(op.operation);
                    String s = op.operation.drawID = this.getDrawID("pgvp" + m + (j + 1) + "\u0001");
                    int pt = sb.length();
                    this.drawPlane(sb, op, s, scaleFactor, v);
                    op.operation.drawStr = sb.substring(pt);
                    if (!Logger.debugging) continue;
                    Logger.debug(op.operation.toString());
                }
                if (justThisUVW && a1 != null && a2 != null) {
                    String cmd = this.getDrawID("pg0" + m + "_line");
                    sb.append(cmd).append(" width " + axisWidth / 2.0f + " " + a1 + a2 + " color yellow;");
                }
            }
            sb.append("# name=").append(name);
            sb.append(", n" + this.getNameByConvention("Ci") + "=").appendI(this.haveInversionCenter ? 1 : 0);
            sb.append(", n" + this.getNameByConvention("Cs") + "=").appendI(this.nAxes[0]);
            sb.append(", n" + this.getNameByConvention("Cn") + "=").appendI(nType[1][0]);
            sb.append(", n" + this.getNameByConvention("Sn") + "=").appendI(nType[2][0]);
            sb.append(": ");
            int i = maxAxis;
            while (--i >= 2) {
                if (this.nAxes[i] <= 0) continue;
                String axisName = this.getNameByConvention((i < 20 ? "S" : "C") + i % 20);
                sb.append(" n").append(axisName);
                sb.append("=").appendI(this.nAxes[i]);
            }
            sb.append(";\n");
            sb.append("print '" + name + "';\n");
            this.drawInfo = head + sb.toString();
            if (Logger.debugging) {
                Logger.info(this.drawInfo);
            }
            return this.drawInfo;
        }
        int n = 0;
        int nTotal = 1;
        int nElements = 0;
        String string = ctype = this.haveInversionCenter ? this.getNameByConvention("Ci") : "center";
        if (this.haveInversionCenter) {
            ++nTotal;
            ++nElements;
        }
        if (asMap) {
            this.info = new Hashtable<String, Object>();
            elements = new Lst<Hashtable<String, Object>>();
            if (this.center != null) {
                this.info.put(ctype, this.center);
                if (this.haveInversionCenter) {
                    this.info.put("center", this.center);
                }
                this.info.put(ctype, this.center);
            }
            this.info.put("elements", elements);
            if (this.haveInversionCenter) {
                this.info.put("Ci_m", M3.newM3(mInv));
                Hashtable<String, Object> e = new Hashtable<String, Object>();
                this.axes[1][0].setInfo(null, null, e);
                e.put("location", this.center);
                e.put("type", this.getNameByConvention("Ci"));
                elements.addLast(e);
            }
        } else {
            sb.append("\n\n").append(name).append("\t").append(ctype).append("\t").append(Escape.eP(this.center));
        }
        int i = maxAxis;
        while (--i >= 0) {
            if (i == 1 || this.nAxes[i] == 0) continue;
            n = nUnique[i];
            Operator[] a = this.axes[i];
            String sglabel = this.getOpName(a[0], false);
            String label = this.getOpName(a[0], true);
            int ni = this.nAxes[i];
            if (asMap) {
                this.info.put("n" + sglabel, this.nAxes[i]);
            } else {
                sb.append("\n\n").append(name).append("\tn").append(label).append("\t").appendI(ni).append("\t").appendI(n);
            }
            nTotal += (n *= ni);
            nElements += ni;
            int[] nArray = nType[a[0].type];
            nArray[1] = nArray[1] + n;
            Lst<V3> vinfo = asMap ? new Lst<V3>() : null;
            Lst<M3> minfo = asMap ? new Lst<M3>() : null;
            for (int j = 0; j < ni; ++j) {
                Operator aop = a[j];
                if (type != null && !aop.isUVW(type)) continue;
                if (!asDraw && aop.operation == null) {
                    aop.operation = new Operation(aop);
                    this.operations.addLast(aop.operation);
                }
                if (asMap) {
                    Hashtable<String, Object> e = new Hashtable<String, Object>();
                    aop.setInfo(vinfo, minfo, e);
                    e.put("type", label);
                    elements.addLast(e);
                    continue;
                }
                sb.append("\n").append(name).append("\t").append(sglabel).append("_").appendI(j + 1).append("\t").appendO(aop.normalOrAxis);
            }
            if (!asMap) continue;
            this.info.put(sglabel, vinfo);
            this.info.put(sglabel + "_m", minfo);
        }
        if (asMap && this.highOperations != null) {
            for (Operator o : this.highOperations) {
                Hashtable<String, Object> e = new Hashtable<String, Object>();
                o.setInfo(null, null, e);
                e.put("type", this.getNameByConvention(o.schName));
                elements.addLast(e);
            }
        }
        if (!asMap) {
            this.textInfo = this.getTextInfo(sb, nType, nTotal);
            return this.textInfo;
        }
        this.info.put("name", this.name);
        this.info.put("hmName", this.getHermannMauguinName());
        this.info.put("nAtoms", this.nAtoms);
        this.info.put("nTotal", nTotal);
        this.info.put("nElements", nElements);
        this.info.put("nCi", this.nAxes[1]);
        this.info.put("nC2", this.nAxes[22]);
        this.info.put("nC3", this.nAxes[23]);
        this.info.put("nCs", this.nAxes[0]);
        this.info.put("nCn", nType[1][0]);
        this.info.put("nSn", nType[2][0]);
        this.info.put("distanceTolerance", Float.valueOf(this.distanceTolerance));
        this.info.put("linearTolerance", Float.valueOf(this.linearTolerance));
        this.info.put("points", this.points);
        this.info.put("detail", sb.toString().replace('\n', ';'));
        if (this.principalAxis != null && this.principalAxis.index > 0) {
            this.info.put("principalAxis", this.principalAxis.normalOrAxis);
        }
        if (this.principalPlane != null && this.principalPlane.index > 0) {
            this.info.put("principalPlane", this.principalPlane.normalOrAxis);
        }
        return this.info;
    }

    private String getDrawID(String id) {
        int pt = id.indexOf(32);
        if (pt < 0) {
            pt = id.length();
        }
        id = id.substring(0, pt) + "\"" + id.substring(pt);
        return "draw" + (id.indexOf("*") >= 0 ? "" : " model " + this.modelIndex) + " ID \"" + id;
    }

    private void drawPlane(SB sb, Operator op, String s, float scaleFactor, V3 v) {
        sb.append(s.replace("\u0001", "disk"));
        sb.append(" scale ").appendD(scaleFactor * this.radius * 2.0f).append(" CIRCLE PLANE ").append(Escape.eP(this.center));
        v.add2(op.normalOrAxis, this.center);
        sb.append(Escape.eP(v)).append(" color translucent yellow;\n");
        v.add2(op.normalOrAxis, this.center);
        sb.append(s.replace("\u0001", "ring"));
        sb.append(" width 0.05 scale ").appendD(scaleFactor * this.radius * 2.0f).append(" arc ").append(Escape.eP(v));
        v.scaleAdd2(-2.0f, op.normalOrAxis, v);
        sb.append(Escape.eP(v));
        v.add3(0.011f, 0.012f, 0.013f);
        sb.append(Escape.eP(v)).append("{0 360 0.5} color ").append(this.principalPlane != null && op.index == this.principalPlane.index ? "red" : "blue").append(";\n");
    }

    private void drawAxis(SB sb, Operator op, String s, String label, float axisWidth, float scale, boolean isProper, char c, V3 v) {
        boolean isPA = !this.isLinear && this.principalAxis != null && op.index == this.principalAxis.index;
        int pt = sb.length();
        sb.append(" color ").append(isPA ? "red" : (op.type == 2 ? "blue" : "orange")).append(";\n");
        String tail = sb.substring(pt);
        sb.setLength(pt);
        sb.append(s.replace('\u0001', c));
        v.scaleAdd2((float)(c == 'a' ? 1 : -1) * scale, op.normalOrAxis, this.center);
        sb.append(" width " + axisWidth).append(" ").append(Escape.eP(this.center)).append(Escape.eP(v));
        if (isProper && op.order != 2 && c == 'a' || op.order == 2 || !isProper && c == 'b') {
            label = PT.esc(">" + this.getAxisLabelOffset(op, this.highestOrder) + label);
            sb.append(label);
        }
        sb.append(tail);
    }

    String getAxisLabelOffset(Operator op, int highestOrder) {
        switch (op.type) {
            case 1: 
            case 2: {
                switch (op.order) {
                    case 3: {
                        return highestOrder % 6 == 0 ? "   " : "";
                    }
                    case 4: {
                        return highestOrder % 12 == 0 ? "       " : "   ";
                    }
                    case 6: {
                        return highestOrder % 12 == 0 ? "           " : "";
                    }
                    case 8: {
                        return "       ";
                    }
                    case 12: {
                        return "               ";
                    }
                }
                return "";
            }
        }
        return "";
    }

    private boolean isPrincipalAxis(Operator op) {
        return this.principalAxis == null ? false : Math.abs(Math.abs(this.principalAxis.normalOrAxis.dot(op.normalOrAxis)) - 1.0f) > 0.01f;
    }

    private String getTextInfo(SB sb, int[][] nType, int nTotal) {
        sb.append("\n");
        sb.append("\n").append(this.name).append("\ttype\tnElements\tnUnique");
        sb.append("\n").append(this.name).append("\t" + this.getNameByConvention("E") + "\t  1\t  1");
        sb.append("\n").append(this.name).append("\t" + this.getNameByConvention("Ci") + "\t  ").appendI(this.nAxes[1]).append("\t  ").appendI(this.nAxes[1]);
        sb.append("\n").append(this.name).append("\t" + this.getNameByConvention("Cs") + "\t");
        PT.rightJustify(sb, "    ", this.nAxes[0] + "\t");
        PT.rightJustify(sb, "    ", this.nAxes[0] + "\n");
        sb.append(this.name).append("\t" + this.getNameByConvention("Cn") + "\t");
        PT.rightJustify(sb, "    ", nType[1][0] + "\t");
        PT.rightJustify(sb, "    ", nType[1][1] + "\n");
        sb.append(this.name).append("\t" + this.getNameByConvention("Sn") + "\t");
        PT.rightJustify(sb, "    ", nType[2][0] + "\t");
        PT.rightJustify(sb, "    ", nType[2][1] + "\n");
        sb.append(this.name).append("\t\tTOTAL\t");
        PT.rightJustify(sb, "    ", nTotal + "\n");
        return sb.toString();
    }

    static final Quat getQuaternion(V3 v, int arrayIndex) {
        return Quat.newVA(v, (arrayIndex < 20 ? 180 : 0) + (arrayIndex == 0 ? 0 : 360 / (arrayIndex % 20)));
    }

    private boolean isLinear(T3[] atoms) {
        V3 v1 = null;
        if (atoms.length < 2) {
            return false;
        }
        int i = atoms.length;
        while (--i >= 0) {
            if (i == this.centerAtomIndex) continue;
            if (v1 == null) {
                v1 = new V3();
                v1.sub2(atoms[i], this.center);
                v1.normalize();
                this.vTemp.setT(v1);
                continue;
            }
            this.vTemp.sub2(atoms[i], this.center);
            this.vTemp.normalize();
            if (this.isParallel(v1, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private boolean isParallel(V3 v1, V3 v2) {
        return Math.abs(v1.dot(v2)) >= this.cosTolerance;
    }

    private boolean isPerpendicular(V3 v1, V3 v2) {
        return Math.abs(v1.dot(v2)) <= 1.0f - this.cosTolerance;
    }

    private boolean isEqual(PointGroup pg) {
        if (pg == null) {
            return false;
        }
        if (this.convention != pg.convention || this.linearTolerance != pg.linearTolerance || this.distanceTolerance != pg.distanceTolerance || this.nAtoms != pg.nAtoms || this.localEnvOnly != pg.localEnvOnly || this.haveVibration != pg.haveVibration || this.bsAtoms == null ? pg.bsAtoms != null : !this.bsAtoms.equals(pg.bsAtoms)) {
            return false;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            if (this.elements[i] == pg.elements[i] && this.points[i].equals(pg.points[i])) continue;
            return false;
        }
        return true;
    }

    private String getHermannMauguinName() {
        return PointGroup.getHMfromSFName(this.name);
    }

    private String getNameByConvention(String name) {
        switch (this.convention) {
            default: {
                return name;
            }
            case 1: 
        }
        return PointGroup.getHMfromSFName(name);
    }

    private String getOpName(Operator op, boolean conventional) {
        return conventional ? this.getNameByConvention(op.schName) : op.schName;
    }

    public static String getHMfromSFName(String name) {
        String hm;
        if (htSFToHM == null) {
            htSFToHM = new Hashtable<String, String>();
            String[] syms = SF2HM;
            PointGroup.addNames("E", "1");
            PointGroup.addNames("Ci", "-1");
            PointGroup.addNames("Cn", "n");
            PointGroup.addNames("Sn", "-n");
            for (int i = 0; i < syms.length; ++i) {
                String[] list = syms[i].split(",");
                String sym = list[0];
                if (list.length == 2) {
                    PointGroup.addNames(sym, list[1]);
                    continue;
                }
                String type = sym.substring(0, 1);
                String ext = sym.substring(2, sym.length());
                for (int n = 1; n < 13; ++n) {
                    String val = list[n];
                    if (val.length() <= 0) continue;
                    PointGroup.addNames(type + n + ext, val);
                    if (!Logger.debugging) continue;
                    Logger.debug(type + n + ext + "\t" + val);
                }
                if (list.length != 14) continue;
                PointGroup.addNames(type + "\u221e" + ext, list[13]);
            }
        }
        return (hm = htSFToHM.get(name)) == null ? name : hm;
    }

    private static void addNames(String sch, String hm) {
        htSFToHM.put(sch, hm);
        htSFToHM.put(hm, sch);
    }

    class Operator {
        int type;
        int index;
        V3 normalOrAxis;
        private M3 mat;
        final int order;
        private final int axisArrayIndex;
        String schName;
        private Lst<String> uvws;
        private Lst<M3> uniqueMats;
        private Lst<M3> mats;
        public Operation operation;
        private Lst<String> uniqueUVWs;

        protected Operator(int index, V3 v, int arrayIndex) {
            this.index = index;
            if (v == null) {
                this.type = 3;
                this.axisArrayIndex = 1;
                this.order = 2;
                this.schName = "Ci";
                this.mat = mInv;
            } else {
                this.normalOrAxis = Quat.newVA(v, 180.0f).getNormal();
                if (arrayIndex == -1) {
                    this.type = 0;
                    this.axisArrayIndex = 0;
                    this.order = 2;
                    this.schName = "Cs";
                } else {
                    this.type = arrayIndex < 20 ? 2 : 1;
                    this.axisArrayIndex = arrayIndex;
                    this.order = arrayIndex % 20;
                    this.schName = (this.type == 2 ? "S" : "C") + this.order;
                }
            }
            if (Logger.debugging) {
                Logger.debug("new operation -- " + index + " " + this.schName + (this.normalOrAxis == null ? "" : " " + this.normalOrAxis));
            }
        }

        M3 getM3() {
            if (this.mat != null) {
                return this.mat;
            }
            M3 m = M3.newM3(PointGroup.getQuaternion(this.normalOrAxis, this.axisArrayIndex).getMatrix());
            if (this.type == 0 || this.type == 2) {
                m.mul(mInv);
            }
            this.cleanMatrix(m);
            this.mat = m;
            return this.mat;
        }

        float distance(T3 pt) {
            P3 p = P3.newP(pt);
            this.getM3().rotate(p);
            return p.distance(pt);
        }

        private void cleanMatrix(M3 m) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    m.setElement(i, j, this.approx0(m.getElement(i, j)));
                }
            }
        }

        private float approx0(float v) {
            return v > 1.0E-15f || v < -1.0E-15f ? v : 0.0f;
        }

        Lst<M3> getMatrices(boolean uniqueOnly) {
            if (uniqueOnly && this.uniqueMats != null) {
                return this.uniqueMats;
            }
            if (!uniqueOnly && this.mats != null) {
                return this.mats;
            }
            Lst<M3> matrices = new Lst<M3>();
            M3 m = new M3();
            m.m22 = 1.0f;
            m.m11 = 1.0f;
            m.m00 = 1.0f;
            BS bs = uniqueOnly ? PointGroup.getUniqueFractions(this.order) : null;
            for (int i = 1; i < this.order; ++i) {
                m.mul(this.getM3());
                if (uniqueOnly && !bs.get(i)) continue;
                matrices.addLast(M3.newM3(m));
            }
            if (uniqueOnly) {
                this.uniqueMats = matrices;
            } else {
                this.mats = matrices;
            }
            return matrices;
        }

        public String toString() {
            return this.schName + " " + this.normalOrAxis;
        }

        public void setInfo(Lst<V3> vinfo, Lst<M3> minfo, Map<String, Object> e) {
            if (vinfo != null) {
                vinfo.addLast(this.normalOrAxis);
                minfo.addLast(this.getM3());
            }
            e.put("order", this.order);
            e.put("typeSch", this.schName);
            e.put("typeHM", PointGroup.getHMfromSFName(this.schName));
            if (this.normalOrAxis != null) {
                e.put("direction", this.normalOrAxis);
            }
            Lst<M3> mats = this.getMatrices(true);
            e.put("uniqueOperations", mats);
            e.put("uniqueOperationUVWs", this.getUVWs(mats, true));
            if (mats.size() != this.order - 1) {
                e.put("matrixIndices", bsUnique.get(this.order));
            }
            mats = this.getMatrices(false);
            e.put("operations", mats);
            e.put("operationUVWs", this.getUVWs(mats, false));
        }

        private Lst<String> getUVWs(Lst<M3> mats, boolean isUnique) {
            Lst<String> uvws;
            Lst<String> lst = uvws = isUnique ? this.uniqueUVWs : this.uvws;
            if (uvws != null) {
                return uvws;
            }
            Lst<String> list = new Lst<String>();
            for (int i = 0; i < mats.size(); ++i) {
                list.addLast((String)SymmetryOperation.staticConvertOperation(null, (M34)mats.get(i), "uvw"));
            }
            if (isUnique) {
                this.uniqueUVWs = list;
            } else {
                uvws = list;
            }
            return list;
        }

        public boolean isUVW(String uvw) {
            Lst<String> uvws = this.getUVWs(this.getMatrices(true), true);
            int n = uvws.size();
            for (int i = 0; i < n; ++i) {
                if (!((String)uvws.get(i)).equals(uvw)) continue;
                return true;
            }
            return false;
        }
    }

    private class Operation {
        private Operator operator;
        String drawID;
        String drawStr;
        boolean isTrivial;
        String typeName;
        int type;

        Operation(Operator o) {
            this.operator = o;
            this.type = o == null ? 3 : o.type;
            this.typeName = o == null ? "Ci" : o.schName;
            this.isTrivial = this.checkTrivial();
        }

        private boolean checkTrivial() {
            float tol = PointGroup.this.distanceTolerance;
            int i = PointGroup.this.points.length;
            while (--i >= 0) {
                float d;
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        d = this.operator.distance(PointGroup.this.points[i]);
                        break;
                    }
                    default: {
                        d = PointGroup.this.points[i].length();
                    }
                }
                if (!(d > tol)) continue;
                return false;
            }
            System.out.println(this + " is trivial");
            return true;
        }

        public String toString() {
            return "[op " + this.typeName + " " + this.drawID + " " + this.isTrivial + "]";
        }
    }
}

