#############################################################################
##
#W  factint.tst              GAP4 Package `FactInt'               Stefan Kohl
##
##  For purposes of limiting the execution time, the testing numbers given
##  here are all 'easy' to factor. This does not mean that the factorization
##  routines provided by this package are not capable of factoring much
##  'harder' numbers.
##
#############################################################################

gap> START_TEST( "factint.tst" );
gap> oldwarninglevel := InfoLevel(InfoPrimeInt);;
gap> SetInfoLevel(InfoPrimeInt,0);
gap> SizeScreen([80,]);;
gap> TimeToString(120000);   
"120.000 sec."
gap> Factors(50);
[ 2, 5, 5 ]
gap> Factors(480);
[ 2, 2, 2, 2, 2, 3, 5 ]
gap> List([-5..5],Factors);
[ [ -5 ], [ -2, 2 ], [ -3 ], [ -2 ], [ -1 ], [ 0 ], [ 1 ], [ 2 ], [ 3 ], 
  [ 2, 2 ], [ 5 ] ]
gap> Factors(1234567890);
[ 2, 3, 3, 5, 3607, 3803 ]
gap> Factors(-565634635);
[ -5, 71, 107, 14891 ]
gap> for i in [1..6] do List([-100..1000],Factors); od;
gap> FACTINT_SMALLINTCACHE_LIMIT;
128
gap> FACTINT_SMALLINTCOUNT_THRESHOLD;
6561
gap> FactorsTDNC(-111111111111);
[ [ -3, 7, 11, 13, 37, 101, 9901 ], [  ] ]
gap> Factors(54654564564564564565635556456356565653:TDHints:=[229719490001]);
[ 3, 3, 3, 7, 47, 137, 8741, 229719490001, 22365944643585923 ]
gap> n := 113340573632421907304106191194427947366905934928197760786671165845749477377;;
gap> Factors(n:Pplus1Residues:=20);
[ 43545476763656765745675656334553, 
  2602809339936229998169452129211659952808809 ]
gap> Factors(11111111111111111111122222222222222222222222);
[ 2, 61, 97, 191, 298096872799120141, 16490549910382430593 ]
gap> Factors(11111111111111111111122222222222222222222222); # cache test
[ 2, 61, 97, 191, 298096872799120141, 16490549910382430593 ]
gap> Factors(50718554723907260148296168907406660945083116452219147507);
[ 298096872799120141, 170141183460469231731687303715884105727 ]
gap> Factors(1111111111111111111111122222222222222222222222:FBMethod:="CFRAC");
[ 2, 3, 7, 7, 19961, 17040030781111603, 11111111111111111111111 ]
gap> IntegerFactorization(Factorial(39)+1:ECMDeterministic);
[ 79, 57554485363, 146102648914939, 30705821478100704367 ]
gap> FactInt(Factorial(43)-1:ECMDeterministic);
[ [ 97, 607, 857, 883, 12829, 1298793158431, 81378920130420431538741649 ], 
  [  ] ]
gap> Factors(1459^24-1);
[ 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 5, 7, 13, 73, 97, 193, 283, 337, 1009, 
  303889, 669433, 1064341, 6722971513, 4531280671081, 313380751265929 ]
gap> FactorsPminus1(NrPartitions(1503));
[ [ 2, 2, 2, 7, 7, 53, 34261, 1432250823109, 1437327898056671629 ], [  ] ]
gap> FactorsPplus1(Factorial(55)-1);
[ [ 73, 39619, 277914269, 148257413069 ], 
  [ 106543529120049954955085076634537262459718863957 ] ]
gap> FactorsECM(Factorial(36)-1:ECMDeterministic);
[ [ 155166770881, 2397377509874128534536693708479 ], [  ] ]
gap> FactorsCFRAC(Factorial(24)-1);
[ 625793187653, 991459181683 ]
gap> FactorsMPQS(NrPartitions(808));
[ 5963320232189, 1366982853893003 ]
gap> PartialFactorization(2^2520-1,1:ECMDeterministic);
[ 3, 3, 3, 5, 5, 7, 7, 11, 13, 17, 19, 29, 31, 37, 41, 43, 61, 71, 73, 109, 
  113, 127, 151, 181, 211, 241, 281, 331, 337, 421, 433, 631, 
  1775001155975052185364566284237470275064461503237038206872038177608119296157\
087878698686398717615808207480422559459567744434135140975378474116949917957045\
104396930351429973613482339970114001009412140914076609547659265044566315586266\
145211371269272034884704362264417880875141979812983165607812150141862354024825\
698572505924547246710170612436193492220673272087649515528012142024743115464473\
386186222293571676555932312958262658143565657115649203788812681267737065369020\
622852371601041351687255688269532408962584175609619962374589583376546431331735\
863582094604231909335027826933784368517976014928231732006147154916818216594259\
992618766887000733537193713903855608987164201868581028990609565386771531256466\
024773 ]
gap> PartialFactorization(2^2520-1,2:ECMDeterministic);
[ 3, 3, 3, 5, 5, 7, 7, 11, 13, 17, 19, 29, 31, 37, 41, 43, 61, 71, 73, 109, 
  113, 127, 151, 181, 211, 241, 281, 331, 337, 421, 433, 631, 1009, 1321, 
  1429, 2521, 3361, 5419, 14449, 21169, 23311, 15790321, 18837001, 29247661, 
  47392381, 4562284561, 77158673929, 88959882481, 
  2204698295625891988983471163731993859460847286091439810214792078377575009158\
986011776833351595131318898601749930961814718358944304474719682231551767344811\
565339046629561348986948041928574711613964210899396952646400471099082081952652\
013723312330052058554240031431720965560871084047199598210918504722840842746612\
195899563056794879292200451398293875421449150371712289245319932949324156103580\
704850849962576653383014634288375701994753735180665778665209012110029067165985\
418633494945653781005751384679211852659293120751077771054843613269921194523017\
82144915610291628624256354633343046383763266038772165593174014181173 ]
gap> PartialFactorization(2^2520-1,3:ECMDeterministic);
[ 3, 3, 3, 5, 5, 7, 7, 11, 13, 17, 19, 29, 31, 37, 41, 43, 61, 71, 73, 109, 
  113, 127, 151, 181, 211, 241, 281, 331, 337, 421, 433, 631, 1009, 1321, 
  1429, 2521, 3361, 5419, 14449, 21169, 23311, 29191, 38737, 54001, 61681, 
  86171, 92737, 106681, 122921, 127681, 152041, 983431, 1564921, 15790321, 
  18837001, 29247661, 47392381, 4562284561, 77158673929, 88959882481, 
  1869693240585592825908114984489377989385195920729226672119392374411116871861\
504702541920159947301846599966257064798558830572794047329751615893898828012778\
578677406481914935733747334552327197808629061996488471981006444285302109420254\
374593294866770891792116362223424959457044162424207853209111517437547546314828\
440115791460630270925153496004387364968883124980852708493281787883881033993809\
739023594428727351487933098842888559835215097140974360387925837498296293645036\
899584525281667158496149142447878715036661390597570622646089020614671414502360\
9647247 ]
gap> PartialFactorization(2^2520-1,4:ECMDeterministic);
[ 3, 3, 3, 5, 5, 7, 7, 11, 13, 17, 19, 29, 31, 37, 41, 43, 61, 71, 73, 109, 
  113, 127, 151, 181, 211, 241, 281, 331, 337, 421, 433, 631, 1009, 1321, 
  1429, 2521, 3361, 5419, 14449, 21169, 23311, 29191, 38737, 54001, 61681, 
  86171, 92737, 106681, 122921, 127681, 152041, 649657, 664441, 870031, 
  983431, 1130641, 1325521, 1564921, 1711081, 1765891, 2627857, 7416361, 
  15790321, 18837001, 29247661, 47392381, 4562284561, 77158673929, 
  88959882481, 
  5641007675085930458929604182277903361377783610026558980727495610967273855468\
266486690378094930114698741990626328160515970269625052463140750203091475796073\
126219856355072266860597044732079695669180387256886140471942430853387419252716\
397580432223738498892703510308071455173517772690115005111522903215072688394628\
873852498972580640547482750477570132558609085559533977499200508997509629453611\
326095977349062939130656442256904494164305159469427700477716506307673781875161\
25082771673586610804285191323 ]
gap> PartialFactorization(2^2520-1,5:ECMDeterministic);
[ 3, 3, 3, 5, 5, 7, 7, 11, 13, 17, 19, 29, 31, 37, 41, 43, 61, 71, 73, 109, 
  113, 127, 151, 181, 211, 241, 281, 331, 337, 421, 433, 631, 1009, 1321, 
  1429, 2521, 3361, 5419, 14449, 21169, 23311, 29191, 38737, 54001, 61681, 
  86171, 92737, 106681, 122921, 127681, 152041, 649657, 664441, 870031, 
  983431, 1130641, 1325521, 1564921, 1711081, 1765891, 2627857, 7416361, 
  15790321, 18837001, 29247661, 47392381, 430839361, 4562284561, 77158673929, 
  88959882481, 
  1309306480724710400573081386191616638614823219465911096439374677042860495624\
090967559107974568301965971486673504782334864309118927614215997828269798171034\
128476450032399028384177054039424149937215320319093626283588892160989770675274\
118601348548499610947269859660773068311536599064381911269133764966073442949570\
448799477021919694228560224440025137944304277612075925787848457280928338730316\
547400128872873093675082403220095875632938086979807701571100535149961329061381\
012220867335254010843 ]
gap> PartialFactorization(2^2520-1,6:ECMDeterministic);
[ 3, 3, 3, 5, 5, 7, 7, 11, 13, 17, 19, 29, 31, 37, 41, 43, 61, 71, 73, 109, 
  113, 127, 151, 181, 211, 241, 281, 331, 337, 421, 433, 631, 1009, 1321, 
  1429, 2521, 3361, 5419, 14449, 21169, 23311, 29191, 38737, 54001, 61681, 
  86171, 92737, 106681, 122921, 127681, 152041, 649657, 664441, 870031, 
  983431, 1130641, 1325521, 1564921, 1711081, 1765891, 2627857, 7416361, 
  15790321, 18837001, 29247661, 47392381, 269389009, 430839361, 755667361, 
  4562284561, 40388473189, 77158673929, 88959882481, 118750098349, 
  146919792181, 168692292721, 1041815865690181, 469775495062434961, 
  1475204679190128571777, 1626833408812908876721, 
  17369459529909057773233442461, 84179842077657862011867889681, 
  29728307155963706810228435378401, 164861463278712334259867127702044401, 
  11247702599676505481447137991664348691, 
  54169520413224311136354324156824071681, 
  15169173997557864184867895400813639018421, 
  517496882214135484318298195143896326867475066317761, 
  1344048385417946013983516746242551864720220367077696473507281 ]
gap> PartialFactorization(1234^120-1,7);
[ 3, 3, 3, 5, 5, 7, 11, 13, 19, 31, 41, 61, 73, 89, 137, 157, 229, 241, 409, 
  421, 601, 1801, 2341, 3617, 24943, 63421, 674761, 1037329, 1242271, 
  10016761, 41241631, 64494877, 1027453781, 3861341831, 26053773433, 
  105031821211, 2764308358681, 56932561315921, 173603545321537, 
  2983015306916951178511, 5376764220139660647262861, 
  2886125709604838064627825247810155334962361, 
  455837190112911766269981368708223772739514601, 
  32656593856129905690515320200096406873880650776817929641209397041 ]
gap> Factors(-565634635);
[ -5, 71, 107, 14891 ]
gap> Factors(11111111111111111111111111111111111111111111111111111111111111);
[ 11, 2791, 6943319, 57336415063790604359, 909090909090909090909090909091 ]
gap> Factors(Product(Filtered([1..200],IsPrime))-1);
[ 1372062943, 4784328604523758357, 619780408302187874237918207, 
  1917155688123066068833010437 ]
gap> Factors(Fibonacci(500));
[ 3, 5, 5, 5, 11, 41, 101, 151, 251, 401, 3001, 570601, 112128001, 
  1353439001, 28143378001, 5465167948001, 84817574770589638001, 
  158414167964045700001 ]
gap> Factors(Factorial(100)+1);
[ 101, 14303, 149239, 350433007170616328107072379, 
  1235286816572997251398503017534378708348512400771465312124056290542248784139\
238223033271959567362883048251014777364474207 ]
gap> n := 140000000000000000000000000039090911699999999999999999945454534299999433;;
gap> Factors(n);
[ 199999999999999999999999999899999989, 700000000000000000000000000545454597 ]
gap> Factors(-Fibonacci(1260));
[ -2, 2, 2, 2, 3, 3, 3, 5, 11, 13, 17, 19, 29, 31, 41, 61, 71, 83, 107, 181, 
  211, 281, 421, 541, 631, 911, 1009, 1427, 2521, 21211, 31249, 109441, 
  141961, 721561, 767131, 1461601, 9761221, 35239681, 764940961, 8288823481, 
  10783342081, 12317523121, 1051224514831, 140207234004601, 1983000765501001, 
  120570028745492370271501, 
  1538486683044957457804703332422378490845205172402364196823041 ]
gap> Factors((2^128+1)^6);
[ 59649589127497217, 59649589127497217, 59649589127497217, 59649589127497217, 
  59649589127497217, 59649589127497217, 5704689200685129054721, 
  5704689200685129054721, 5704689200685129054721, 5704689200685129054721, 
  5704689200685129054721, 5704689200685129054721 ]
gap> Factors(3^400-2^400);
[ 5, 5, 5, 11, 13, 17, 41, 97, 101, 211, 281, 401, 1201, 3121, 4621, 11701, 
  55201, 513101, 742801, 9802501, 20017001, 39756701, 104189401, 
  1783433557073281, 9937984196743741414107401, 
  395779932917984661962111710614687897020017142469626326777699991356159201 ]
gap> Factors(2^242+1);
[ 5, 397, 2113, 3389, 91961, 4036962584010807014809213, 
  1339272539833668386958920468400193 ]
gap> Factors(2^1002+1);
[ 5, 13, 857713, 75005713, 58152051961, 68488673941, 27395325377910797, 
  79259861740715737, 18208260781190156536114609, 
  11016209309893118098505744897029, 61813405877003583474955932500285761, 
  77510291046854672071894518915830832016429, 
  6592352576422405842686679637480708650164392620241, 
  187072209578355573530071639244871112681892570202113 ]
gap> Factors(3^303+1);
[ 2, 2, 7, 607, 379963, 6024412974817, 83456172594763, 
  30521057148658128808127704776211, 36663502524978969064590048175123903, 
  1017291527198723292208309354658785077827527 ]
gap> Factors(5^405+1);
[ 2, 3, 3, 3, 3, 3, 7, 61, 163, 487, 521, 1783, 5023, 5167, 7621, 164701, 
  16018507, 31472682400981, 182517282870121, 359683606111861, 
  60081451169922001, 223823944168266601, 2066067271380136212224701233463, 
  27958214476418447045648661835559283181, 
  9442584081375858136862743180967454511932842103271857498082499786865007991183\
35443897718426923221761 ]
gap> Factors(6^246+1);                   
[ 13, 37, 97, 7873, 4046701, 37448441257, 174521133001, 
  15918716269297453972620877, 830075109975781698496495921, 
  59589415533456305173269384769, 141358334611356937293327443617, 
  246179376206361788466441901958293949537091001 ]
gap> FactorsOfPowerPlusMinusOne(7^287+1);
[ [ 1636258751, 13903914179, 1463273844607, 266604208732109666783, 
      8005403352699006217853, 9434065448210481479155118150417, 911, 113 ], 
  [ 8, 3404690754069739112749751, 
      1286644124759375777832137899965768754797607387483, 
      144427797665195352251683045671117428091185676255445610501653 ] ]
gap> Factors(7^287+1);                   
[ 2, 2, 2, 113, 911, 1723, 4849399, 8999993, 175804721, 1636258751, 
  13903914179, 78009515593, 1463273844607, 266604208732109666783, 
  8005403352699006217853, 9434065448210481479155118150417, 
  7318598257434598572766074353405838030923, 
  83823446120252671068881628363968327388964408737925484911 ]
gap> Factors(10^210+1);                  
[ 29, 61, 101, 281, 421, 3541, 9901, 27961, 226549, 3471301, 4188901, 
  13489841, 39526741, 121499449, 1384194841, 42681134161, 60368344121, 
  424451728681, 4458192223320340849, 848654483879497562821, 
  139790941013628227711346421, 282448028612066894256984424869264385801 ]
gap> Factors(11^231+1);                   
[ 2, 2, 3, 3, 23, 37, 67, 89, 199, 463, 4621, 6007, 9439, 58367, 991651, 
  1623931, 23577401, 1169382127, 43037232701, 130958161489, 3421169496361, 
  1563791740201655119, 41987897476328997733, 160418704149053207551, 
  660895373524501126430959, 2040583524866430994330651, 
  1164439513543969580531315920300133078705833 ]
gap> Factors(12^303+1);
[ 7, 13, 19, 607, 1213, 21211, 231493, 298759, 1487513659, 
  526860472918622027980214644731465727, 69438508211723922167864504908608149557
    , 23648798515349572894998987860842035040840462710792821395657, 
  13745054507678430659791720945652348010150603799390812620405377, 
  2971259297253066332283096610300350786987686842744415299613364298372835792797\
3161994894362291830991307 ]
gap> Factors(2^2004-1);
[ 3, 3, 5, 7, 13, 304609, 857713, 2349023, 75005713, 223318747, 58152051961, 
  68488673941, 1134974373913, 27395325377910797, 79259861740715737, 
  18208260781190156536114609, 25129004796912072003423103, 
  11016209309893118098505744897029, 61813405877003583474955932500285761, 
  77510291046854672071894518915830832016429, 
  79638304766856507377778616296087448490695649, 
  6592352576422405842686679637480708650164392620241, 
  62357403192785191176690552862561408838653121833643, 
  187072209578355573530071639244871112681892570202113, 
  151092646351275754169926860141067686815825706612457363611594727781012756281,
  198950585925702911694795949136325395391616590334589163147577781735447402953 
 ]
gap> SetInfoLevel(InfoPrimeInt,oldwarninglevel);
gap> STOP_TEST( "factint.tst", 10000000000 );

#############################################################################
##
#E  factint.tst  . . . . . . . . . . . . . . . . . . . . . . . . .  ends here
