﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class RegisterPatchBaselineForPatchGroupResult {
 public:
  AWS_SSM_API RegisterPatchBaselineForPatchGroupResult() = default;
  AWS_SSM_API RegisterPatchBaselineForPatchGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API RegisterPatchBaselineForPatchGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the patch baseline the patch group was registered with.</p>
   */
  inline const Aws::String& GetBaselineId() const { return m_baselineId; }
  template <typename BaselineIdT = Aws::String>
  void SetBaselineId(BaselineIdT&& value) {
    m_baselineIdHasBeenSet = true;
    m_baselineId = std::forward<BaselineIdT>(value);
  }
  template <typename BaselineIdT = Aws::String>
  RegisterPatchBaselineForPatchGroupResult& WithBaselineId(BaselineIdT&& value) {
    SetBaselineId(std::forward<BaselineIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the patch group registered with the patch baseline.</p>
   */
  inline const Aws::String& GetPatchGroup() const { return m_patchGroup; }
  template <typename PatchGroupT = Aws::String>
  void SetPatchGroup(PatchGroupT&& value) {
    m_patchGroupHasBeenSet = true;
    m_patchGroup = std::forward<PatchGroupT>(value);
  }
  template <typename PatchGroupT = Aws::String>
  RegisterPatchBaselineForPatchGroupResult& WithPatchGroup(PatchGroupT&& value) {
    SetPatchGroup(std::forward<PatchGroupT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  RegisterPatchBaselineForPatchGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_baselineId;

  Aws::String m_patchGroup;

  Aws::String m_requestId;
  bool m_baselineIdHasBeenSet = false;
  bool m_patchGroupHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
