﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/oam/OAM_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace OAM {
namespace Model {

/**
 * <p>A structure that contains information about one of this source account's
 * links to a monitoring account.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListLinksItem">AWS
 * API Reference</a></p>
 */
class ListLinksItem {
 public:
  AWS_OAM_API ListLinksItem() = default;
  AWS_OAM_API ListLinksItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_OAM_API ListLinksItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OAM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the link.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ListLinksItem& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The random ID string that Amazon Web Services generated as part of the link
   * ARN.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ListLinksItem& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The label that was assigned to this link at creation, with the variables
   * resolved to their actual values.</p>
   */
  inline const Aws::String& GetLabel() const { return m_label; }
  inline bool LabelHasBeenSet() const { return m_labelHasBeenSet; }
  template <typename LabelT = Aws::String>
  void SetLabel(LabelT&& value) {
    m_labelHasBeenSet = true;
    m_label = std::forward<LabelT>(value);
  }
  template <typename LabelT = Aws::String>
  ListLinksItem& WithLabel(LabelT&& value) {
    SetLabel(std::forward<LabelT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource types supported by this link.</p>
   */
  inline const Aws::Vector<Aws::String>& GetResourceTypes() const { return m_resourceTypes; }
  inline bool ResourceTypesHasBeenSet() const { return m_resourceTypesHasBeenSet; }
  template <typename ResourceTypesT = Aws::Vector<Aws::String>>
  void SetResourceTypes(ResourceTypesT&& value) {
    m_resourceTypesHasBeenSet = true;
    m_resourceTypes = std::forward<ResourceTypesT>(value);
  }
  template <typename ResourceTypesT = Aws::Vector<Aws::String>>
  ListLinksItem& WithResourceTypes(ResourceTypesT&& value) {
    SetResourceTypes(std::forward<ResourceTypesT>(value));
    return *this;
  }
  template <typename ResourceTypesT = Aws::String>
  ListLinksItem& AddResourceTypes(ResourceTypesT&& value) {
    m_resourceTypesHasBeenSet = true;
    m_resourceTypes.emplace_back(std::forward<ResourceTypesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the sink that this link is attached to.</p>
   */
  inline const Aws::String& GetSinkArn() const { return m_sinkArn; }
  inline bool SinkArnHasBeenSet() const { return m_sinkArnHasBeenSet; }
  template <typename SinkArnT = Aws::String>
  void SetSinkArn(SinkArnT&& value) {
    m_sinkArnHasBeenSet = true;
    m_sinkArn = std::forward<SinkArnT>(value);
  }
  template <typename SinkArnT = Aws::String>
  ListLinksItem& WithSinkArn(SinkArnT&& value) {
    SetSinkArn(std::forward<SinkArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_id;

  Aws::String m_label;

  Aws::Vector<Aws::String> m_resourceTypes;

  Aws::String m_sinkArn;
  bool m_arnHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_labelHasBeenSet = false;
  bool m_resourceTypesHasBeenSet = false;
  bool m_sinkArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace OAM
}  // namespace Aws
