﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ResponseMetadata.h>
#include <aws/redshift/model/TaggedResource.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/TaggedResourceListMessage">AWS
 * API Reference</a></p>
 */
class DescribeTagsResult {
 public:
  AWS_REDSHIFT_API DescribeTagsResult() = default;
  AWS_REDSHIFT_API DescribeTagsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DescribeTagsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A list of tags with their associated resources.</p>
   */
  inline const Aws::Vector<TaggedResource>& GetTaggedResources() const { return m_taggedResources; }
  template <typename TaggedResourcesT = Aws::Vector<TaggedResource>>
  void SetTaggedResources(TaggedResourcesT&& value) {
    m_taggedResourcesHasBeenSet = true;
    m_taggedResources = std::forward<TaggedResourcesT>(value);
  }
  template <typename TaggedResourcesT = Aws::Vector<TaggedResource>>
  DescribeTagsResult& WithTaggedResources(TaggedResourcesT&& value) {
    SetTaggedResources(std::forward<TaggedResourcesT>(value));
    return *this;
  }
  template <typename TaggedResourcesT = TaggedResource>
  DescribeTagsResult& AddTaggedResources(TaggedResourcesT&& value) {
    m_taggedResourcesHasBeenSet = true;
    m_taggedResources.emplace_back(std::forward<TaggedResourcesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A value that indicates the starting point for the next set of response
   * records in a subsequent request. If a value is returned in a response, you can
   * retrieve the next set of records by providing this returned marker value in the
   * <code>Marker</code> parameter and retrying the command. If the
   * <code>Marker</code> field is empty, all response records have been retrieved for
   * the request. </p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeTagsResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeTagsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TaggedResource> m_taggedResources;

  Aws::String m_marker;

  ResponseMetadata m_responseMetadata;
  bool m_taggedResourcesHasBeenSet = false;
  bool m_markerHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
