﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datazone/DataZone_EXPORTS.h>
#include <aws/datazone/model/LineageEventProcessingStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {

/**
 * <p>The data lineage information.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/LineageInfo">AWS
 * API Reference</a></p>
 */
class LineageInfo {
 public:
  AWS_DATAZONE_API LineageInfo() = default;
  AWS_DATAZONE_API LineageInfo(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API LineageInfo& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The data lineage error message.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  LineageInfo& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data lineage event ID.</p>
   */
  inline const Aws::String& GetEventId() const { return m_eventId; }
  inline bool EventIdHasBeenSet() const { return m_eventIdHasBeenSet; }
  template <typename EventIdT = Aws::String>
  void SetEventId(EventIdT&& value) {
    m_eventIdHasBeenSet = true;
    m_eventId = std::forward<EventIdT>(value);
  }
  template <typename EventIdT = Aws::String>
  LineageInfo& WithEventId(EventIdT&& value) {
    SetEventId(std::forward<EventIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data lineage event status.</p>
   */
  inline LineageEventProcessingStatus GetEventStatus() const { return m_eventStatus; }
  inline bool EventStatusHasBeenSet() const { return m_eventStatusHasBeenSet; }
  inline void SetEventStatus(LineageEventProcessingStatus value) {
    m_eventStatusHasBeenSet = true;
    m_eventStatus = value;
  }
  inline LineageInfo& WithEventStatus(LineageEventProcessingStatus value) {
    SetEventStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_errorMessage;

  Aws::String m_eventId;

  LineageEventProcessingStatus m_eventStatus{LineageEventProcessingStatus::NOT_SET};
  bool m_errorMessageHasBeenSet = false;
  bool m_eventIdHasBeenSet = false;
  bool m_eventStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
