/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.AddConnectionWizard;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.netbeans.modules.db.util.JdbcUrl;
import org.netbeans.modules.db.util.PropertyEditorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NewConnectionPanel
extends ConnectionDialog.FocusablePanel {
    private static final Logger LOGGER = Logger.getLogger(NewConnectionPanel.class.getName());
    private static final Pattern numbers = Pattern.compile("(\\d+)");
    private static final String USERINPUT_FIELD = "<USERNAME>";
    private AddConnectionWizard wd;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private Window window;
    private boolean updatingUrl = false;
    private boolean updatingFields = false;
    private final LinkedHashMap<String, UrlField> urlFields = new LinkedHashMap();
    private final ConnectionPanel wp;
    private Properties connectionProperties = new Properties();
    private JButton bConnectionProperties;
    private JButton bTestConnection;
    private JTextField databaseField;
    private JLabel databaseLabel;
    private JLabel directUrlLabel;
    private JTextField dsnField;
    private JLabel dsnLabel;
    private JTextField hostField;
    private JLabel hostLabel;
    private ButtonGroup inputModeButtonGroup;
    private JTextField instanceField;
    private JLabel instanceLabel;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField serverNameField;
    private JLabel serverNameLabel;
    private JTextField serviceField;
    private JLabel serviceLabel;
    private JTextField sidField;
    private JLabel sidLabel;
    private JComboBox templateComboBox;
    private JLabel templateLabel;
    private JTextField tnsField;
    private JLabel tnsLabel;
    private JTextField urlField;
    private JTextField userField;
    private JLabel userLabel;
    private RequestProcessor RP = new RequestProcessor(NewConnectionPanel.class.getName(), 1);

    private void initFieldMap() {
        this.urlFields.put("<HOST>", new UrlField(this.hostField, this.hostLabel));
        this.urlFields.put("<PORT>", new UrlField(this.portField, this.portLabel));
        this.urlFields.put("<DB>", new UrlField(this.databaseField, this.databaseLabel));
        this.urlFields.put("<SID>", new UrlField(this.sidField, this.sidLabel));
        this.urlFields.put("<SERVICE>", new UrlField(this.serviceField, this.serviceLabel));
        this.urlFields.put("<TNSNAME>", new UrlField(this.tnsField, this.tnsLabel));
        this.urlFields.put("<DSN>", new UrlField(this.dsnField, this.dsnLabel));
        this.urlFields.put("<SERVERNAME>", new UrlField(this.serverNameField, this.serverNameLabel));
        this.urlFields.put("<INSTANCE>", new UrlField(this.instanceField, this.instanceLabel));
    }

    public NewConnectionPanel(AddConnectionWizard wizard, ConnectionPanel panel, String driverClass, DatabaseConnection connection) {
        this.wd = wizard;
        this.connection = connection;
        this.wp = panel;
        this.initComponents();
        this.initAccessibility();
        this.initFieldMap();
        DatabaseExplorerInternalUIs.connect(this.templateComboBox, JDBCDriverManager.getDefault(), driverClass);
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            @Override
            public void connectionStarted() {
                NewConnectionPanel.this.startProgress();
            }

            @Override
            public void connectionStep(String step) {
                NewConnectionPanel.this.setProgressMessage(step);
            }

            @Override
            public void connectionFinished() {
                NewConnectionPanel.this.stopProgress();
            }

            @Override
            public void connectionFailed() {
                NewConnectionPanel.this.stopProgress();
            }
        };
        this.wd.addConnectionProgressListener(progressListener);
        String driver = connection.getDriver();
        String driverName = connection.getDriverName();
        if (driver != null && driverName != null) {
            for (int i = 0; i < this.templateComboBox.getItemCount(); ++i) {
                Object item = this.templateComboBox.getItemAt(i);
                if (!(item instanceof JdbcUrl)) continue;
                JdbcUrl url = (JdbcUrl)item;
                assert (url.getDriver() != null);
                if (!url.getClassName().equals(driver) || !url.getDriver().getName().equals(driverName)) continue;
                this.templateComboBox.setSelectedIndex(i);
                break;
            }
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            new InputAdapter(entry.getValue().getField());
            new FocusAdapter(entry.getKey(), entry.getValue().getField());
        }
        new InputAdapter(this.templateComboBox);
        new InputAdapter(this.userField);
        new InputAdapter(this.passwordField);
        new FocusAdapter(USERINPUT_FIELD, this.userField);
        this.urlField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                NewConnectionPanel.this.updateFieldsFromUrl();
            }
        });
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }
        });
        this.setUrlField();
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (this.wd.getUser() != null) {
            this.userField.setText(this.wd.getUser());
        } else if (url.getSampleUser() != null) {
            this.userField.setText(url.getSampleUser());
        }
        if (this.wd.getPassword() != null) {
            this.passwordField.setText(this.wd.getPassword());
        } else if (url.getSamplePassword() != null) {
            this.passwordField.setText(url.getSamplePassword());
        }
        if (this.wd.getDatabaseUrl() != null) {
            this.urlField.setText(this.wd.getDatabaseUrl());
        } else if (url.getSampleUrl() != null) {
            this.urlField.setText(url.getSampleUrl());
        }
        this.updateFieldsFromUrl();
        this.setUpFields();
        this.connectionProperties = connection.getConnectionProperties();
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                NewConnectionPanel.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                NewConnectionPanel.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                NewConnectionPanel.this.fireChange();
            }
        };
        this.userField.getDocument().addDocumentListener(docListener);
        this.passwordField.getDocument().addDocumentListener(docListener);
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    private void initAccessibility() {
        this.templateLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverNameA11yDesc"));
        this.templateComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverNameComboBoxA11yName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameA11yDesc"));
        this.userField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordTextFieldA11yName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostA11yDesc"));
        this.hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostTextFieldA11yName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortA11yDesc"));
        this.portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortTextFieldA11yName"));
        this.serverNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameTextFieldA11yName"));
        this.serverNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameA11yDesc"));
        this.databaseField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameTextFieldA11yName"));
        this.databaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameA11yDesc"));
        this.urlField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLTextFieldA11yName"));
        this.sidField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDTextFieldA11yName"));
        this.sidLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDA11yDesc"));
        this.serviceField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameTextFieldA11yName"));
        this.serviceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameTextFieldA11yName"));
        this.tnsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameA11yDesc"));
        this.dsnField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNTextFieldA11yName"));
        this.dsnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNA11yDesc"));
        this.instanceField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameTextFieldA11yName"));
        this.instanceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameA11yDesc"));
    }

    @Override
    public void initializeFocus() {
        this.setFocus();
    }

    private void initComponents() {
        this.inputModeButtonGroup = new ButtonGroup();
        this.templateComboBox = new JComboBox();
        this.hostField = new JTextField();
        this.templateLabel = new JLabel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.databaseLabel = new JLabel();
        this.databaseField = new JTextField();
        this.sidLabel = new JLabel();
        this.sidField = new JTextField();
        this.serviceLabel = new JLabel();
        this.serviceField = new JTextField();
        this.tnsLabel = new JLabel();
        this.tnsField = new JTextField();
        this.serverNameLabel = new JLabel();
        this.serverNameField = new JTextField();
        this.instanceLabel = new JLabel();
        this.instanceField = new JTextField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.dsnLabel = new JLabel();
        this.dsnField = new JTextField();
        this.urlField = new JTextField();
        this.passwordCheckBox = new JCheckBox();
        this.directUrlLabel = new JLabel();
        this.bTestConnection = new JButton();
        this.bConnectionProperties = new JButton();
        FormListener formListener = new FormListener();
        this.templateComboBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverClassComboBoxA11yDesc"));
        this.templateComboBox.addItemListener(formListener);
        this.templateComboBox.addActionListener(formListener);
        this.hostField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostA11yDesc"));
        this.templateLabel.setLabelFor(this.templateComboBox);
        Mnemonics.setLocalizedText((JLabel)this.templateLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDriverName"));
        this.hostLabel.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionHost"));
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPort"));
        this.portField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortA11yDesc"));
        this.databaseLabel.setLabelFor(this.databaseField);
        Mnemonics.setLocalizedText((JLabel)this.databaseLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDatabase"));
        this.databaseField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameA11yDesc"));
        this.sidLabel.setLabelFor(this.sidField);
        Mnemonics.setLocalizedText((JLabel)this.sidLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionSID"));
        this.sidField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDA11yDesc"));
        this.serviceLabel.setLabelFor(this.serviceField);
        Mnemonics.setLocalizedText((JLabel)this.serviceLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionServiceName"));
        this.serviceField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsLabel.setLabelFor(this.tnsField);
        Mnemonics.setLocalizedText((JLabel)this.tnsLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionTNSName"));
        this.tnsField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameA11yDesc"));
        this.serverNameLabel.setLabelFor(this.serverNameField);
        Mnemonics.setLocalizedText((JLabel)this.serverNameLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionServerName"));
        this.serverNameField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameA11yDesc"));
        this.instanceLabel.setLabelFor(this.instanceField);
        Mnemonics.setLocalizedText((JLabel)this.instanceLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionInstanceName"));
        this.instanceField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameA11yDesc"));
        this.userLabel.setLabelFor(this.userField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionUserName"));
        this.userField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameA11yDesc"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPassword"));
        this.passwordField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordA11yDesc"));
        this.dsnLabel.setLabelFor(this.dsnField);
        Mnemonics.setLocalizedText((JLabel)this.dsnLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDSN"));
        this.dsnField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNA11yDesc"));
        this.urlField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLA11yDesc"));
        this.urlField.addActionListener(formListener);
        this.urlField.addFocusListener(formListener);
        this.urlField.addKeyListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.passwordCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionRememberPasswordA11yDesc"));
        this.passwordCheckBox.setMargin(new Insets(3, 0, 1, 1));
        this.directUrlLabel.setLabelFor(this.urlField);
        Mnemonics.setLocalizedText((JLabel)this.directUrlLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDirectURL"));
        Mnemonics.setLocalizedText((AbstractButton)this.bTestConnection, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPanel.bTestConnection"));
        this.bTestConnection.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.bConnectionProperties, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPanel.bConnectionProperties"));
        this.bConnectionProperties.addActionListener(formListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.directUrlLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.instanceLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.serverNameLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.dsnLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.tnsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.serviceLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.sidLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.databaseLabel, GroupLayout.Alignment.LEADING)).addComponent(this.templateLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.userLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bConnectionProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTestConnection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 100, Short.MAX_VALUE)).addComponent(this.userField, GroupLayout.Alignment.TRAILING).addComponent(this.sidField).addComponent(this.serviceField).addComponent(this.tnsField).addComponent(this.dsnField).addComponent(this.serverNameField).addComponent(this.instanceField).addGroup(layout.createSequentialGroup().addComponent(this.hostField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portLabel).addGap(2, 2, 2).addComponent(this.portField, -2, 105, -2)).addComponent(this.databaseField, GroupLayout.Alignment.TRAILING).addComponent(this.passwordField).addComponent(this.urlField, GroupLayout.Alignment.TRAILING).addComponent(this.templateComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.passwordCheckBox, -2, 256, -2).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateLabel).addComponent(this.templateComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.hostField, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portField, -2, -1, -2).addComponent(this.portLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.databaseLabel).addComponent(this.databaseField, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sidLabel).addComponent(this.sidField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serviceLabel).addComponent(this.serviceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tnsLabel).addComponent(this.tnsField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dsnLabel).addComponent(this.dsnField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverNameLabel).addComponent(this.serverNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instanceLabel).addComponent(this.instanceField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordCheckBox).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bTestConnection).addComponent(this.bConnectionProperties)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlField, -2, -1, -2).addComponent(this.directUrlLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.bTestConnection.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionWizard.bTestConnection.ACD"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACD_NewConnectionPanel"));
    }

    private void urlFieldActionPerformed(ActionEvent evt) {
    }

    private void urlFieldFocusLost(FocusEvent evt) {
    }

    private void urlFieldKeyPressed(KeyEvent evt) {
    }

    private void templateComboBoxActionPerformed(ActionEvent evt) {
    }

    private void templateComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            Object item = evt.getItem();
            if (item != null && !(item instanceof JdbcUrl)) {
                return;
            }
            JdbcUrl jdbcurl = (JdbcUrl)item;
            if (!jdbcurl.isParseUrl()) {
                this.updateInputMode(false);
            } else {
                this.setUpFields();
            }
            if (this.wd.getDatabaseUrl() == null && jdbcurl.getSampleUrl() != null) {
                this.urlField.setText(jdbcurl.getSampleUrl());
                this.updateFieldsFromUrl();
            } else {
                this.updateUrlFromFields();
            }
            this.fireChange();
        }
    }

    private void bTestConnectionActionPerformed(ActionEvent evt) {
        this.tryConnection();
    }

    private void bConnectionPropertiesActionPerformed(ActionEvent evt) {
        PropertyEditorPanel pep = new PropertyEditorPanel(this.connectionProperties, true);
        DialogDescriptor dd = new DialogDescriptor((Object)pep, NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPanel.dlgConnectionProperties"), true, null);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == NotifyDescriptor.OK_OPTION) {
            this.connectionProperties = pep.getValue();
        }
    }

    public void setConnectionInfo() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (url != null) {
            JDBCDriver driver = url.getDriver();
            assert (driver != null);
            this.connection.setDriverName(driver.getName());
            this.connection.setDriver(driver.getClassName());
        }
        this.connection.setDatabase(this.urlField.getText());
        this.connection.setUser(this.userField.getText());
        this.connection.setPassword(this.getPassword());
        this.connection.setRememberPassword(this.passwordCheckBox.isSelected());
        this.connection.setConnectionProperties(this.connectionProperties);
    }

    private void resize() {
        this.revalidate();
        if (this.window != null) {
            this.window.pack();
        }
    }

    private void updateInputMode(boolean copyUrl) {
        this.setUpFields();
    }

    private void setUpFields() {
        Object item = this.templateComboBox.getSelectedItem();
        if (item != null && !(item instanceof JdbcUrl)) {
            return;
        }
        JdbcUrl jdbcurl = (JdbcUrl)item;
        if (jdbcurl == null) {
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(false);
                entry.getValue().getLabel().setVisible(false);
            }
            this.checkValid();
            this.resize();
            return;
        }
        this.userField.setVisible(true);
        this.userLabel.setVisible(true);
        this.passwordField.setVisible(true);
        this.passwordLabel.setVisible(true);
        this.passwordCheckBox.setVisible(true);
        this.directUrlLabel.setVisible(true);
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            entry.getValue().getField().setVisible(jdbcurl.supportsToken(entry.getKey()));
            entry.getValue().getLabel().setVisible(jdbcurl.supportsToken(entry.getKey()));
        }
        if (!jdbcurl.isParseUrl()) {
            this.setUrlField();
        }
        this.setFocus();
        this.checkValid();
        this.resize();
    }

    private void setFocus() {
        if (this.templateComboBox.getItemCount() <= 1) {
            this.templateComboBox.requestFocusInWindow();
            return;
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            if (!entry.getValue().getField().isVisible()) continue;
            entry.getValue().getField().requestFocusInWindow();
            return;
        }
        this.userField.requestFocusInWindow();
    }

    private JdbcUrl getSelectedJdbcUrl() {
        Object item = this.templateComboBox.getSelectedItem();
        if (!(item instanceof JdbcUrl)) {
            return null;
        }
        return (JdbcUrl)item;
    }

    private void setUrlField() {
        if (!this.connection.getDatabase().isEmpty()) {
            this.urlField.setText(this.connection.getDatabase());
            return;
        }
        JdbcUrl jdbcurl = this.getSelectedJdbcUrl();
        if (jdbcurl == null) {
            this.urlField.setText("");
            return;
        }
        if (jdbcurl.isParseUrl()) {
            this.updateUrlFromFields();
        } else {
            this.urlField.setText(jdbcurl.getUrlTemplate());
        }
    }

    private String getPassword() {
        String tempPassword = new String(this.passwordField.getPassword());
        String password = tempPassword.length() > 0 ? tempPassword : null;
        return password;
    }

    public String getTitle() {
        return NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewConnectionPanel.this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NewConnectionPanel.class, (String)"ConnectionProgress_Connecting"));
                NewConnectionPanel.this.progressHandle.start();
                NewConnectionPanel.this.enableInput(false);
            }
        });
    }

    private void setProgressMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ NewConnectionPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.progressHandle != null) {
                    this.this$0.progressHandle.setDisplayName(message);
                }
            }
        });
    }

    public void terminateProgress() {
        this.stopProgress();
    }

    private void stopProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.finish();
                    NewConnectionPanel.this.enableInput(true);
                }
            }
        });
    }

    private void enableInput(boolean enable) {
        this.templateComboBox.setEnabled(enable);
        this.userField.setEnabled(enable);
        this.passwordField.setEnabled(enable);
        this.passwordCheckBox.setEnabled(enable);
        this.urlField.setEnabled(enable);
        this.bTestConnection.setEnabled(enable);
        this.bConnectionProperties.setEnabled(enable);
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            entry.getValue().getField().setEnabled(enable);
        }
    }

    private void resetProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.setDisplayName("");
        }
    }

    private void fireChange() {
        this.wd.closeConnection();
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
        this.wp.fireChangeEvent();
    }

    private void updateUrlFromFields() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (url == null || !url.isParseUrl()) {
            return;
        }
        if (!this.updatingUrl) {
            this.updatingFields = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                url.put(entry.getKey(), entry.getValue().getField().getText());
            }
            this.urlField.setText(url.getUrl());
            this.updatingFields = false;
        }
        this.checkValid();
    }

    void checkValid() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        boolean requiredFieldMissing = false;
        if (url == null) {
            this.displayMessage(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SelectADriver"), false);
        } else if (url.isParseUrl()) {
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                if (!url.requiresToken(entry.getKey()) || !this.isEmpty(entry.getValue().getField().getText())) continue;
                requiredFieldMissing = true;
                String fieldName = entry.getValue().getLabel().getText();
                if (fieldName.endsWith(":")) {
                    fieldName = fieldName.substring(0, fieldName.length() - 1);
                }
                this.displayMessage(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.ERR_FieldRequired", (Object)fieldName), false);
            }
            if (!requiredFieldMissing) {
                this.clearError();
            }
        } else if (this.isEmpty(this.urlField.getText())) {
            this.displayMessage(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SpecifyURL"), false);
        } else {
            this.clearError();
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void updateFieldsFromUrl() {
        JdbcUrl url = this.getSelectedJdbcUrl();
        if (url == null) {
            return;
        }
        if (this.updatingFields) {
            return;
        }
        try {
            url.setUrl(this.urlField.getText());
            this.clearError();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        if (url.isParseUrl()) {
            this.updatingUrl = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setText((String)url.get(entry.getKey()));
            }
            this.updatingUrl = false;
        }
    }

    private void clearError() {
        this.wd.getNotificationLineSupport().clearMessages();
        this.wd.setValid(true);
        this.wp.fireChangeEvent();
    }

    private void displayMessage(String message, boolean isError) {
        this.wd.setValid(!isError);
        this.wp.fireChangeEvent();
        if (isError) {
            this.wd.getNotificationLineSupport().setErrorMessage(message);
        } else {
            this.wd.getNotificationLineSupport().setInformationMessage(message);
        }
    }

    private void tryConnection() {
        this.setWaitingState(true);
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                NewConnectionPanel.this.testConnection();
            }
        });
    }

    public void setWaitingState(boolean wait) {
        JRootPane rootPane = this.getRootPane();
        this.enableInput(!wait);
        if (rootPane != null) {
            rootPane.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
        }
    }

    private void testConnection() {
        try {
            this.setConnectionInfo();
            this.wp.validate();
            this.displayMessage(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPanel.ConnectionPassed"), false);
        }
        catch (WizardValidationException ex) {
            this.displayMessage(ex.getLocalizedMessage(), true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewConnectionPanel.this.setWaitingState(false);
            }
        });
    }

    boolean valid() {
        this.setConnectionInfo();
        return this.wd.getValid();
    }

    private class UrlField {
        private final JTextField field;
        private final JLabel label;

        public UrlField(JTextField field, JLabel label) {
            this.field = field;
            this.label = label;
        }

        public JTextField getField() {
            return this.field;
        }

        public JLabel getLabel() {
            return this.label;
        }
    }

    private class InputAdapter
    implements DocumentListener,
    ListDataListener {
        public InputAdapter(JTextField source) {
            source.getDocument().addDocumentListener(this);
        }

        public InputAdapter(JComboBox source) {
            source.getModel().addListDataListener(this);
        }

        public InputAdapter(JTextArea source) {
            source.getDocument().addDocumentListener(this);
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            NewConnectionPanel.this.fireChange();
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }
    }

    private class FocusAdapter
    implements FocusListener {
        private final String targetToken;

        public FocusAdapter(String targetToken, JTextField textField) {
            this.targetToken = targetToken;
            textField.addFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source instanceof JTextField) {
                JTextField textField = (JTextField)source;
                String inputText = textField.getText();
                switch (this.targetToken) {
                    case "<HOST>": 
                    case "<DB>": 
                    case "<SID>": 
                    case "<SERVICE>": 
                    case "<TNSNAME>": 
                    case "<DSN>": 
                    case "<SERVERNAME>": 
                    case "<INSTANCE>": 
                    case "<USERNAME>": {
                        textField.setText(inputText.trim());
                        break;
                    }
                    case "<PORT>": {
                        Integer port = null;
                        try {
                            port = Integer.valueOf(inputText.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (port != null) {
                            textField.setText(Integer.toString(port));
                            break;
                        }
                        Matcher numberMatcher = numbers.matcher(inputText);
                        if (numberMatcher.find()) {
                            textField.setText(numberMatcher.group(1));
                            break;
                        }
                        textField.setText("");
                        break;
                    }
                }
            }
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener,
    KeyListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.bTestConnection) {
                NewConnectionPanel.this.bTestConnectionActionPerformed(evt);
            } else if (evt.getSource() == NewConnectionPanel.this.bConnectionProperties) {
                NewConnectionPanel.this.bConnectionPropertiesActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldFocusLost(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxItemStateChanged(evt);
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldKeyPressed(evt);
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }
    }
}

