/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.util.ArrayList;

public final class StopWatch {
    private final String name;
    private final ArrayList<Mark> marks = new ArrayList();
    private boolean running;

    public StopWatch(String name) {
        this.name = name;
    }

    public void start() {
        this.marks.clear();
        this.marks.add(new Mark("start"));
        this.running = true;
    }

    public void stop() {
        this.marks.add(new Mark("stop"));
        this.running = false;
    }

    public void mark(String name) {
        if (this.running) {
            this.marks.add(new Mark(name));
        }
    }

    private long totalElapsedTime() {
        if (this.marks.size() <= 1) {
            return 0L;
        }
        long startTime = this.marks.get(0).time();
        long endTime = this.marks.get(this.marks.size() - 1).time();
        return endTime - startTime;
    }

    public void dump(int thresholdMillis) {
        if (thresholdMillis > 0 && this.totalElapsedTime() < (long)thresholdMillis) {
            return;
        }
        System.out.printf("StopWatch[%s]\n", this.name);
        if (this.marks.size() == 0) {
            System.out.printf("\tnever started\n", new Object[0]);
            return;
        }
        if (this.running) {
            System.out.printf("\tstill running\n", new Object[0]);
            return;
        }
        long startTime = this.marks.get(0).time();
        for (Mark mark : this.marks) {
            System.out.printf("%-10s: %d\n", mark.name(), mark.time() - startTime);
        }
    }

    public void dump() {
        this.dump(0);
    }

    private static final class Mark {
        private final String name;
        private final long time;

        public Mark(String name) {
            this.name = name;
            this.time = System.currentTimeMillis();
        }

        public String name() {
            return this.name;
        }

        public long time() {
            return this.time;
        }
    }
}

