/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Dialog;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EjbReferencesTableModel
extends InnerTableModel {
    private XmlMultiViewDataObject dataObject;
    Ejb ejb;
    private static final String[] COLUMN_NAMES = new String[]{NbBundle.getBundle(EjbReferencesTableModel.class).getString("LBL_ReferenceName"), NbBundle.getBundle(EjbReferencesTableModel.class).getString("LBL_LinkedEjb"), NbBundle.getBundle(EjbReferencesTableModel.class).getString("LBL_Interface"), NbBundle.getBundle(EjbReferencesTableModel.class).getString("LBL_Description")};
    private static final int[] COLUMN_WIDTHS = new int[]{170, 260, 70, 250};

    public EjbReferencesTableModel(XmlMultiViewDataObject dataObject, Ejb ejb) {
        super(((EjbJarMultiViewDataObject)dataObject).getModelSynchronizer(), COLUMN_NAMES, COLUMN_WIDTHS);
        this.dataObject = dataObject;
        this.ejb = ejb;
    }

    @Override
    public int getRowCount() {
        return this.ejb.getEjbLocalRef().length + this.ejb.getEjbRef().length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isColumnEditable(column);
    }

    @Override
    public int addRow() {
        return -1;
    }

    @Override
    public void removeRow(int selectedRow) {
        ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(EjbReferencesTableModel.class, (String)"LBL_RemoveEjbRefWarning"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
            EjbLocalRef localRef = this.ejb.getEjbLocalRef(selectedRow);
            if (localRef != null) {
                this.ejb.removeEjbLocalRef(localRef);
            } else {
                EjbRef ref = this.ejb.getEjbRef(selectedRow);
                if (ref != null) {
                    this.ejb.removeEjbRef(ref);
                }
            }
            this.modelUpdatedFromUI();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int n = this.ejb.getEjbLocalRef().length;
        if (rowIndex < n) {
            EjbLocalRef ref = this.ejb.getEjbLocalRef(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ref.getEjbRefName();
                }
                case 1: {
                    return ref.getEjbLink();
                }
                case 2: {
                    return "local";
                }
                case 3: {
                    return ref.getDefaultDescription();
                }
            }
        } else {
            EjbRef ref = this.ejb.getEjbRef(rowIndex - n);
            switch (columnIndex) {
                case 0: {
                    return ref.getEjbRefName();
                }
                case 1: {
                    return ref.getEjbLink();
                }
                case 2: {
                    return "remote";
                }
                case 3: {
                    return ref.getDefaultDescription();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isColumnEditable(columnIndex)) {
            return;
        }
        EjbRef ref = this.ejb.getEjbRef(rowIndex);
        if (ref != null) {
            ref.setDescription((String)aValue);
        } else {
            EjbLocalRef localRef = this.ejb.getEjbLocalRef(rowIndex);
            if (localRef != null) {
                localRef.setDescription((String)aValue);
            }
        }
        this.modelUpdatedFromUI();
    }

    private boolean isColumnEditable(int columnIndex) {
        return columnIndex == 3;
    }
}

