/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReplicationSource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="policyName")
    private final String policyName;
    @JsonProperty(value="sourceRegionName")
    private final String sourceRegionName;
    @JsonProperty(value="sourceBucketName")
    private final String sourceBucketName;

    @Deprecated
    @ConstructorProperties(value={"policyName", "sourceRegionName", "sourceBucketName"})
    public ReplicationSource(String policyName, String sourceRegionName, String sourceBucketName) {
        this.policyName = policyName;
        this.sourceRegionName = sourceRegionName;
        this.sourceBucketName = sourceBucketName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getSourceRegionName() {
        return this.sourceRegionName;
    }

    public String getSourceBucketName() {
        return this.sourceBucketName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicationSource(");
        sb.append("super=").append(super.toString());
        sb.append("policyName=").append(String.valueOf(this.policyName));
        sb.append(", sourceRegionName=").append(String.valueOf(this.sourceRegionName));
        sb.append(", sourceBucketName=").append(String.valueOf(this.sourceBucketName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationSource)) {
            return false;
        }
        ReplicationSource other = (ReplicationSource)((Object)o);
        return Objects.equals(this.policyName, other.policyName) && Objects.equals(this.sourceRegionName, other.sourceRegionName) && Objects.equals(this.sourceBucketName, other.sourceBucketName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.policyName == null ? 43 : this.policyName.hashCode());
        result = result * 59 + (this.sourceRegionName == null ? 43 : this.sourceRegionName.hashCode());
        result = result * 59 + (this.sourceBucketName == null ? 43 : this.sourceBucketName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="policyName")
        private String policyName;
        @JsonProperty(value="sourceRegionName")
        private String sourceRegionName;
        @JsonProperty(value="sourceBucketName")
        private String sourceBucketName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            this.__explicitlySet__.add("policyName");
            return this;
        }

        public Builder sourceRegionName(String sourceRegionName) {
            this.sourceRegionName = sourceRegionName;
            this.__explicitlySet__.add("sourceRegionName");
            return this;
        }

        public Builder sourceBucketName(String sourceBucketName) {
            this.sourceBucketName = sourceBucketName;
            this.__explicitlySet__.add("sourceBucketName");
            return this;
        }

        public ReplicationSource build() {
            ReplicationSource model = new ReplicationSource(this.policyName, this.sourceRegionName, this.sourceBucketName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReplicationSource model) {
            if (model.wasPropertyExplicitlySet("policyName")) {
                this.policyName(model.getPolicyName());
            }
            if (model.wasPropertyExplicitlySet("sourceRegionName")) {
                this.sourceRegionName(model.getSourceRegionName());
            }
            if (model.wasPropertyExplicitlySet("sourceBucketName")) {
                this.sourceBucketName(model.getSourceBucketName());
            }
            return this;
        }
    }
}

