/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import nu.validator.htmlparser.common.CharacterHandler;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.TransitionHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.ErrorReportingTokenizer;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.htmlparser.io.Driver;
import nu.validator.htmlparser.sax.SAXStreamer;
import nu.validator.htmlparser.sax.SAXTreeBuilder;
import nu.validator.saxtree.Document;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.TreeParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParser
implements XMLReader {
    private Driver driver = null;
    private TreeBuilder<?> treeBuilder = null;
    private SAXStreamer saxStreamer = null;
    private SAXTreeBuilder saxTreeBuilder = null;
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private DTDHandler dtdHandler = null;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private DocumentModeHandler documentModeHandler = null;
    private DoctypeExpectation doctypeExpectation = DoctypeExpectation.HTML;
    private boolean checkingNormalization = false;
    private boolean scriptingEnabled = false;
    private final List<CharacterHandler> characterHandlers = new LinkedList<CharacterHandler>();
    private XmlViolationPolicy contentSpacePolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy contentNonXmlCharPolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy commentPolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy streamabilityViolationPolicy = XmlViolationPolicy.ALLOW;
    private boolean html4ModeCompatibleWithXhtml1Schemata = false;
    private boolean mappingLangToXmlLang = false;
    private XmlViolationPolicy xmlnsPolicy = XmlViolationPolicy.FATAL;
    private boolean reportingDoctype = true;
    private ErrorHandler treeBuilderErrorHandler = null;
    private Heuristics heuristics = Heuristics.NONE;
    private HashMap<String, String> errorProfileMap = null;
    private TransitionHandler transitionHandler = null;

    public HtmlParser() {
        this(XmlViolationPolicy.FATAL);
    }

    public HtmlParser(XmlViolationPolicy xmlPolicy) {
        this.setXmlPolicy(xmlPolicy);
    }

    private Tokenizer newTokenizer(TokenHandler handler, boolean newAttributesEachTime) {
        if (this.errorHandler == null && this.transitionHandler == null && this.contentNonXmlCharPolicy == XmlViolationPolicy.ALLOW) {
            return new Tokenizer(handler, newAttributesEachTime);
        }
        ErrorReportingTokenizer tokenizer = new ErrorReportingTokenizer(handler, newAttributesEachTime);
        tokenizer.setErrorProfile(this.errorProfileMap);
        return tokenizer;
    }

    private void lazyInit() {
        if (this.driver == null) {
            if (this.streamabilityViolationPolicy == XmlViolationPolicy.ALLOW) {
                this.treeBuilder = this.saxTreeBuilder = new SAXTreeBuilder();
                this.saxStreamer = null;
                this.driver = new Driver(this.newTokenizer(this.treeBuilder, true));
            } else {
                this.treeBuilder = this.saxStreamer = new SAXStreamer();
                this.saxTreeBuilder = null;
                this.driver = new Driver(this.newTokenizer(this.treeBuilder, false));
            }
            this.driver.setErrorHandler(this.errorHandler);
            this.driver.setTransitionHandler(this.transitionHandler);
            this.treeBuilder.setErrorHandler(this.treeBuilderErrorHandler);
            this.driver.setCheckingNormalization(this.checkingNormalization);
            this.driver.setCommentPolicy(this.commentPolicy);
            this.driver.setContentNonXmlCharPolicy(this.contentNonXmlCharPolicy);
            this.driver.setContentSpacePolicy(this.contentSpacePolicy);
            this.driver.setHtml4ModeCompatibleWithXhtml1Schemata(this.html4ModeCompatibleWithXhtml1Schemata);
            this.driver.setMappingLangToXmlLang(this.mappingLangToXmlLang);
            this.driver.setXmlnsPolicy(this.xmlnsPolicy);
            this.driver.setHeuristics(this.heuristics);
            for (CharacterHandler characterHandler : this.characterHandlers) {
                this.driver.addCharacterHandler(characterHandler);
            }
            this.treeBuilder.setDoctypeExpectation(this.doctypeExpectation);
            this.treeBuilder.setDocumentModeHandler(this.documentModeHandler);
            this.treeBuilder.setIgnoringComments(this.lexicalHandler == null);
            this.treeBuilder.setScriptingEnabled(this.scriptingEnabled);
            this.treeBuilder.setReportingDoctype(this.reportingDoctype);
            this.treeBuilder.setNamePolicy(this.namePolicy);
            if (this.saxStreamer != null) {
                this.saxStreamer.setContentHandler(this.contentHandler == null ? new DefaultHandler() : this.contentHandler);
                this.saxStreamer.setLexicalHandler(this.lexicalHandler);
                this.driver.setAllowRewinding(false);
            }
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/external-general-entities".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/is-standalone".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/lexical-handler/parameter-entities".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/unicode-normalization-checking".equals(name)) {
            return this.isCheckingNormalization();
        }
        if ("http://xml.org/sax/features/use-attributes2".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/use-locator2".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/validation".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/xmlns-uris".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/xml-1.1".equals(name)) {
            return false;
        }
        if ("http://validator.nu/features/html4-mode-compatible-with-xhtml1-schemata".equals(name)) {
            return this.isHtml4ModeCompatibleWithXhtml1Schemata();
        }
        if ("http://validator.nu/features/mapping-lang-to-xml-lang".equals(name)) {
            return this.isMappingLangToXmlLang();
        }
        if ("http://validator.nu/features/scripting-enabled".equals(name)) {
            return this.isScriptingEnabled();
        }
        throw new SAXNotRecognizedException();
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            throw new SAXNotSupportedException("This parser does not suppert DeclHandler.");
        }
        if ("http://xml.org/sax/properties/document-xml-version".equals(name)) {
            return "1.0";
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            throw new SAXNotSupportedException("This parser does not walk the DOM.");
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.getLexicalHandler();
        }
        if ("http://xml.org/sax/properties/xml-string".equals(name)) {
            throw new SAXNotSupportedException("This parser does not expose the source as a string.");
        }
        if ("http://validator.nu/properties/content-space-policy".equals(name)) {
            return this.getContentSpacePolicy();
        }
        if ("http://validator.nu/properties/content-non-xml-char-policy".equals(name)) {
            return this.getContentNonXmlCharPolicy();
        }
        if ("http://validator.nu/properties/comment-policy".equals(name)) {
            return this.getCommentPolicy();
        }
        if ("http://validator.nu/properties/xmlns-policy".equals(name)) {
            return this.getXmlnsPolicy();
        }
        if ("http://validator.nu/properties/name-policy".equals(name)) {
            return this.getNamePolicy();
        }
        if ("http://validator.nu/properties/streamability-violation-policy".equals(name)) {
            return this.getStreamabilityViolationPolicy();
        }
        if ("http://validator.nu/properties/document-mode-handler".equals(name)) {
            return this.getDocumentModeHandler();
        }
        if ("http://validator.nu/properties/doctype-expectation".equals(name)) {
            return this.getDoctypeExpectation();
        }
        if ("http://validator.nu/properties/xml-policy".equals(name)) {
            throw new SAXNotSupportedException("Cannot get a convenience setter.");
        }
        if ("http://validator.nu/properties/heuristics".equals(name)) {
            return this.getHeuristics();
        }
        throw new SAXNotRecognizedException();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.lazyInit();
        try {
            this.treeBuilder.setFragmentContext(null);
            this.tokenize(input);
        }
        finally {
            Document document;
            if (this.saxTreeBuilder != null && (document = this.saxTreeBuilder.getDocument()) != null) {
                new TreeParser(this.contentHandler, this.lexicalHandler).parse(document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFragment(InputSource input, String context) throws IOException, SAXException {
        this.lazyInit();
        try {
            this.treeBuilder.setFragmentContext(context.intern());
            this.tokenize(input);
        }
        finally {
            if (this.saxTreeBuilder != null) {
                DocumentFragment fragment = this.saxTreeBuilder.getDocumentFragment();
                new TreeParser(this.contentHandler, this.lexicalHandler).parse(fragment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFragment(InputSource input, String contextLocal, String contextNamespace) throws IOException, SAXException {
        this.lazyInit();
        try {
            this.treeBuilder.setFragmentContext(contextLocal.intern(), contextNamespace.intern(), null, false);
            this.tokenize(input);
        }
        finally {
            if (this.saxTreeBuilder != null) {
                DocumentFragment fragment = this.saxTreeBuilder.getDocumentFragment();
                new TreeParser(this.contentHandler, this.lexicalHandler).parse(fragment);
            }
        }
    }

    private void tokenize(InputSource is) throws SAXException, IOException, MalformedURLException {
        if (is == null) {
            throw new IllegalArgumentException("Null input.");
        }
        if (is.getByteStream() == null && is.getCharacterStream() == null) {
            String systemId = is.getSystemId();
            if (systemId == null) {
                throw new IllegalArgumentException("No byte stream, no character stream nor URI.");
            }
            if (this.entityResolver != null) {
                is = this.entityResolver.resolveEntity(is.getPublicId(), systemId);
            }
            if (is.getByteStream() == null || is.getCharacterStream() == null) {
                is = new InputSource();
                is.setSystemId(systemId);
                is.setByteStream(new URL(systemId).openStream());
            }
        }
        this.driver.tokenize(is);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (this.saxStreamer != null) {
            this.saxStreamer.setContentHandler(this.contentHandler == null ? new DefaultHandler() : this.contentHandler);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
        if (this.treeBuilder != null) {
            this.treeBuilder.setIgnoringComments(handler == null);
            if (this.saxStreamer != null) {
                this.saxStreamer.setLexicalHandler(handler);
            }
        }
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
        this.treeBuilderErrorHandler = handler;
        this.driver = null;
    }

    public void setTransitionHandler(TransitionHandler handler) {
        this.transitionHandler = handler;
        this.driver = null;
    }

    public void setTreeBuilderErrorHandlerOverride(ErrorHandler handler) {
        this.treeBuilderErrorHandler = handler;
        if (this.driver != null) {
            this.treeBuilder.setErrorHandler(handler);
        }
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/external-general-entities".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/external-parameter-entities".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/is-standalone".equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/lexical-handler/parameter-entities".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/namespaces".equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/resolve-dtd-uris".equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/string-interning".equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/unicode-normalization-checking".equals(name)) {
            this.setCheckingNormalization(value);
        } else if ("http://xml.org/sax/features/use-attributes2".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/use-locator2".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/use-entity-resolver2".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/validation".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/xmlns-uris".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://xml.org/sax/features/xml-1.1".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
        } else if ("http://validator.nu/features/html4-mode-compatible-with-xhtml1-schemata".equals(name)) {
            this.setHtml4ModeCompatibleWithXhtml1Schemata(value);
        } else if ("http://validator.nu/features/mapping-lang-to-xml-lang".equals(name)) {
            this.setMappingLangToXmlLang(value);
        } else if ("http://validator.nu/features/scripting-enabled".equals(name)) {
            this.setScriptingEnabled(value);
        } else {
            throw new SAXNotRecognizedException();
        }
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            throw new SAXNotSupportedException("This parser does not suppert DeclHandler.");
        }
        if ("http://xml.org/sax/properties/document-xml-version".equals(name)) {
            throw new SAXNotSupportedException("Can't set document-xml-version.");
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            throw new SAXNotSupportedException("Can't set dom-node.");
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        } else {
            if ("http://xml.org/sax/properties/xml-string".equals(name)) {
                throw new SAXNotSupportedException("Can't set xml-string.");
            }
            if ("http://validator.nu/properties/content-space-policy".equals(name)) {
                this.setContentSpacePolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/content-non-xml-char-policy".equals(name)) {
                this.setContentNonXmlCharPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/comment-policy".equals(name)) {
                this.setCommentPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/xmlns-policy".equals(name)) {
                this.setXmlnsPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/name-policy".equals(name)) {
                this.setNamePolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/streamability-violation-policy".equals(name)) {
                this.setStreamabilityViolationPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/document-mode-handler".equals(name)) {
                this.setDocumentModeHandler((DocumentModeHandler)value);
            } else if ("http://validator.nu/properties/doctype-expectation".equals(name)) {
                this.setDoctypeExpectation((DoctypeExpectation)((Object)value));
            } else if ("http://validator.nu/properties/xml-policy".equals(name)) {
                this.setXmlPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/heuristics".equals(name)) {
                this.setHeuristics((Heuristics)((Object)value));
            } else {
                throw new SAXNotRecognizedException();
            }
        }
    }

    public boolean isCheckingNormalization() {
        return this.checkingNormalization;
    }

    public void setCheckingNormalization(boolean enable) {
        this.checkingNormalization = enable;
        if (this.driver != null) {
            this.driver.setCheckingNormalization(this.checkingNormalization);
        }
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.commentPolicy = commentPolicy;
        if (this.driver != null) {
            this.driver.setCommentPolicy(commentPolicy);
        }
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.contentNonXmlCharPolicy = contentNonXmlCharPolicy;
        this.driver = null;
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.contentSpacePolicy = contentSpacePolicy;
        if (this.driver != null) {
            this.driver.setContentSpacePolicy(contentSpacePolicy);
        }
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
        if (this.treeBuilder != null) {
            this.treeBuilder.setScriptingEnabled(scriptingEnabled);
        }
    }

    public DoctypeExpectation getDoctypeExpectation() {
        return this.doctypeExpectation;
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.doctypeExpectation = doctypeExpectation;
        if (this.treeBuilder != null) {
            this.treeBuilder.setDoctypeExpectation(doctypeExpectation);
        }
    }

    public DocumentModeHandler getDocumentModeHandler() {
        return this.documentModeHandler;
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.documentModeHandler = documentModeHandler;
    }

    public XmlViolationPolicy getStreamabilityViolationPolicy() {
        return this.streamabilityViolationPolicy;
    }

    public void setStreamabilityViolationPolicy(XmlViolationPolicy streamabilityViolationPolicy) {
        this.streamabilityViolationPolicy = streamabilityViolationPolicy;
        this.driver = null;
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.html4ModeCompatibleWithXhtml1Schemata = html4ModeCompatibleWithXhtml1Schemata;
        if (this.driver != null) {
            this.driver.setHtml4ModeCompatibleWithXhtml1Schemata(html4ModeCompatibleWithXhtml1Schemata);
        }
    }

    public Locator getDocumentLocator() {
        return this.driver.getDocumentLocator();
    }

    public boolean isHtml4ModeCompatibleWithXhtml1Schemata() {
        return this.html4ModeCompatibleWithXhtml1Schemata;
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.mappingLangToXmlLang = mappingLangToXmlLang;
        if (this.driver != null) {
            this.driver.setMappingLangToXmlLang(mappingLangToXmlLang);
        }
    }

    public boolean isMappingLangToXmlLang() {
        return this.mappingLangToXmlLang;
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        if (xmlnsPolicy == XmlViolationPolicy.FATAL) {
            throw new IllegalArgumentException("Can't use FATAL here.");
        }
        this.xmlnsPolicy = xmlnsPolicy;
        if (this.driver != null) {
            this.driver.setXmlnsPolicy(xmlnsPolicy);
        }
    }

    public XmlViolationPolicy getXmlnsPolicy() {
        return this.xmlnsPolicy;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public XmlViolationPolicy getCommentPolicy() {
        return this.commentPolicy;
    }

    public XmlViolationPolicy getContentNonXmlCharPolicy() {
        return this.contentNonXmlCharPolicy;
    }

    public XmlViolationPolicy getContentSpacePolicy() {
        return this.contentSpacePolicy;
    }

    public void setReportingDoctype(boolean reportingDoctype) {
        this.reportingDoctype = reportingDoctype;
        if (this.treeBuilder != null) {
            this.treeBuilder.setReportingDoctype(reportingDoctype);
        }
    }

    public boolean isReportingDoctype() {
        return this.reportingDoctype;
    }

    public void setErrorProfile(HashMap<String, String> errorProfileMap) {
        this.errorProfileMap = errorProfileMap;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
        if (this.driver != null) {
            this.driver.setNamePolicy(namePolicy);
            this.treeBuilder.setNamePolicy(namePolicy);
        }
    }

    public void setHeuristics(Heuristics heuristics) {
        this.heuristics = heuristics;
        if (this.driver != null) {
            this.driver.setHeuristics(heuristics);
        }
    }

    public Heuristics getHeuristics() {
        return this.heuristics;
    }

    public void setXmlPolicy(XmlViolationPolicy xmlPolicy) {
        this.setNamePolicy(xmlPolicy);
        this.setXmlnsPolicy(xmlPolicy == XmlViolationPolicy.FATAL ? XmlViolationPolicy.ALTER_INFOSET : xmlPolicy);
        this.setContentSpacePolicy(xmlPolicy);
        this.setContentNonXmlCharPolicy(xmlPolicy);
        this.setCommentPolicy(xmlPolicy);
    }

    public XmlViolationPolicy getNamePolicy() {
        return this.namePolicy;
    }

    public void setBogusXmlnsPolicy(XmlViolationPolicy bogusXmlnsPolicy) {
    }

    public XmlViolationPolicy getBogusXmlnsPolicy() {
        return XmlViolationPolicy.ALTER_INFOSET;
    }

    public void addCharacterHandler(CharacterHandler characterHandler) {
        this.characterHandlers.add(characterHandler);
        if (this.driver != null) {
            this.driver.addCharacterHandler(characterHandler);
        }
    }
}

