/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import org.openide.util.Parameters;

public class DockerName {
    private final String registry;
    private final String namespace;
    private final String repository;
    private final String tag;

    private DockerName(String registry, String namespace, String repository, String tag) {
        this.registry = registry;
        this.namespace = namespace;
        this.repository = repository;
        this.tag = tag;
    }

    public static DockerName parse(String name) {
        Parameters.notNull((CharSequence)"repository", (Object)name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name can't be empty");
        }
        String[] parts = name.split("/", 3);
        String registry = null;
        String ns = null;
        String repo = null;
        String tag = null;
        if (parts.length == 1) {
            repo = parts[0];
        } else if (parts.length == 2) {
            String namespace = parts[0];
            if (namespace.contains(".") || namespace.contains(":") || "localhost".equals(namespace)) {
                registry = namespace;
            } else {
                ns = namespace;
            }
            repo = parts[1];
        } else if (parts.length == 3) {
            registry = parts[0];
            ns = parts[1];
            repo = parts[2];
        }
        int index = repo.indexOf(58);
        if (index > 0) {
            tag = repo.substring(index + 1);
            repo = repo.substring(0, index);
        }
        return new DockerName(registry, ns, repo, tag);
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }
}

