/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateNetworkSourceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateNetworkSourceRequest
extends BmcRequest<UpdateNetworkSourceDetails> {
    private String networkSourceId;
    private UpdateNetworkSourceDetails updateNetworkSourceDetails;
    private String ifMatch;

    public String getNetworkSourceId() {
        return this.networkSourceId;
    }

    public UpdateNetworkSourceDetails getUpdateNetworkSourceDetails() {
        return this.updateNetworkSourceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateNetworkSourceDetails getBody$() {
        return this.updateNetworkSourceDetails;
    }

    public Builder toBuilder() {
        return new Builder().networkSourceId(this.networkSourceId).updateNetworkSourceDetails(this.updateNetworkSourceDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkSourceId=").append(String.valueOf(this.networkSourceId));
        sb.append(",updateNetworkSourceDetails=").append(String.valueOf((Object)this.updateNetworkSourceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateNetworkSourceRequest)) {
            return false;
        }
        UpdateNetworkSourceRequest other = (UpdateNetworkSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkSourceId, other.networkSourceId) && Objects.equals((Object)this.updateNetworkSourceDetails, (Object)other.updateNetworkSourceDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkSourceId == null ? 43 : this.networkSourceId.hashCode());
        result = result * 59 + (this.updateNetworkSourceDetails == null ? 43 : this.updateNetworkSourceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateNetworkSourceRequest, UpdateNetworkSourceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkSourceId = null;
        private UpdateNetworkSourceDetails updateNetworkSourceDetails = null;
        private String ifMatch = null;

        public Builder networkSourceId(String networkSourceId) {
            this.networkSourceId = networkSourceId;
            return this;
        }

        public Builder updateNetworkSourceDetails(UpdateNetworkSourceDetails updateNetworkSourceDetails) {
            this.updateNetworkSourceDetails = updateNetworkSourceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateNetworkSourceRequest o) {
            this.networkSourceId(o.getNetworkSourceId());
            this.updateNetworkSourceDetails(o.getUpdateNetworkSourceDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateNetworkSourceRequest build() {
            UpdateNetworkSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateNetworkSourceDetails body) {
            this.updateNetworkSourceDetails(body);
            return this;
        }

        public UpdateNetworkSourceRequest buildWithoutInvocationCallback() {
            UpdateNetworkSourceRequest request = new UpdateNetworkSourceRequest();
            request.networkSourceId = this.networkSourceId;
            request.updateNetworkSourceDetails = this.updateNetworkSourceDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

