/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.BulkDeleteResourcesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkDeleteResourcesRequest
extends BmcRequest<BulkDeleteResourcesDetails> {
    private String compartmentId;
    private BulkDeleteResourcesDetails bulkDeleteResourcesDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public BulkDeleteResourcesDetails getBulkDeleteResourcesDetails() {
        return this.bulkDeleteResourcesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public BulkDeleteResourcesDetails getBody$() {
        return this.bulkDeleteResourcesDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).bulkDeleteResourcesDetails(this.bulkDeleteResourcesDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",bulkDeleteResourcesDetails=").append(String.valueOf((Object)this.bulkDeleteResourcesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkDeleteResourcesRequest)) {
            return false;
        }
        BulkDeleteResourcesRequest other = (BulkDeleteResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.bulkDeleteResourcesDetails, (Object)other.bulkDeleteResourcesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.bulkDeleteResourcesDetails == null ? 43 : this.bulkDeleteResourcesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkDeleteResourcesRequest, BulkDeleteResourcesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private BulkDeleteResourcesDetails bulkDeleteResourcesDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder bulkDeleteResourcesDetails(BulkDeleteResourcesDetails bulkDeleteResourcesDetails) {
            this.bulkDeleteResourcesDetails = bulkDeleteResourcesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkDeleteResourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.bulkDeleteResourcesDetails(o.getBulkDeleteResourcesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkDeleteResourcesRequest build() {
            BulkDeleteResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkDeleteResourcesDetails body) {
            this.bulkDeleteResourcesDetails(body);
            return this;
        }

        public BulkDeleteResourcesRequest buildWithoutInvocationCallback() {
            BulkDeleteResourcesRequest request = new BulkDeleteResourcesRequest();
            request.compartmentId = this.compartmentId;
            request.bulkDeleteResourcesDetails = this.bulkDeleteResourcesDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

