/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Action;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.TestsuiteNodeChildren;
import org.netbeans.modules.gsf.testrunner.ui.api.Bundle;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class TestsuiteNode
extends AbstractNode {
    static final int MAX_TOOLTIP_LINES = Integer.getInteger("testrunner.max.tooltip.lines", 4);
    private static final int MAX_TOOLTIP_LINE_LENGTH = Integer.getInteger("testrunner.max.tooltip.line.length", 80);
    static final boolean DISPLAY_TOOLTIPS = Boolean.parseBoolean(System.getProperty("testrunner.display.tooltips", "true"));
    static final int MAX_MSG_LINE_LENGTH = Integer.getInteger("testrunner.max.msg.line.length", 250);
    protected String suiteName;
    protected TestSuite suite;
    protected Report report;
    protected int filterMask = 0;
    private TestsuiteNodeChildren children;

    public TestsuiteNode(String suiteName, boolean filtered) {
        this(null, suiteName, filtered, null);
    }

    public TestsuiteNode(Report report, boolean filtered) {
        this(report, null, filtered, null);
    }

    protected TestsuiteNode(Report report, String suiteName, boolean filtered, Lookup lookup) {
        super(Children.LEAF, lookup);
        this.report = report;
        String string = report != null ? report.getSuiteClassName() : (this.suiteName = suiteName != null ? suiteName : TestSuite.ANONYMOUS_SUITE);
        assert (this.suiteName != null);
        this.setDisplayName();
        this.children = null;
    }

    public void notifyTestSuiteFinished() {
        this.fireIconChange();
        this.setDisplayName();
        this.getTestsuiteNodeChildren().notifyTestSuiteFinished();
    }

    private TestsuiteNodeChildren getTestsuiteNodeChildren() {
        if (this.children == null) {
            this.children = new TestsuiteNodeChildren(this.report, this.filterMask);
            this.setChildren(Children.create((ChildFactory)this.children, (boolean)true));
        }
        return this.children;
    }

    static String toTooltipText(List<OutputLine> lines) {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        if (lines.isEmpty()) {
            result.append("<i>" + Bundle.MSG_NoOutput() + "</i>");
        } else {
            for (int i = 0; i < lines.size(); ++i) {
                if (i >= MAX_TOOLTIP_LINES) {
                    result.append("<br><i>" + Bundle.MSG_MoreOutput() + "</i>");
                    break;
                }
                String line = lines.get(i).getLine();
                line = TestsuiteNode.cutLine(line, MAX_TOOLTIP_LINE_LENGTH, true);
                result.append(line);
                if (i >= lines.size()) continue;
                result.append("<br>");
            }
        }
        result.append("</html>");
        return result.toString();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Image getIcon(int type) {
        if (this.report != null) {
            Status status = this.report.getStatus();
            if (!this.report.isCompleted()) {
                switch (status) {
                    case FAILED: 
                    case ERROR: {
                        return ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/run.gif"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error-badge.gif"), (int)8, (int)8);
                    }
                }
            } else {
                switch (status) {
                    case PASSED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_16.png");
                    }
                    case PASSEDWITHERRORS: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_withErrors_16.png");
                    }
                    case FAILED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning_16.png");
                    }
                    case ERROR: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error_16.png");
                    }
                    case ABORTED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/aborted.png");
                    }
                    case SKIPPED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/skipped_16.png");
                    }
                }
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning2_16.png");
            }
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/run.gif");
    }

    public void displayReport(Report report) {
        assert (report != null);
        assert (report.getSuiteClassName().equals(this.suiteName) || TestSuite.ANONYMOUS_SUITE.equals(this.suiteName));
        this.report = report;
        this.suiteName = report.getSuiteClassName();
        this.setDisplayName();
        this.getTestsuiteNodeChildren().setReport(report);
        if (DISPLAY_TOOLTIPS) {
            this.setShortDescription(TestsuiteNode.toTooltipText(this.getOutput()));
        }
        this.fireIconChange();
    }

    public Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        String displayName;
        if (this.report == null) {
            displayName = !this.suiteName.equals(TestSuite.ANONYMOUS_SUITE) ? Bundle.MSG_TestsuiteRunning(this.suiteName) : Bundle.MSG_TestsuiteRunningNoname();
        } else if (this.report.getAborted() > 0) {
            displayName = Bundle.MSG_TestsuiteAborted(this.suiteName);
        } else if (this.report.getSkipped() > 0) {
            displayName = Bundle.MSG_TestsuiteSkipped(this.suiteName);
        } else if (!this.report.isCompleted()) {
            boolean containsFailed = this.containsFailed();
            displayName = containsFailed ? Bundle.MSG_TestsuiteFailed(this.suiteName) : this.suiteName;
            displayName = Bundle.MSG_TestsuiteRunning(displayName);
        } else {
            boolean containsFailed = this.containsFailed();
            displayName = containsFailed ? Bundle.MSG_TestsuiteFailed(this.suiteName) : this.suiteName;
        }
        this.setDisplayName(displayName);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuilder buf = new StringBuilder(60);
        if (!TestSuite.ANONYMOUS_SUITE.equals(this.suiteName)) {
            buf.append(this.suiteName);
        } else {
            buf.append(Bundle.MSG_TestsuiteNoname());
        }
        if (this.report != null) {
            Status status = this.report.getStatus();
            buf.append("&nbsp;&nbsp;");
            buf.append("<font color='#");
            buf.append(status.getHtmlDisplayColor()).append("'>");
            buf.append(TestsuiteNode.suiteStatusToMsg(status, true));
            buf.append("</font>");
        }
        if (this.report == null || !this.report.isCompleted()) {
            buf.append("&nbsp;&nbsp;");
            buf.append(Bundle.MSG_TestsuiteRunning_HTML());
        }
        return buf.toString();
    }

    static String suiteStatusToMsg(Status status, boolean html) {
        String result = Status.ABORTED == status ? (html ? Bundle.MSG_TestsuiteAborted_HTML() : Bundle.MSG_TestsuiteAborted("")) : (Status.ERROR == status || Status.FAILED == status ? (html ? Bundle.MSG_TestsuiteFailed_HTML() : Bundle.MSG_TestsuiteFailed("")) : (Status.PENDING == status ? (html ? Bundle.MSG_TestsuitePending_HTML() : Bundle.MSG_TestsuitePending("")) : (Status.SKIPPED == status ? (html ? Bundle.MSG_TestsuiteSkipped_HTML() : Bundle.MSG_TestsuiteSkipped("")) : (Status.PASSEDWITHERRORS == status ? (html ? Bundle.MSG_TestsuitePassedWithErrors_HTML() : Bundle.MSG_TestsuitePassedWithErrors("")) : (html ? Bundle.MSG_TestsuitePassed_HTML() : Bundle.MSG_TestsuitePassed(""))))));
        return result;
    }

    public void setSuite(TestSuite suite) {
        this.suite = suite;
    }

    public TestSuite getSuite() {
        return this.suite;
    }

    public void setFilterMask(int filterMask) {
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        this.getTestsuiteNodeChildren().setFilterMask(filterMask);
    }

    private boolean containsFailed() {
        return this.report != null && this.report.getFailures() + this.report.getErrors() != 0;
    }

    public Action getPreferredAction() {
        return null;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    private List<OutputLine> getOutput() {
        ArrayList<OutputLine> result = new ArrayList<OutputLine>();
        for (Testcase testcase : this.report.getTests()) {
            result.addAll(testcase.getOutput());
        }
        return result;
    }

    public static String cutLine(String line, int maxLength, boolean isHTML) throws MissingResourceException {
        String cutMsg;
        int tailLength;
        int length = line.length();
        if (length > maxLength && (tailLength = length - maxLength) > (cutMsg = Bundle.MSG_CharsOmitted(tailLength)).length()) {
            line = line.substring(0, maxLength);
            String startMsg = isHTML ? "<i> " : "";
            String endMsg = isHTML ? "</i>" : "";
            line = line.concat(startMsg + cutMsg + endMsg);
        }
        return line;
    }
}

