/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.nbimpl.javac.JavacClassInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ParsingUtils;
import org.netbeans.modules.profiler.nbimpl.javac.ScanSensitiveTask;

public class JavacPackageInfo
extends SourcePackageInfo {
    private static final Logger LOGGER = Logger.getLogger(JavacPackageInfo.class.getName());
    private ClasspathInfo cpInfo;
    private ClasspathInfo indexInfo;
    private Set<ClassIndex.SearchScope> sScope;

    public JavacPackageInfo(ClasspathInfo cpInfo, ClasspathInfo indexInfo, String simpleName, String fqn, SourcePackageInfo.Scope scope) {
        super(simpleName, fqn, scope);
        this.cpInfo = cpInfo;
        this.indexInfo = indexInfo;
        switch (scope) {
            case SOURCE: {
                this.sScope = EnumSet.of(ClassIndex.SearchScope.SOURCE);
                break;
            }
            case DEPENDENCIES: {
                this.sScope = EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES);
                break;
            }
            default: {
                this.sScope = Collections.EMPTY_SET;
            }
        }
    }

    public Collection<SourceClassInfo> getClasses() {
        final ArrayList<SourceClassInfo> clzs = new ArrayList<SourceClassInfo>();
        ParsingUtils.invokeScanSensitiveTask(this.cpInfo, new ScanSensitiveTask<CompilationController>(this){
            final /* synthetic */ JavacPackageInfo this$0;
            {
                this.this$0 = this$0;
            }

            public void run(CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.PARSED);
                PackageElement pelem = cc.getElements().getPackageElement(this.this$0.getSimpleName());
                if (pelem != null) {
                    for (TypeElement type : ElementFilter.typesIn(pelem.getEnclosedElements())) {
                        if (type.getKind() != ElementKind.CLASS && type.getKind() != ElementKind.ENUM) continue;
                        clzs.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)type), this.this$0.indexInfo));
                    }
                } else {
                    LOGGER.log(Level.FINEST, "Package name {0} resulted into a NULL element", this.this$0.getBinaryName());
                }
            }
        });
        return clzs;
    }

    public Collection<SourcePackageInfo> getSubpackages() {
        final ClassIndex index = this.cpInfo.getClassIndex();
        final ArrayList<SourcePackageInfo> pkgs = new ArrayList<SourcePackageInfo>();
        ParsingUtils.invokeScanSensitiveTask(this.cpInfo, new ScanSensitiveTask<CompilationController>(this, true){
            final /* synthetic */ JavacPackageInfo this$0;
            {
                this.this$0 = this$0;
                super(uptodate);
            }

            public void run(CompilationController cc) {
                for (String pkgName : index.getPackageNames(this.this$0.getBinaryName() + ".", true, this.this$0.sScope)) {
                    pkgs.add(new JavacPackageInfo(this.this$0.cpInfo, this.this$0.indexInfo, pkgName, pkgName, this.this$0.getScope()));
                }
            }
        });
        return pkgs;
    }
}

