/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.AssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.Checker;
import org.netbeans.modules.web.beans.impl.model.DelegateAssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.EventAssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

abstract class AbstractAssignabilityChecker
implements Checker {
    private Element myOriginalElement;
    private ReferenceType myVarType;
    private WebBeansModelImplementation myImpl;
    private ReferenceType myType;

    AbstractAssignabilityChecker() {
    }

    static AbstractAssignabilityChecker get(AssignabilityType type) {
        switch (type.ordinal()) {
            case 0: {
                return new AssignabilityChecker();
            }
            case 1: {
                return new EventAssignabilityChecker();
            }
            case 2: {
                return new DelegateAssignabilityChecker();
            }
        }
        assert (false);
        return null;
    }

    void init(ReferenceType varType, ReferenceType checkedType, Element originalElement, WebBeansModelImplementation impl) {
        this.myVarType = varType;
        this.myType = checkedType;
        this.myImpl = impl;
        this.myOriginalElement = originalElement;
    }

    void init(ReferenceType varType, ReferenceType checkedType, WebBeansModelImplementation impl) {
        this.init(varType, checkedType, null, impl);
    }

    @Override
    public boolean check() {
        boolean check = this.checkAssignability(this.getVarType(), this.getType(), this.myOriginalElement);
        return check;
    }

    public boolean checkAssignability(ReferenceType variableType, ReferenceType refType, Element originalElement) {
        boolean isDeclaredType;
        boolean bl = isDeclaredType = variableType instanceof DeclaredType && variableType.getKind() != TypeKind.ERROR;
        if (!isDeclaredType) {
            return this.checkParameter(refType, variableType);
        }
        Element variableElement = ((DeclaredType)variableType).asElement();
        if (!(variableElement instanceof TypeElement)) {
            return false;
        }
        if (!(refType instanceof DeclaredType) || refType.getKind() == TypeKind.ERROR) {
            return false;
        }
        DeclaredType type = (DeclaredType)refType;
        Element refElement = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(type);
        if (!(refElement instanceof TypeElement)) {
            return false;
        }
        if (!this.hasBeanType(originalElement, variableType)) {
            return false;
        }
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        if (!types.isSameType(types.erasure(variableType), types.erasure(type))) {
            TypeMirror ancestor = this.getAncestor(type, types.erasure(variableType), types);
            if (!(ancestor instanceof DeclaredType)) {
                return false;
            }
            type = (DeclaredType)ancestor;
        }
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        TypeElement objectElement = this.getImplementation().getHelper().getCompilationController().getElements().getTypeElement(Object.class.getCanonicalName());
        List<? extends TypeMirror> varTypeArguments = ((DeclaredType)variableType).getTypeArguments();
        if (varTypeArguments.size() == 0 || types.isSameType(variableType, types.erasure(variableType))) {
            return this.handleRequiredRawType(types, typeArguments, objectElement);
        }
        if (typeArguments.size() == 0 || types.isSameType(type, types.erasure(type))) {
            return this.handleBeanRawType(types, varTypeArguments, objectElement);
        }
        if (varTypeArguments.size() != typeArguments.size()) {
            return false;
        }
        for (int i = 0; i < varTypeArguments.size(); ++i) {
            TypeMirror argType = typeArguments.get(i);
            if (this.checkParameter(argType, varTypeArguments.get(i))) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean handleBeanRawType(Types var1, List<? extends TypeMirror> var2, TypeElement var3);

    protected abstract boolean hasBeanType(Element var1, ReferenceType var2);

    protected abstract boolean handleRequiredRawType(Types var1, List<? extends TypeMirror> var2, TypeElement var3);

    public boolean checkAssignability(ReferenceType variableType, ReferenceType refType) {
        return this.checkAssignability(variableType, refType, null);
    }

    protected boolean checkParameter(TypeMirror argType, TypeMirror varTypeArg) {
        if (argType == null || varTypeArg == null) {
            return false;
        }
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        if (argType.getKind() != TypeKind.TYPEVAR && varTypeArg.getKind() != TypeKind.TYPEVAR && argType instanceof ReferenceType && varTypeArg instanceof ReferenceType) {
            return this.checkIsAssignable(this.getImplementation().getHelper().getCompilationController().getTypes(), argType, varTypeArg);
        }
        if (varTypeArg.getKind() == TypeKind.WILDCARD) {
            return this.handleWildCard(argType, (WildcardType)varTypeArg, types);
        }
        if (argType.getKind() == TypeKind.TYPEVAR && varTypeArg.getKind() == TypeKind.TYPEVAR) {
            return this.handleBothTypeVars(argType, varTypeArg, types);
        }
        if (varTypeArg.getKind() != TypeKind.TYPEVAR && argType.getKind() == TypeKind.TYPEVAR) {
            return this.handleBeanTypeVar(argType, varTypeArg, types);
        }
        if (argType.getKind() != TypeKind.TYPEVAR && varTypeArg.getKind() == TypeKind.TYPEVAR) {
            return this.handleRequiredTypeVar(argType, varTypeArg, types);
        }
        return false;
    }

    protected abstract boolean handleRequiredTypeVar(TypeMirror var1, TypeMirror var2, Types var3);

    protected abstract boolean handleBeanTypeVar(TypeMirror var1, TypeMirror var2, Types var3);

    protected abstract boolean handleBothTypeVars(TypeMirror var1, TypeMirror var2, Types var3);

    protected boolean handleWildCard(TypeMirror argType, WildcardType varTypeArg, Types types) {
        TypeMirror upperBound = varTypeArg.getExtendsBound();
        TypeMirror lowerBound = varTypeArg.getSuperBound();
        if (argType instanceof ReferenceType && argType.getKind() != TypeKind.TYPEVAR) {
            return this.handleWildCardActualType(argType, types, upperBound, lowerBound);
        }
        if (argType.getKind() == TypeKind.TYPEVAR) {
            return this.handleWildCardTypeVar(argType, types, upperBound, lowerBound);
        }
        return false;
    }

    protected boolean handleWildCardActualType(TypeMirror argType, Types types, TypeMirror upperBound, TypeMirror lowerBound) {
        if (upperBound == null || upperBound.getKind() == TypeKind.NULL) {
            if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
                return true;
            }
            return this.checkIsAssignable(types, lowerBound, argType);
        }
        if (lowerBound == null || lowerBound.getKind() == TypeKind.NULL) {
            return this.checkIsAssignable(types, argType, upperBound);
        }
        return this.checkIsAssignable(types, argType, upperBound) && this.checkIsAssignable(types, lowerBound, argType);
    }

    protected abstract boolean handleWildCardTypeVar(TypeMirror var1, Types var2, TypeMirror var3, TypeMirror var4);

    protected boolean checkIsAssignable(Types types, TypeMirror from, TypeMirror to) {
        if (this.isAssignable(from, to, types)) {
            return true;
        }
        if (to instanceof ReferenceType && from instanceof ReferenceType) {
            return this.checkAssignability((ReferenceType)to, (ReferenceType)from);
        }
        return false;
    }

    protected boolean isAssignable(TypeMirror from, TypeMirror to, Types types) {
        Element element = types.asElement(to);
        boolean isGeneric = element instanceof TypeElement && ((TypeElement)element).getTypeParameters().size() != 0;
        return !isGeneric && to instanceof DeclaredType;
    }

    private TypeMirror getAncestor(TypeMirror subject, TypeMirror rawType, Types types) {
        List<? extends TypeMirror> directSupertypes = types.directSupertypes(subject);
        for (TypeMirror typeMirror : directSupertypes) {
            if (types.isSameType(types.erasure(typeMirror), rawType)) {
                return typeMirror;
            }
            TypeMirror found = this.getAncestor(typeMirror, rawType, types);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected ReferenceType getVarType() {
        return this.myVarType;
    }

    protected WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    protected ReferenceType getType() {
        return this.myType;
    }

    static enum AssignabilityType {
        PLAIN,
        EVENT,
        DECORATOR;

    }
}

