/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.installer.util;

import java.io.File;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.netbeans.modules.versioning.system.cvss.installer.CvsInstaller;

public class Utils {
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "CVS(\\" + File.separatorChar + ".*|$)");

    private Utils() {
    }

    public static boolean isPartOfCVSMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static boolean containsMetadata(File folder) {
        boolean ret;
        CvsInstaller.LOG.log(Level.FINER, " containsMetadata {0}", new Object[]{folder});
        long t = System.currentTimeMillis();
        File repository = new File(folder, "CVS/Repository");
        File entries = new File(folder, "CVS/Entries");
        boolean bl = ret = repository.exists() && entries.exists();
        if (CvsInstaller.LOG.isLoggable(Level.FINER)) {
            CvsInstaller.LOG.log(Level.FINER, " containsMetadata returns {0} after {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
        }
        return ret;
    }
}

