/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.modules.project.ui.actions.ShortcutManager;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class ProjectAction
extends LookupSensitiveAction
implements ContextAwareAction {
    private String command;
    private ProjectActionPerformer performer;
    private final String namePattern;
    private final String popupPattern;

    public ProjectAction(String command, String namePattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, namePattern, icon, lookup);
    }

    public ProjectAction(String command, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, popupPattern, icon, lookup);
    }

    public ProjectAction(ProjectActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, namePattern, icon, lookup);
    }

    private ProjectAction(ProjectActionPerformer performer, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, popupPattern, icon, lookup);
    }

    private ProjectAction(String command, ProjectActionPerformer performer, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = command;
        if (command != null) {
            ShortcutManager.INSTANCE.registerAction(command, this);
        }
        this.performer = performer;
        this.namePattern = namePattern;
        this.popupPattern = popupPattern;
        String presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
    }

    @Override
    public final void putValue(String key, Object value) {
        super.putValue(key, value);
        if ("AcceleratorKey".equals(key)) {
            ShortcutManager.INSTANCE.registerShortcut(this.command, value);
        }
    }

    @Override
    protected void actionPerformed(final Lookup context) {
        Runnable r = new Runnable(){
            final /* synthetic */ ProjectAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.this$0.command);
                Runnable r2 = new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (this.this$1.this$0.command != null && projects.length > 0) {
                            ProjectAction.runSequentially(new LinkedList<Project>(Arrays.asList(projects)), this.this$1.this$0, this.this$1.this$0.command);
                        } else if (this.this$1.this$0.performer != null && projects.length == 1) {
                            this.this$1.this$0.performer.perform(projects[0]);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r2.run();
                } else {
                    SwingUtilities.invokeLater(r2);
                }
            }
        };
        if (Boolean.getBoolean("sync.project.execution")) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    static void runSequentially(final Queue<Project> queue, final LookupSensitiveAction a, final String command) {
        Project p = queue.remove();
        final ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return;
        }
        if (!Arrays.asList(ap.getSupportedActions()).contains(command)) {
            Utilities.disabledActionBeep();
            a.resultChanged(null);
            return;
        }
        LogRecord r = new LogRecord(Level.FINE, "PROJECT_ACTION");
        r.setResourceBundle(NbBundle.getBundle(ProjectAction.class));
        r.setParameters(new Object[]{a.getClass().getName(), p.getClass().getName(), a.getValue("Name")});
        r.setLoggerName(UILOG.getName());
        UILOG.log(r);
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                final AtomicBoolean started = new AtomicBoolean();
                ap.invokeAction(command, Lookups.singleton((Object)new ActionProgress(this){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    protected void started() {
                        started.set(true);
                    }

                    public void finished(boolean success) {
                        if (success && !queue.isEmpty()) {
                            ProjectAction.runSequentially(queue, a, command);
                        } else {
                            a.resultChanged(null);
                        }
                    }
                }));
                if (started.get()) {
                    a.setEnabled(false);
                } else if (!queue.isEmpty()) {
                    ProjectAction.runSequentially(queue, a, command);
                }
            }
        });
    }

    @Override
    protected void refresh(final Lookup context, boolean immediate) {
        Runnable r = new Runnable(){
            final /* synthetic */ ProjectAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.this$0.command);
                final boolean enable = this.this$0.command != null ? projects.length > 0 : (this.this$0.performer != null && projects.length == 1 ? this.this$0.performer.enable(projects[0]) : false);
                final String presenterName = ActionsUtil.formatProjectSensitiveName(this.this$0.namePattern, projects);
                final String popupName = this.this$0.popupPattern != null ? ActionsUtil.formatProjectSensitiveName(this.this$0.popupPattern, projects) : null;
                Mutex.EVENT.writeAccess(new Runnable(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.setEnabled(enable);
                        this.this$1.this$0.putValue("menuText", presenterName);
                        this.this$1.this$0.putValue("popupText", popupName);
                        this.this$1.this$0.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
                    }
                });
            }
        };
        if (immediate) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        ProjectAction a = new ProjectAction(this.command, this.performer, this.namePattern, this.popupPattern, (Icon)this.getValue("SmallIcon"), actionContext);
        a.putValue("hideWhenDisabled", this.getValue("hideWhenDisabled"));
        return a;
    }
}

