/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.ui.ScreenshotComponent;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ComponentHierarchy
extends JPanel
implements NavigatorPanel,
ExplorerManager.Provider {
    private static final Logger logger = Logger.getLogger(ComponentHierarchy.class.getName());
    private static ComponentHierarchy CH;
    private TreeView treeView;
    private Lookup lookup;
    private ExplorerManager explorerManager;

    public ComponentHierarchy() {
        this.createComponents();
    }

    private void createComponents() {
        this.explorerManager = new ExplorerManager();
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap());
        this.setLayout(new BorderLayout());
        this.treeView = new BeanTreeView();
        this.add((Component)this.treeView, "Center");
    }

    public static synchronized ComponentHierarchy getInstance() {
        if (CH == null) {
            CH = new ComponentHierarchy();
        }
        return CH;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ComponentHierarchy.class, (String)"CTL_ComponentHierarchy");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(ComponentHierarchy.class, (String)"HINT_ComponentHierarchy");
    }

    public JComponent getComponent() {
        return this;
    }

    public void panelActivated(Lookup context) {
        ComponentInfo ci = (ComponentInfo)context.lookup(ComponentInfo.class);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("panelActivated(" + context + ") ci = " + ci + ", tc = " + context.lookup(ScreenshotComponent.class));
            if (ci != null) {
                logger.fine("  ci name = " + ci.getDisplayName());
            }
        }
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
    }

    public void panelDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }
}

