/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.diff.ExportAsFilePanel;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffPanel;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class ExportDiff
extends ExportDiffSupport {
    private ExportDiffPanel panel;
    private File fileToDiff;
    private ExportDiffSupport.AbstractExportDiffPanel aedp;
    private DocumentListener listener;
    private DialogDescriptor dd;

    public ExportDiff(File repository, HgLogMessage repoRev, File[] roots, File fileToDiff) {
        File[] fileArray;
        if (roots == null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = fileToDiff;
        } else {
            fileArray = roots;
        }
        super(fileArray, HgModuleConfig.getDefault().getPreferences());
        this.fileToDiff = fileToDiff;
        this.panel = new ExportDiffPanel(repository, repoRev, roots, fileToDiff);
    }

    public ExportDiff(File repository, HgLogMessage repoRev, File[] roots) {
        this(repository, repoRev, roots, null);
    }

    public ExportDiff(File repository, File[] roots) {
        this(repository, null, roots, null);
    }

    private void nameChange() {
        if (this.aedp.getOutputFileText().trim().length() > 0) {
            this.dd.setValid(true);
        } else {
            this.dd.setValid(false);
        }
    }

    public String getOutputFileName() {
        if (this.panel == null) {
            return null;
        }
        return this.panel.getOutputFileName().trim();
    }

    public String getSelectionRevision() {
        if (this.panel == null) {
            return null;
        }
        return this.panel.getSelectedRevisionCSetId();
    }

    protected ExportDiffSupport.AbstractExportDiffPanel createSimpleDialog(String currentFilePath) {
        this.aedp = new ExportAsFilePanel();
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportDiff.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportDiff.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportDiff.this.nameChange();
            }
        };
        this.panel.setInsidePanel(this.aedp);
        this.dd = this.fileToDiff != null ? new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportFileDialog")) : new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportDialog"));
        this.aedp.addOutputFileTextDocumentListener(this.listener);
        this.dd.setModal(true);
        this.dd.setHelpCtx(new HelpCtx(((Object)((Object)this)).getClass()));
        this.dd.setValid(false);
        return this.aedp;
    }

    protected void createComplexDialog(ExportDiffSupport.AbstractExportDiffPanel insidePanel) {
        this.panel.setInsidePanel(insidePanel);
        this.dd = this.fileToDiff != null ? new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportFileDialog")) : new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportDiff.class, (String)"CTL_ExportDialog"));
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dd;
    }
}

