/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.CreateDeployStageDetails;
import com.oracle.bmc.devops.model.DeployStagePredecessorCollection;
import com.oracle.bmc.devops.model.OkeBlueGreenStrategy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployStageType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateOkeBlueGreenDeployStageDetails
extends CreateDeployStageDetails {
    @JsonProperty(value="okeClusterDeployEnvironmentId")
    private final String okeClusterDeployEnvironmentId;
    @JsonProperty(value="kubernetesManifestDeployArtifactIds")
    private final List<String> kubernetesManifestDeployArtifactIds;
    @JsonProperty(value="blueGreenStrategy")
    private final OkeBlueGreenStrategy blueGreenStrategy;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateOkeBlueGreenDeployStageDetails(String description, String displayName, String deployPipelineId, DeployStagePredecessorCollection deployStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String okeClusterDeployEnvironmentId, List<String> kubernetesManifestDeployArtifactIds, OkeBlueGreenStrategy blueGreenStrategy) {
        super(description, displayName, deployPipelineId, deployStagePredecessorCollection, freeformTags, definedTags);
        this.okeClusterDeployEnvironmentId = okeClusterDeployEnvironmentId;
        this.kubernetesManifestDeployArtifactIds = kubernetesManifestDeployArtifactIds;
        this.blueGreenStrategy = blueGreenStrategy;
    }

    public String getOkeClusterDeployEnvironmentId() {
        return this.okeClusterDeployEnvironmentId;
    }

    public List<String> getKubernetesManifestDeployArtifactIds() {
        return this.kubernetesManifestDeployArtifactIds;
    }

    public OkeBlueGreenStrategy getBlueGreenStrategy() {
        return this.blueGreenStrategy;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOkeBlueGreenDeployStageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", okeClusterDeployEnvironmentId=").append(String.valueOf(this.okeClusterDeployEnvironmentId));
        sb.append(", kubernetesManifestDeployArtifactIds=").append(String.valueOf(this.kubernetesManifestDeployArtifactIds));
        sb.append(", blueGreenStrategy=").append(String.valueOf((Object)this.blueGreenStrategy));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOkeBlueGreenDeployStageDetails)) {
            return false;
        }
        CreateOkeBlueGreenDeployStageDetails other = (CreateOkeBlueGreenDeployStageDetails)((Object)o);
        return Objects.equals(this.okeClusterDeployEnvironmentId, other.okeClusterDeployEnvironmentId) && Objects.equals(this.kubernetesManifestDeployArtifactIds, other.kubernetesManifestDeployArtifactIds) && Objects.equals((Object)this.blueGreenStrategy, (Object)other.blueGreenStrategy) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.okeClusterDeployEnvironmentId == null ? 43 : this.okeClusterDeployEnvironmentId.hashCode());
        result = result * 59 + (this.kubernetesManifestDeployArtifactIds == null ? 43 : this.kubernetesManifestDeployArtifactIds.hashCode());
        result = result * 59 + (this.blueGreenStrategy == null ? 43 : this.blueGreenStrategy.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="deployPipelineId")
        private String deployPipelineId;
        @JsonProperty(value="deployStagePredecessorCollection")
        private DeployStagePredecessorCollection deployStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="okeClusterDeployEnvironmentId")
        private String okeClusterDeployEnvironmentId;
        @JsonProperty(value="kubernetesManifestDeployArtifactIds")
        private List<String> kubernetesManifestDeployArtifactIds;
        @JsonProperty(value="blueGreenStrategy")
        private OkeBlueGreenStrategy blueGreenStrategy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder deployPipelineId(String deployPipelineId) {
            this.deployPipelineId = deployPipelineId;
            this.__explicitlySet__.add("deployPipelineId");
            return this;
        }

        public Builder deployStagePredecessorCollection(DeployStagePredecessorCollection deployStagePredecessorCollection) {
            this.deployStagePredecessorCollection = deployStagePredecessorCollection;
            this.__explicitlySet__.add("deployStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder okeClusterDeployEnvironmentId(String okeClusterDeployEnvironmentId) {
            this.okeClusterDeployEnvironmentId = okeClusterDeployEnvironmentId;
            this.__explicitlySet__.add("okeClusterDeployEnvironmentId");
            return this;
        }

        public Builder kubernetesManifestDeployArtifactIds(List<String> kubernetesManifestDeployArtifactIds) {
            this.kubernetesManifestDeployArtifactIds = kubernetesManifestDeployArtifactIds;
            this.__explicitlySet__.add("kubernetesManifestDeployArtifactIds");
            return this;
        }

        public Builder blueGreenStrategy(OkeBlueGreenStrategy blueGreenStrategy) {
            this.blueGreenStrategy = blueGreenStrategy;
            this.__explicitlySet__.add("blueGreenStrategy");
            return this;
        }

        public CreateOkeBlueGreenDeployStageDetails build() {
            CreateOkeBlueGreenDeployStageDetails model = new CreateOkeBlueGreenDeployStageDetails(this.description, this.displayName, this.deployPipelineId, this.deployStagePredecessorCollection, this.freeformTags, this.definedTags, this.okeClusterDeployEnvironmentId, this.kubernetesManifestDeployArtifactIds, this.blueGreenStrategy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOkeBlueGreenDeployStageDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("deployPipelineId")) {
                this.deployPipelineId(model.getDeployPipelineId());
            }
            if (model.wasPropertyExplicitlySet("deployStagePredecessorCollection")) {
                this.deployStagePredecessorCollection(model.getDeployStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("okeClusterDeployEnvironmentId")) {
                this.okeClusterDeployEnvironmentId(model.getOkeClusterDeployEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("kubernetesManifestDeployArtifactIds")) {
                this.kubernetesManifestDeployArtifactIds(model.getKubernetesManifestDeployArtifactIds());
            }
            if (model.wasPropertyExplicitlySet("blueGreenStrategy")) {
                this.blueGreenStrategy(model.getBlueGreenStrategy());
            }
            return this;
        }
    }
}

