/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.phrase;

import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.core.parser.util.Matcher;

public class SimpleTextilePhraseModifier
extends PatternBasedElement {
    protected static final int CONTENT_GROUP = 5;
    protected static final int ATTRIBUTES_OFFSET = 1;
    private final String delimiter;
    private final DocumentBuilder.SpanType spanType;
    private final Mode mode;

    public SimpleTextilePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType, Mode mode) {
        this.delimiter = delimiter;
        this.spanType = spanType;
        this.mode = mode;
    }

    protected String getPattern(int groupOffset) {
        String quotedDelimiter = this.quoteLite(this.getDelimiter());
        String firstCharacterOfDelimiter = this.quoteLite(this.getDelimiter().substring(0, 1));
        return String.valueOf(quotedDelimiter) + "(?!" + firstCharacterOfDelimiter + ")" + "(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}" + "([^\\s" + quotedDelimiter + "]+|\\S(?:.*?\\S)?)" + "(?<!" + firstCharacterOfDelimiter + ")" + quotedDelimiter;
    }

    private String quoteLite(String literal) {
        StringBuilder buf = new StringBuilder(literal.length() * 2);
        int x = 0;
        while (x < literal.length()) {
            char c = literal.charAt(x);
            switch (c) {
                case '*': 
                case '+': 
                case '-': 
                case '?': 
                case '^': {
                    buf.append('\\');
                }
            }
            buf.append(c);
            ++x;
        }
        return buf.toString();
    }

    protected int getPatternGroupCount() {
        return 5;
    }

    protected String getDelimiter() {
        return this.delimiter;
    }

    protected static void configureAttributes(PatternBasedElementProcessor processor, Attributes attributes) {
        Textile.configureAttributes((Matcher)processor, attributes, 1, false);
    }

    protected static String getContent(PatternBasedElementProcessor processor) {
        return processor.group(5);
    }

    protected static int getStart(PatternBasedElementProcessor processor) {
        return processor.start(5);
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new SimplePhraseModifierProcessor(this.spanType, this.mode);
    }

    public static enum Mode {
        NORMAL,
        SPECIAL,
        NESTING;

    }

    private static class SimplePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final DocumentBuilder.SpanType spanType;
        private final Mode mode;

        public SimplePhraseModifierProcessor(DocumentBuilder.SpanType spanType, Mode mode) {
            this.spanType = spanType;
            this.mode = mode;
        }

        public void emit() {
            Attributes attributes = new Attributes();
            SimpleTextilePhraseModifier.configureAttributes(this, attributes);
            this.getBuilder().beginSpan(this.spanType, attributes);
            switch (this.mode) {
                case NESTING: {
                    this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, SimpleTextilePhraseModifier.getStart(this), SimpleTextilePhraseModifier.getContent(this), 0);
                    break;
                }
                case NORMAL: {
                    this.getMarkupLanguage().emitMarkupText(this.parser, this.state, SimpleTextilePhraseModifier.getContent(this));
                    break;
                }
                case SPECIAL: {
                    this.getBuilder().characters(SimpleTextilePhraseModifier.getContent(this));
                }
            }
            this.getBuilder().endSpan();
        }
    }
}

