/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.hints.errors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.hints.spi.preview.PreviewEnabler;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

public class EnablePreviewAntProj
implements PreviewEnabler {
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private static final String JAVAC_SOURCE = "javac.source";
    private static final String JAVAC_TARGET = "javac.target";
    private static final String JAVAC_COMPILER_ARGS = "javac.compilerargs";
    private static final String RUN_JVMARGS = "run.jvmargs";
    private final Project prj;

    public EnablePreviewAntProj(Project prj) {
        this.prj = prj;
    }

    public void enablePreview(String newSourceLevel) throws Exception {
        new ResolveAntFix(this.prj).enablePreview(newSourceLevel);
    }

    private static void storeEditableProperties(final Project prj, final String propertiesPath, final EditableProperties ep) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    if (propertiesFo != null) {
                        try (OutputStream os = null;){
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    private static EditableProperties getEditableProperties(final Project prj, final String propertiesPath) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        ep = new EditableProperties(false);
                        try (InputStream is = null;){
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    private static boolean isAntProject(Project prj) {
        if (prj == null) {
            return false;
        }
        FileObject prjDir = prj.getProjectDirectory();
        if (prjDir == null) {
            return false;
        }
        ArrayList<FileObject> antProjectFiles = new ArrayList<FileObject>();
        antProjectFiles.add(prjDir.getFileObject("build.xml"));
        antProjectFiles.add(prjDir.getFileObject("nbproject/project.properties"));
        antProjectFiles.add(prjDir.getFileObject("nbproject/project.xml"));
        boolean isAntProject = true;
        for (FileObject file : antProjectFiles) {
            if (file != null && file.isValid()) continue;
            isAntProject = false;
            break;
        }
        return isAntProject;
    }

    private static final class ResolveAntFix {
        private final Project prj;

        ResolveAntFix(@NonNull Project prj) {
            Parameters.notNull((CharSequence)"prj", (Object)prj);
            this.prj = prj;
        }

        public void enablePreview(String newSourceLevel) throws Exception {
            String runJVMArgs;
            EditableProperties ep = EnablePreviewAntProj.getEditableProperties(this.prj, "nbproject/project.properties");
            String compilerArgs = ep.getProperty(EnablePreviewAntProj.JAVAC_COMPILER_ARGS);
            String string = compilerArgs = compilerArgs != null ? compilerArgs + " " + EnablePreviewAntProj.ENABLE_PREVIEW_FLAG : EnablePreviewAntProj.ENABLE_PREVIEW_FLAG;
            if (newSourceLevel != null) {
                ep.setProperty(EnablePreviewAntProj.JAVAC_SOURCE, newSourceLevel);
                if (ep.getProperty(EnablePreviewAntProj.JAVAC_TARGET) != null) {
                    ep.setProperty(EnablePreviewAntProj.JAVAC_TARGET, newSourceLevel);
                }
            }
            if ((runJVMArgs = ep.getProperty(EnablePreviewAntProj.RUN_JVMARGS)) == null) {
                runJVMArgs = EnablePreviewAntProj.ENABLE_PREVIEW_FLAG;
            } else if (!runJVMArgs.contains(EnablePreviewAntProj.ENABLE_PREVIEW_FLAG)) {
                runJVMArgs = runJVMArgs + " " + EnablePreviewAntProj.ENABLE_PREVIEW_FLAG;
            }
            ep.setProperty(EnablePreviewAntProj.JAVAC_COMPILER_ARGS, compilerArgs);
            ep.setProperty(EnablePreviewAntProj.RUN_JVMARGS, runJVMArgs);
            EnablePreviewAntProj.storeEditableProperties(this.prj, "nbproject/project.properties", ep);
        }
    }

    public static final class FactoryImpl
    implements PreviewEnabler.Factory {
        public PreviewEnabler enablerFor(FileObject file) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            if (EnablePreviewAntProj.isAntProject(prj)) {
                return new EnablePreviewAntProj(prj);
            }
            return null;
        }
    }
}

