/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ExceptionBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.FieldBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;
import org.netbeans.modules.debugger.jpda.breakpoints.SourceRootsCache;
import org.netbeans.modules.debugger.jpda.breakpoints.ThreadBreakpointImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Mutex;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private SourcePath engineContext;
    private SourceRootsCache sourceRootsCache;
    private boolean started = false;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private final Map<JPDABreakpoint, BreakpointImpl> breakpointToImpl = new IdentityHashMap<JPDABreakpoint, BreakpointImpl>();
    private final BreakpointImpl preliminaryBreakpointImpl = new PreliminaryBreakpointImpl();

    public BreakpointsEngineListener(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.engineContext = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.sourceRootsCache = new SourceRootsCache(this.engineContext);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getState() == 2) {
            if (this.started) {
                return;
            }
            this.started = true;
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            this.createBreakpointImpls();
        }
        if (this.debugger.getState() == 4) {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            this.removeBreakpointImpls();
            this.started = false;
        }
    }

    public void actionPerformed(Object action) {
    }

    private boolean acceptBreakpoint(Breakpoint breakpoint) {
        JPDADebugger bDebugger;
        return breakpoint instanceof JPDABreakpoint && ((bDebugger = ((JPDABreakpoint)breakpoint).getSession()) == null || bDebugger.equals((Object)this.debugger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointAdded(final Breakpoint breakpoint) {
        logger.log(Level.FINE, "breakpointAdded({0})", breakpoint);
        if (!this.acceptBreakpoint(breakpoint)) {
            return;
        }
        final boolean[] started = new boolean[]{false};
        if (!Mutex.EVENT.isReadAccess() && this.debugger.accessLock.readLock().tryLock()) {
            try {
                this.createBreakpointImpl((JPDABreakpoint)breakpoint);
                return;
            }
            finally {
                this.debugger.accessLock.readLock().unlock();
            }
        }
        this.debugger.getRequestProcessor().post(new Runnable(){
            final /* synthetic */ BreakpointsEngineListener this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((BreakpointsEngineListener)this.this$0).debugger.accessLock.readLock().lock();
                try {
                    boolean[] blArray = started;
                    synchronized (started) {
                        started[0] = true;
                        started.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        this.this$0.createBreakpointImpl((JPDABreakpoint)breakpoint);
                    }
                }
                finally {
                    ((BreakpointsEngineListener)this.this$0).debugger.accessLock.readLock().unlock();
                }
                {
                    return;
                }
            }
        });
        if (Mutex.EVENT.isReadAccess()) return;
        boolean[] blArray = started;
        synchronized (started) {
            if (started[0]) return;
            try {
                started.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointRemoved(final Breakpoint breakpoint) {
        if (!this.acceptBreakpoint(breakpoint)) {
            return;
        }
        final boolean[] started = new boolean[]{false};
        if (!Mutex.EVENT.isReadAccess() && this.debugger.accessLock.readLock().tryLock()) {
            try {
                this.removeBreakpointImpl(breakpoint);
                return;
            }
            finally {
                this.debugger.accessLock.readLock().unlock();
            }
        }
        this.debugger.getRequestProcessor().post(new Runnable(){
            final /* synthetic */ BreakpointsEngineListener this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((BreakpointsEngineListener)this.this$0).debugger.accessLock.readLock().lock();
                try {
                    boolean[] blArray = started;
                    synchronized (started) {
                        started[0] = true;
                        started.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        this.this$0.removeBreakpointImpl(breakpoint);
                    }
                }
                finally {
                    ((BreakpointsEngineListener)this.this$0).debugger.accessLock.readLock().unlock();
                }
                {
                    return;
                }
            }
        });
        if (Mutex.EVENT.isReadAccess()) return;
        boolean[] blArray = started;
        synchronized (started) {
            if (started[0]) return;
            try {
                started.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private void createBreakpointImpls() {
        Object[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createBreakpointImpls() bs = " + Arrays.toString(bs));
        }
        for (int i = 0; i < k; ++i) {
            if (!this.acceptBreakpoint((Breakpoint)bs[i])) continue;
            this.createBreakpointImpl((JPDABreakpoint)bs[i]);
        }
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        boolean doCatchExceptions = p.getBoolean("CatchExceptions", false);
        if (doCatchExceptions) {
            ExceptionBreakpoint eb = ExceptionBreakpoint.create((String)Throwable.class.getName(), (int)2);
            this.createBreakpointImpl((JPDABreakpoint)eb);
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            JPDABreakpoint jb;
            JPDADebugger bDebugger;
            boolean removed = this.removeBreakpointImpl(bs[i]);
            if (!removed || !(bs[i] instanceof JPDABreakpoint) || (bDebugger = (jb = (JPDABreakpoint)bs[i]).getSession()) == null || !bDebugger.equals((Object)this.debugger)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)jb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BreakpointImpl getBreakpointImpl(Breakpoint bp) {
        Map<JPDABreakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            return this.breakpointToImpl.get(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixBreakpointImpls() {
        ArrayList<BreakpointImpl> bpis;
        Map<JPDABreakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            bpis = new ArrayList<BreakpointImpl>(this.breakpointToImpl.size());
            for (BreakpointImpl bpi : this.breakpointToImpl.values()) {
                if (bpi == this.preliminaryBreakpointImpl) continue;
                bpis.add(bpi);
            }
        }
        for (BreakpointImpl bpi : bpis) {
            bpi.fixed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBreakpointImpl(JPDABreakpoint b) {
        Map<JPDABreakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            if (this.breakpointToImpl.containsKey(b)) {
                return;
            }
            this.breakpointToImpl.put(b, this.preliminaryBreakpointImpl);
        }
        BreakpointImpl bpi = b instanceof LineBreakpoint ? new LineBreakpointImpl((LineBreakpoint)b, this.breakpointsReader, this.debugger, this.session, this.sourceRootsCache) : (b instanceof ExceptionBreakpoint ? new ExceptionBreakpointImpl((ExceptionBreakpoint)b, this.debugger, this.session, this.sourceRootsCache) : (b instanceof MethodBreakpoint ? new MethodBreakpointImpl((MethodBreakpoint)b, this.debugger, this.session, this.sourceRootsCache) : (b instanceof FieldBreakpoint ? new FieldBreakpointImpl((FieldBreakpoint)b, this.debugger, this.session, this.sourceRootsCache) : (b instanceof ThreadBreakpoint ? new ThreadBreakpointImpl((ThreadBreakpoint)b, this.debugger, this.session) : (b instanceof ClassLoadUnloadBreakpoint ? new ClassBreakpointImpl((ClassLoadUnloadBreakpoint)b, this.debugger, this.session, this.sourceRootsCache) : null)))));
        BreakpointImpl bpiToRemove = null;
        Map<JPDABreakpoint, BreakpointImpl> map2 = this.breakpointToImpl;
        synchronized (map2) {
            if (bpi == null) {
                this.breakpointToImpl.remove(b);
            } else if (!this.breakpointToImpl.containsKey(b)) {
                bpiToRemove = bpi;
            } else {
                this.breakpointToImpl.put(b, bpi);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BreakpointsEngineListener: created impl " + bpi + " for " + b);
        }
        if (bpiToRemove != null) {
            bpiToRemove.remove();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("BreakpointsEngineListener: removed impl " + bpiToRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBreakpointImpl(Breakpoint b) {
        BreakpointImpl impl;
        Map<JPDABreakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            impl = this.breakpointToImpl.remove(b);
            if (impl == null) {
                return false;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BreakpointsEngineListener: removed impl " + impl + " for " + b);
        }
        impl.remove();
        return true;
    }

    private static final class PreliminaryBreakpointImpl
    extends BreakpointImpl {
        public PreliminaryBreakpointImpl() {
            super(null, null, null, null);
        }

        @Override
        protected void setRequests() {
        }

        @Override
        protected EventRequest createEventRequest(EventRequest oldRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean processCondition(Event event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean exec(Event event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removed(EventRequest eventRequest) {
        }

        @Override
        protected void remove() {
        }

        @Override
        public int getCurrentHitCount() {
            return -1;
        }

        @Override
        public int getHitCountsTillBreak() {
            return -1;
        }

        @Override
        public void resetHitCounts() {
        }
    }
}

