/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.swing.ImageIcon;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.FxEvent;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.ValueItem;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.spi.editor.completion.CompletionItem;

public class HandlerMethodCompleter
implements Completer,
Completer.Factory {
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/handler.png";
    private static ImageIcon ICON;
    private CompletionContext ctx;
    private FxEvent event;
    private ElementHandle<TypeElement> controller;

    public HandlerMethodCompleter() {
    }

    private HandlerMethodCompleter(CompletionContext ctx, FxEvent event, ElementHandle<TypeElement> controller) {
        this.ctx = ctx;
        this.event = event;
        this.controller = controller;
    }

    @Override
    public List<? extends CompletionItem> complete() {
        TypeElement el = (TypeElement)this.controller.resolve(this.ctx.getCompilationInfo());
        TypeElement eventType = (TypeElement)this.event.getEventType().resolve(this.ctx.getCompilationInfo());
        if (el == null || eventType == null) {
            return null;
        }
        List<ExecutableElement> allMethods = ElementFilter.methodsIn(this.ctx.getCompilationInfo().getElements().getAllMembers(el));
        ArrayList<ValueItem> items = new ArrayList<ValueItem>();
        for (ExecutableElement em : allMethods) {
            if (!FxClassUtils.isFxmlAccessible(em) || em.getParameters().size() > 1 || em.getReturnType().getKind() != TypeKind.VOID) continue;
            if (!em.getParameters().isEmpty()) {
                VariableElement v = em.getParameters().get(0);
                if (!this.ctx.getCompilationInfo().getTypes().isAssignable(v.asType(), eventType.asType())) {
                    continue;
                }
            } else if (!FxClassUtils.isFxmlAnnotated(em)) continue;
            items.add(new ValueItem(this.ctx, em.getSimpleName().toString(), "#", ICON_RESOURCE));
        }
        return items;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        FxNode parent;
        if ((ctx.getType() == CompletionContext.Type.HANDLER || ctx.getType() == CompletionContext.Type.PROPERTY_VALUE || ctx.getType() == CompletionContext.Type.PROPERTY_VALUE_CONTENT) && (parent = ctx.getParents().get(0)).getKind() == FxNode.Kind.Event) {
            if (parent.getRoot().getControllerType() == null) {
                return null;
            }
            FxEvent e = ((EventHandler)parent).getEventInfo();
            if (e != null) {
                return new HandlerMethodCompleter(ctx, e, parent.getRoot().getControllerType());
            }
        }
        return null;
    }
}

