/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.gen.GlobalNamingResources;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TomcatDatasourceManager
implements DatasourceManager {
    private static final Logger LOGGER = Logger.getLogger(TomcatDatasourceManager.class.getName());
    private final TomcatManager tm;

    public TomcatDatasourceManager(DeploymentManager dm) {
        this.tm = (TomcatManager)dm;
    }

    @CheckForNull
    public static Datasource createDatasource(String name, String data) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(data));
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        String username = props.getProperty("userName");
        String url = props.getProperty("jdbcUrl");
        String password = props.getProperty("password");
        String driverClassName = props.getProperty("jdbcDriver");
        if (name != null && username != null && url != null && driverClassName != null) {
            return new TomcatDatasource(username, url, password, name, driverClassName);
        }
        return null;
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        HashSet<Datasource> result = new HashSet<Datasource>();
        result.addAll(this.getTomcatDatasources());
        result.addAll(this.getTomeeDatasources());
        return result;
    }

    public Set<Datasource> getTomcatDatasources() {
        HashSet<Datasource> result;
        block8: {
            Server server;
            result = new HashSet<Datasource>();
            File serverXml = this.tm.getTomcatProperties().getServerXml();
            try {
                server = Server.createGraph(serverXml);
            }
            catch (IOException | RuntimeException e) {
                Logger.getLogger(TomcatDatasourceManager.class.getName()).log(Level.INFO, null, e);
                return Collections.emptySet();
            }
            GlobalNamingResources[] globalNamingResources = server.getGlobalNamingResources();
            if (globalNamingResources.length <= 0) break block8;
            GlobalNamingResources globalNR = globalNamingResources[0];
            if (this.tm.getTomcatVersion() != TomcatManager.TomcatVersion.TOMCAT_50) {
                int length = globalNR.getResource().length;
                for (int i = 0; i < length; ++i) {
                    String type = globalNR.getResourceType(i);
                    if (!"javax.sql.DataSource".equals(type)) continue;
                    String name = globalNR.getResourceName(i);
                    String username = globalNR.getResourceUsername(i);
                    String url = globalNR.getResourceUrl(i);
                    String password = globalNR.getResourcePassword(i);
                    String driverClassName = globalNR.getResourceDriverClassName(i);
                    if (name == null || username == null || url == null || driverClassName == null) continue;
                    result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                }
            } else {
                int length = globalNR.getResource().length;
                ResourceParams[] resourceParams = globalNR.getResourceParams();
                for (int i = 0; i < length; ++i) {
                    String type = globalNR.getResourceType(i);
                    if (!"javax.sql.DataSource".equals(type)) continue;
                    String name = globalNR.getResourceName(i);
                    for (int j = 0; j < resourceParams.length; ++j) {
                        if (!name.equals(resourceParams[j].getName())) continue;
                        Parameter[] params = resourceParams[j].getParameter();
                        HashMap<String, String> paramNameValueMap = new HashMap<String, String>(params.length);
                        for (Parameter parameter : params) {
                            paramNameValueMap.put(parameter.getName(), parameter.getValue());
                        }
                        String username = (String)paramNameValueMap.get("username");
                        String url = (String)paramNameValueMap.get("url");
                        String password = (String)paramNameValueMap.get("password");
                        String driverClassName = (String)paramNameValueMap.get("driverClassName");
                        if (username == null || url == null || driverClassName == null) continue;
                        result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                    }
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Datasource> getTomeeDatasources() {
        if (!this.tm.isTomEE()) {
            return Collections.emptySet();
        }
        File tomeeXml = this.tm.getTomcatProperties().getTomeeXml();
        if (tomeeXml == null) {
            return Collections.emptySet();
        }
        try {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(tomeeXml));){
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                DatasourceHandler handler = new DatasourceHandler();
                saxParser.parse((InputStream)is, (DefaultHandler)handler);
                Set<Datasource> set = handler.getDataSources();
                return set;
            }
            catch (IOException e) {
                Logger.getLogger(TomcatDatasourceManager.class.getName()).log(Level.INFO, null, e);
                return Collections.emptySet();
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            Logger.getLogger(TomcatDatasourceManager.class.getName()).log(Level.INFO, null, ex);
        }
        return Collections.emptySet();
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
    }

    private static class DatasourceHandler
    extends DefaultHandler {
        private final StringBuilder content = new StringBuilder();
        private final Set<Datasource> dataSources = new HashSet<Datasource>();
        private boolean isResource = false;
        private String name;

        private DatasourceHandler() {
        }

        public Set<Datasource> getDataSources() {
            return this.dataSources;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.content.setLength(0);
            if ("Resource".equals(qName) && "javax.sql.DataSource".equals(attributes.getValue("type")) && attributes.getValue("id") != null) {
                this.isResource = true;
                this.name = attributes.getValue("id");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isResource && "Resource".equals(qName)) {
                this.dataSources.add(TomcatDatasourceManager.createDatasource(this.name, this.content.toString()));
                this.isResource = false;
                this.name = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isResource) {
                this.content.append(ch, start, length);
            }
        }
    }
}

