/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.datatype.FloatingPointExponentPositive;
import nu.validator.datatype.ImageCandidateURL;
import org.relaxng.datatype.DatatypeException;

public class ImageCandidateStrings
extends AbstractDatatype {
    private static final int CLIP_LIMIT = 15;
    private static final int ELIDE_LIMIT = 50;
    private static final int NO_WIDTH = -1;
    private static final float NO_DENSITY = -1.0f;
    private static final float ONE = 1.0f;
    private static final ImageCandidateURL IC_URL = ImageCandidateURL.THE_INSTANCE;
    private static final FloatingPointExponentPositive FLOAT = FloatingPointExponentPositive.THE_INSTANCE;
    public static final ImageCandidateStrings THE_INSTANCE = new ImageCandidateStrings();
    private String whenSizesIsPresent = " (When the " + this.code("sizes") + " attribute is present";
    private String allMustSpecifyWidth = ", all image candidate strings must specify a width.)";

    protected ImageCandidateStrings() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() == 0) {
            this.err("Must contain one or more image candidate strings.");
        }
        urls = new ArrayList<String>();
        widths = new ArrayList<Integer>();
        denses = new ArrayList<Float>();
        url = new StringBuilder();
        tok = new StringBuilder();
        extract = new StringBuilder();
        eof = false;
        waitingForCandidate = true;
        ix = 0;
        state = State.SPLITTING_LOOP;
        block7: for (i = 0; i < literal.length(); ++i) {
            c = literal.charAt(i);
            extract.append(c);
            eof = i == literal.length() - 1;
            switch (1.$SwitchMap$nu$validator$datatype$ImageCandidateStrings$State[state.ordinal()]) {
                case 1: {
                    if (this.isWhitespace(c)) continue block7;
                    if (',' == c) {
                        if (urls.isEmpty()) {
                            this.err("Starts with empty image-candidate string.");
                        }
                        if (waitingForCandidate) {
                            this.errEmpty(extract);
                        }
                        this.commaHandler(extract);
                        waitingForCandidate = true;
                        url.setLength(0);
                        continue block7;
                    }
                }
                case 2: {
                    waitingForCandidate = false;
                    if (eof || this.isWhitespace(c)) {
                        if (!this.isWhitespace(c)) {
                            url.append(c);
                        }
                        state = State.COLLECTING_DESCRIPTOR_TOKENS;
                        if (this.endsWithComma(url)) {
                            url.deleteCharAt(url.length() - 1);
                            waitingForCandidate = true;
                            state = State.SPLITTING_LOOP;
                        }
                        ImageCandidateStrings.IC_URL.checkValid(url);
                        urls.add(url.toString());
                        url.setLength(0);
                        tok.setLength(0);
                        if (!eof && !waitingForCandidate) continue block7;
                        this.adjustWidths(urls, widths, ix);
                        this.adjustDenses(urls, denses, ix);
                        ++ix;
                        continue block7;
                    }
                    url.append(c);
                    state = State.URL;
                    continue block7;
                }
                case 3: {
                    if (this.isWhitespace(c)) {
                        this.checkToken(tok, extract, urls, widths, denses, ix);
                        tok.setLength(0);
                        state = State.AFTER_TOKEN;
                        continue block7;
                    }
                    if (',' == c) {
                        this.checkToken(tok, extract, urls, widths, denses, ix);
                        ++ix;
                        waitingForCandidate = true;
                        state = State.SPLITTING_LOOP;
                        continue block7;
                    }
                    if ('(' == c) {
                        tok.append(c);
                        state = State.IN_PARENS;
                        continue block7;
                    }
                    if (eof) {
                        tok.append(c);
                        this.checkToken(tok, extract, urls, widths, denses, ix);
                        continue block7;
                    }
                    tok.append(c);
                    continue block7;
                }
                case 4: {
                    if (')' != c) ** GOTO lbl91
                    tok.append(c);
                    if (eof) {
                        this.checkToken(tok, extract, urls, widths, denses, ix);
                        continue block7;
                    }
                    state = State.COLLECTING_DESCRIPTOR_TOKENS;
                    ** GOTO lbl97
lbl91:
                    // 1 sources

                    if (eof) {
                        this.errNoRightParen(tok, extract);
                    } else {
                        tok.append(c);
                        continue block7;
                    }
                }
lbl97:
                // 3 sources

                case 5: {
                    if (this.isWhitespace(c)) {
                        if (!eof) continue block7;
                        this.checkToken(tok, extract, urls, widths, denses, ix);
                        continue block7;
                    }
                    --i;
                    extract.setLength(extract.length() - 1);
                    state = State.COLLECTING_DESCRIPTOR_TOKENS;
                }
            }
        }
        this.checkWidths(widths, urls);
        if (waitingForCandidate) {
            this.err("Ends with empty image-candidate string.");
        }
    }

    private int commaHandler(CharSequence cs) throws DatatypeException {
        if (',' != cs.charAt(cs.length() - 1)) {
            return cs.length();
        }
        for (int i = cs.length() - 2; i > 0 && ',' == cs.charAt(i); --i) {
            this.errEmpty(cs);
        }
        return cs.length() - 1;
    }

    private boolean endsWithComma(CharSequence cs) throws DatatypeException {
        int end = this.commaHandler(cs);
        return end == cs.length() - 1;
    }

    private void checkToken(StringBuilder tok, CharSequence extract, List<String> urls, List<Integer> widths, List<Float> denses, int ix) throws DatatypeException {
        if (tok.length() > 0) {
            if (widths.size() > ix || denses.size() > ix) {
                this.errExtraDescriptor(tok, extract);
            }
            char first = tok.charAt(0);
            char last = tok.charAt(tok.length() - 1);
            if ('w' != last && this.widthRequired()) {
                this.errNotWidthDescriptor(tok, extract);
            }
            if ('w' != last && 'x' != last) {
                this.errNotSupportedFormat(tok, extract);
            }
            String num = tok.subSequence(0, tok.length() - 1).toString();
            if ('-' == first) {
                this.errNotNumberGreaterThanZero(num, extract);
            }
            if ('+' == first) {
                this.errLeadingPlusSign(num, extract);
            }
            if ('w' == last) {
                System.setProperty("nu.validator.checker.imageCandidateString.hasWidth", "1");
                try {
                    int width = Integer.parseInt(num, 10);
                    if (width <= 0) {
                        this.errNotNumberGreaterThanZero(num, extract);
                    }
                    if (!widths.isEmpty() && widths.contains(width)) {
                        this.errSameWidth(urls.get(ix), urls.get(widths.indexOf(width)));
                    }
                    widths.add(width);
                    denses.add(Float.valueOf(-1.0f));
                }
                catch (NumberFormatException e) {
                    this.errNotInteger(num, extract);
                }
            }
            if ('x' == last) {
                try {
                    try {
                        FLOAT.checkValid(num);
                    }
                    catch (DatatypeException e) {
                        this.errFromOtherDatatype(e.getMessage(), extract);
                    }
                    float density = Float.parseFloat(num);
                    if (!denses.isEmpty() && denses.contains(Float.valueOf(density))) {
                        this.errSameDensity(urls.get(ix), urls.get(denses.indexOf(Float.valueOf(density))));
                    }
                    denses.add(Float.valueOf(density));
                    widths.add(-1);
                }
                catch (NumberFormatException e) {
                    this.errNotFloatingPointNumber(num, extract);
                }
            }
        }
    }

    private void checkWidths(List<Integer> widths, List<String> urls) throws DatatypeException {
        if (widths.contains(-1) && Collections.frequency(widths, -1) != widths.size()) {
            this.errNoWidth(urls.get(widths.indexOf(-1)), urls.get(widths.indexOf(Collections.max(widths))));
        }
    }

    private void adjustWidths(List<String> urls, List<Integer> widths, int ix) throws DatatypeException {
        if (widths.size() == ix || widths.size() != 0 && widths.size() > ix && widths.get(ix) == -1) {
            if (this.widthRequired()) {
                this.errNoWidth(urls.get(ix), null);
            } else if (widths.size() == ix) {
                widths.add(-1);
            }
        }
    }

    private void adjustDenses(List<String> urls, List<Float> denses, int ix) throws DatatypeException {
        if (denses.size() == ix) {
            if (denses.indexOf(Float.valueOf(1.0f)) != -1) {
                this.errSameDensity(urls.get(ix), urls.get(denses.indexOf(Float.valueOf(1.0f))));
            }
            denses.add(Float.valueOf(1.0f));
        }
    }

    private void err(String message) throws DatatypeException {
        throw this.newDatatypeException(message);
    }

    private void errFromOtherDatatype(CharSequence msg, CharSequence extract) throws DatatypeException {
        this.err(msg.subSequence(0, msg.length() - 1) + " at " + this.clip(extract) + ".");
    }

    private void errEmpty(CharSequence extract) throws DatatypeException {
        this.err("Empty image-candidate string at " + this.clip(extract) + ".");
    }

    private void errExtraDescriptor(CharSequence tok, CharSequence extract) throws DatatypeException {
        this.err("Expected single descriptor but found extraneous descriptor " + this.code(tok) + " at " + this.clip(extract) + ".");
    }

    private void errNotWidthDescriptor(CharSequence tok, CharSequence extract) throws DatatypeException {
        this.err("Expected width descriptor but found " + this.code(tok) + " at " + this.clip(extract) + "." + this.whenSizesIsPresent + this.allMustSpecifyWidth);
    }

    private void errNotSupportedFormat(CharSequence tok, CharSequence extract) throws DatatypeException {
        this.err("Expected number followed by " + this.code("w") + " or " + this.code("x") + " but found " + this.code(tok) + " at " + this.clip(extract) + ".");
    }

    private void errNotInteger(String num, CharSequence extract) throws DatatypeException {
        this.err("Expected integer but found " + this.code(num) + " at " + this.clip(extract) + ".");
    }

    private void errNotFloatingPointNumber(String num, CharSequence extract) throws DatatypeException {
        this.err("Expected floating-point number but found " + this.code(num) + " at " + this.clip(extract) + ".");
    }

    private void errNotNumberGreaterThanZero(CharSequence num, CharSequence extract) throws DatatypeException {
        this.err("Expected number greater than zero but found " + this.code(num) + " at " + this.clip(extract) + ".");
    }

    private void errNoRightParen(CharSequence tok, CharSequence extract) throws DatatypeException {
        this.err("Expected right parenthesis character but found " + this.code(tok) + " at " + this.clip(extract) + ".");
    }

    private void errLeadingPlusSign(CharSequence num, CharSequence extract) throws DatatypeException {
        this.err("Expected number without leading plus sign but found " + this.code(num) + " at " + this.clip(extract) + ".");
    }

    private void errSameWidth(CharSequence url1, CharSequence url2) throws DatatypeException {
        this.err("Width for image " + this.elide(url1) + " is identical to width for image " + this.elide(url2) + ".");
    }

    private void errSameDensity(CharSequence url1, CharSequence url2) throws DatatypeException {
        this.err("Density for image " + this.elide(url1) + " is identical to density for image " + this.elide(url2) + ".");
    }

    private void errNoWidth(CharSequence url1, CharSequence url2) throws DatatypeException {
        String msg = "No width specified for image " + this.elide(url1) + ".";
        msg = url2 == null ? msg + this.whenSizesIsPresent : msg + " (Because one or more image candidate strings specify a width (e.g., the string for image " + this.elide(url2) + ")";
        msg = msg + this.allMustSpecifyWidth;
        this.err(msg);
    }

    private CharSequence clip(CharSequence cs) {
        int len = cs.length();
        if (len > 15) {
            cs = "\u2026" + cs.subSequence(len - 15, len);
        }
        return this.code(cs);
    }

    private CharSequence elide(CharSequence cs) {
        int len = cs.length();
        if (len < 50) {
            return this.code(cs);
        }
        StringBuilder sb = new StringBuilder(51);
        sb.append(cs, 0, 25);
        sb.append('\u2026');
        sb.append(cs, len - 25, len);
        return this.code(sb);
    }

    private CharSequence code(CharSequence cs) {
        return "\u201c" + cs + "\u201d";
    }

    protected boolean widthRequired() {
        return false;
    }

    @Override
    public String getName() {
        return "image candidate strings";
    }

    private static enum State {
        SPLITTING_LOOP,
        URL,
        COLLECTING_DESCRIPTOR_TOKENS,
        IN_PARENS,
        AFTER_TOKEN;

    }
}

