/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.eval;

import java.awt.Color;
import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.javascript.cdtdebug.ui.eval.Bundle;
import org.netbeans.modules.javascript.cdtdebug.ui.eval.VarOrError;
import org.netbeans.modules.javascript.cdtdebug.ui.vars.models.VariablesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class EvaluationResultsModel
extends VariablesModel {
    private static final String ICON_HISTORY_NODE = "org/netbeans/modules/debugger/resources/evaluator/history_node_16.png";
    private static final String ICON_HISTORY_ITEM = "org/netbeans/modules/debugger/resources/evaluator/eval_history_item.png";
    private static final String ICON_EVAL_RESULT = "org/netbeans/modules/debugger/resources/evaluator/evaluator_result_16.png";
    private static final String ICON_WRONG_PASS = "org/netbeans/modules/debugger/resources/wrong_pass.png";
    private static final RequestProcessor RP = new RequestProcessor(EvaluationResultsModel.class);
    private final CodeEvaluator.Result result;
    private final EvaluatorListener evalListener = new EvaluatorListener();

    public EvaluationResultsModel(ContextProvider contextProvider) {
        super(contextProvider);
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)contextProvider.lookupFirst(null, DebuggerEngine.class)));
        this.result.addListener((CodeEvaluator.Result.Listener)this.evalListener);
    }

    @Override
    public int getChildrenCount(Object parent) throws UnknownTypeException {
        if (parent instanceof HistoryNode) {
            return ((HistoryNode)parent).getItems().size();
        }
        if (parent == "Root") {
            return 2;
        }
        if (parent instanceof VarOrError) {
            VarOrError voe = (VarOrError)parent;
            if (voe.hasVar()) {
                return super.getChildrenCount(voe.getVar());
            }
            return 0;
        }
        return super.getChildrenCount(parent);
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent instanceof HistoryNode) {
            List<CodeEvaluator.Result.DefaultHistoryItem> l = ((HistoryNode)parent).getItems();
            for (CodeEvaluator.Result.DefaultHistoryItem o : l) {
                if (o instanceof CodeEvaluator.Result.DefaultHistoryItem) continue;
                return new Object[0];
            }
            return l.toArray();
        }
        if (parent == "Root") {
            Object result = this.result.getResult();
            List items = this.result.getHistoryItems();
            int count = 0;
            if (result != null) {
                ++count;
            }
            if (!items.isEmpty()) {
                ++count;
            }
            Object[] children = new Object[count];
            int index = 0;
            if (result != null) {
                children[index++] = result;
            }
            if (!items.isEmpty()) {
                children[index] = new HistoryNode(items);
            }
            return children;
        }
        if (parent instanceof VarOrError) {
            VarOrError voe = (VarOrError)parent;
            if (voe.hasVar()) {
                return super.getChildren(voe.getVar(), from, to);
            }
            return new Object[0];
        }
        return super.getChildren(parent, from, to);
    }

    @Override
    public boolean isLeaf(Object node) {
        if ("Root".equals(node)) {
            return false;
        }
        if (node instanceof HistoryNode) {
            return false;
        }
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return true;
        }
        if (node instanceof VarOrError) {
            VarOrError voe = (VarOrError)node;
            if (voe.hasVar()) {
                return super.isLeaf(voe.getVar());
            }
            return true;
        }
        return super.isLeaf(node);
    }

    @Override
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return ((CodeEvaluator.Result.DefaultHistoryItem)node).getExpression();
        }
        if (node instanceof HistoryNode) {
            return Bundle.CTL_EvaluatorHistoryNode();
        }
        if (node instanceof VarOrError) {
            return this.result.getExpression();
        }
        return super.getDisplayName(node);
    }

    @Override
    public String getShortDescription(Object node) throws UnknownTypeException {
        String str;
        if (node == this.result.getResult() && (str = this.result.getExpression()) != null) {
            str = str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br/>").replace("\r", "");
            return "<html>" + str + "</html>";
        }
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return ((CodeEvaluator.Result.DefaultHistoryItem)node).getTooltip();
        }
        if (node instanceof HistoryNode) {
            return Bundle.CTL_EvaluatorHistoryNodeDescr();
        }
        if (node instanceof VarOrError) {
            return this.result.getExpression();
        }
        return super.getShortDescription(node);
    }

    @Override
    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == this.result.getResult()) {
            return ICON_EVAL_RESULT;
        }
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return ICON_HISTORY_ITEM;
        }
        if (node instanceof HistoryNode) {
            return ICON_HISTORY_NODE;
        }
        if (node instanceof VarOrError) {
            VarOrError voe = (VarOrError)node;
            if (voe.hasVar()) {
                return super.getIconBaseWithExtension(voe.getVar());
            }
            return ICON_WRONG_PASS;
        }
        return super.getIconBaseWithExtension(node);
    }

    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            CodeEvaluator.Result.DefaultHistoryItem item = (CodeEvaluator.Result.DefaultHistoryItem)node;
            if ("LocalsToString".equals(columnID)) {
                return item.getToStringValue();
            }
            if ("LocalsType".equals(columnID)) {
                return item.getType();
            }
            if ("LocalsValue".equals(columnID)) {
                return item.getValue();
            }
            return "";
        }
        if (node instanceof HistoryNode) {
            return "";
        }
        if (node instanceof VarOrError) {
            VarOrError voe = (VarOrError)node;
            if (voe.hasVar()) {
                return super.getValueAt(voe.getVar(), columnID);
            }
            if ("LocalsType".equals(columnID)) {
                return "";
            }
            return EvaluationResultsModel.toHTML((String)voe.getError(), (boolean)true, (boolean)false, (Color)Color.red);
        }
        return super.getValueAt(node, columnID);
    }

    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem || node instanceof HistoryNode) {
            return true;
        }
        if (node instanceof VarOrError) {
            return true;
        }
        return super.isReadOnly(node, columnID);
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem || node instanceof HistoryNode) {
            return;
        }
        if (node instanceof VarOrError) {
            return;
        }
        super.setValueAt(node, columnID, value);
    }

    public void fireNodeChanged(Object node) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
    }

    private void fireSelectionChanged(final Object result) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.SelectionChanged((Object)this, new Object[0]));
        RP.post(new Runnable(){
            final /* synthetic */ EvaluationResultsModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.fireChangeEvent((ModelEvent)new ModelEvent.SelectionChanged((Object)this.this$0, new Object[]{result}));
            }
        }, 500);
    }

    private class EvaluatorListener
    implements CodeEvaluator.Result.Listener<VarOrError> {
        private EvaluatorListener() {
        }

        public void resultChanged(VarOrError voe) {
            EvaluationResultsModel.this.fireNodeChanged("Root");
            EvaluationResultsModel.this.fireSelectionChanged(voe);
        }
    }

    private static class HistoryNode {
        private final List<CodeEvaluator.Result.DefaultHistoryItem> items;

        HistoryNode(List<CodeEvaluator.Result.DefaultHistoryItem> items) {
            this.items = items;
        }

        List<CodeEvaluator.Result.DefaultHistoryItem> getItems() {
            return this.items;
        }
    }
}

