/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.lexer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;

public final class TwigLexerUtils {
    private TwigLexerUtils() {
    }

    public static TokenSequence<? extends TokenId> getTwigMarkupTokenSequence(Snapshot snapshot, int offset) {
        TokenSequence<TwigBlockTokenId> twigBlockTokenSequence = TwigLexerUtils.getTokenSequence(snapshot.getTokenHierarchy(), offset, TwigBlockTokenId.language());
        return twigBlockTokenSequence == null ? TwigLexerUtils.getTokenSequence(snapshot.getTokenHierarchy(), offset, TwigVariableTokenId.language()) : twigBlockTokenSequence;
    }

    public static TokenSequence<? extends TokenId> getTwigMarkupTokenSequence(Document document, int offset) {
        TokenSequence<? extends TwigBlockTokenId> twigBlockTokenSequence = TwigLexerUtils.getTwigBlockTokenSequence(document, offset);
        return twigBlockTokenSequence == null ? TwigLexerUtils.getTwigVariableTokenSequence(document, offset) : twigBlockTokenSequence;
    }

    public static TokenSequence<? extends TwigBlockTokenId> getTwigBlockTokenSequence(Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        return TwigLexerUtils.getTokenSequence(th, offset, TwigBlockTokenId.language());
    }

    public static TokenSequence<? extends TwigVariableTokenId> getTwigVariableTokenSequence(Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        return TwigLexerUtils.getTokenSequence(th, offset, TwigVariableTokenId.language());
    }

    public static TokenSequence<? extends TwigTopTokenId> getTwigTokenSequence(Snapshot snapshot, int offset) {
        return TwigLexerUtils.getTokenSequence(snapshot.getTokenHierarchy(), offset, TwigTopTokenId.language());
    }

    public static TokenSequence<? extends TwigTopTokenId> getTwigTokenSequence(Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        return TwigLexerUtils.getTokenSequence(th, offset, TwigTopTokenId.language());
    }

    public static <L> TokenSequence<? extends L> getTokenSequence(TokenHierarchy<?> th, int offset, Language<? extends L> language) {
        TokenSequence ts = th.tokenSequence(language);
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != language) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != language) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static List<OffsetRange> findForwardMatching(TokenSequence<? extends TwigTopTokenId> topTs, TwigTokenText start, TwigTokenText end) {
        return TwigLexerUtils.findForwardMatching(topTs, start, end, Collections.emptyList());
    }

    public static List<OffsetRange> findForwardMatching(TokenSequence<? extends TwigTopTokenId> topTs, TwigTokenText start, TwigTokenText end, List<TwigTokenText> middle) {
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        topTs.moveNext();
        int originalOffset = topTs.offset();
        int balance = 1;
        while (topTs.moveNext()) {
            TokenSequence markupTs;
            Token token = topTs.token();
            if (token == null || token.id() != TwigTopTokenId.T_TWIG_BLOCK && token.id() != TwigTopTokenId.T_TWIG_VAR || (markupTs = topTs.embedded(TwigBlockTokenId.language())) == null) continue;
            markupTs.moveNext();
            while (markupTs.moveNext()) {
                Token markupToken = markupTs.token();
                if (start.matches((Token<? extends TwigBlockTokenId>)markupToken)) {
                    ++balance;
                    continue;
                }
                if (end.matches((Token<? extends TwigBlockTokenId>)markupToken)) {
                    if (--balance != 0) continue;
                    result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                    break;
                }
                if (!TwigLexerUtils.matchesToken(middle, (Token<? extends TwigBlockTokenId>)markupToken) || balance != 1) continue;
                result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                break;
            }
            if (balance != 0) continue;
            break;
        }
        topTs.move(originalOffset);
        return result;
    }

    private static boolean matchesToken(List<TwigTokenText> middle, Token<? extends TwigBlockTokenId> markupToken) {
        boolean result = false;
        for (TwigTokenText twigTokenText : middle) {
            if (!twigTokenText.matches(markupToken)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static List<OffsetRange> findBackwardMatching(TokenSequence<? extends TwigTopTokenId> topTs, TwigTokenText start, TwigTokenText end, List<TwigTokenText> middle) {
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        topTs.movePrevious();
        int originalOffset = topTs.offset();
        int balance = 1;
        while (topTs.movePrevious()) {
            TokenSequence markupTs;
            Token token = topTs.token();
            if (token == null || token.id() != TwigTopTokenId.T_TWIG_BLOCK && token.id() != TwigTopTokenId.T_TWIG_VAR || (markupTs = topTs.embedded(TwigBlockTokenId.language())) == null) continue;
            markupTs.moveEnd();
            while (markupTs.movePrevious()) {
                Token markupToken = markupTs.token();
                if (start.matches((Token<? extends TwigBlockTokenId>)markupToken)) {
                    ++balance;
                    continue;
                }
                if (end.matches((Token<? extends TwigBlockTokenId>)markupToken)) {
                    if (--balance != 0) continue;
                    result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                    break;
                }
                if (!TwigLexerUtils.matchesToken(middle, (Token<? extends TwigBlockTokenId>)markupToken) || balance != 1) continue;
                result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                break;
            }
            if (balance != 0) continue;
            break;
        }
        topTs.move(originalOffset);
        return result;
    }

    public static List<OffsetRange> findBackwardMatching(TokenSequence<? extends TwigTopTokenId> topTs, TwigTokenText start, TwigTokenText end) {
        return TwigLexerUtils.findBackwardMatching(topTs, start, end, Collections.emptyList());
    }

    public static boolean textEquals(CharSequence text1, char ... text2) {
        int len = text1.length();
        if (len == text2.length) {
            for (int i = len - 1; i >= 0; --i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean textStartWith(CharSequence text1, char text2) {
        int len = text1.length();
        if (len > 0) {
            return text1.charAt(0) == text2;
        }
        return false;
    }

    public static int getTokenBalance(BaseDocument doc, char open, char close, int offset) throws BadLocationException {
        TokenId id;
        TokenSequence<? extends TokenId> ts = TwigLexerUtils.getTwigMarkupTokenSequence((Document)doc, offset);
        if (ts == null) {
            return 0;
        }
        int balance = 0;
        ts.move(offset);
        while (ts.moveNext()) {
            id = ts.token().id();
            if (id != TwigVariableTokenId.T_TWIG_PUNCTUATION && id != TwigBlockTokenId.T_TWIG_PUNCTUATION) continue;
            if (TwigLexerUtils.textEquals(ts.token().text(), close)) {
                --balance;
                continue;
            }
            if (!TwigLexerUtils.textEquals(ts.token().text(), open)) continue;
            break;
        }
        ts.move(offset);
        while (ts.movePrevious()) {
            id = ts.token().id();
            if (id != TwigVariableTokenId.T_TWIG_PUNCTUATION && id != TwigBlockTokenId.T_TWIG_PUNCTUATION) continue;
            if (TwigLexerUtils.textEquals(ts.token().text(), close)) {
                --balance;
            } else if (TwigLexerUtils.textEquals(ts.token().text(), open)) {
                ++balance;
            }
            if (balance <= 0) continue;
            break;
        }
        return balance;
    }

    public static interface TwigTokenText {
        public static final TwigTokenText NONE = new TwigTokenText(){

            @Override
            public boolean matches(Token<? extends TwigBlockTokenId> token) {
                return false;
            }
        };

        public boolean matches(Token<? extends TwigBlockTokenId> var1);
    }

    public static final class TwigTokenTextImpl
    implements TwigTokenText {
        private final TwigBlockTokenId tokenId;
        private final String tokenText;

        public static TwigTokenText create(TwigBlockTokenId tokenId, String tokenText) {
            return new TwigTokenTextImpl(tokenId, tokenText);
        }

        private TwigTokenTextImpl(TwigBlockTokenId tokenId, String tokenText) {
            this.tokenId = tokenId;
            this.tokenText = tokenText;
        }

        @Override
        public boolean matches(Token<? extends TwigBlockTokenId> token) {
            return token != null && token.id() == this.tokenId && this.tokenText.equals(token.text().toString());
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + Objects.hashCode((Object)this.tokenId);
            hash = 71 * hash + Objects.hashCode(this.tokenText);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TwigTokenTextImpl other = (TwigTokenTextImpl)obj;
            if (this.tokenId != other.tokenId) {
                return false;
            }
            return Objects.equals(this.tokenText, other.tokenText);
        }

        public String toString() {
            return "TwigTokenText{tokenId=" + (Object)((Object)this.tokenId) + ", tokenText=" + this.tokenText + '}';
        }
    }
}

