/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateImageDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateImageRequest
extends BmcRequest<UpdateImageDetails> {
    private String imageId;
    private UpdateImageDetails updateImageDetails;
    private String opcRetryToken;
    private String ifMatch;

    public String getImageId() {
        return this.imageId;
    }

    public UpdateImageDetails getUpdateImageDetails() {
        return this.updateImageDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateImageDetails getBody$() {
        return this.updateImageDetails;
    }

    public Builder toBuilder() {
        return new Builder().imageId(this.imageId).updateImageDetails(this.updateImageDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",imageId=").append(String.valueOf(this.imageId));
        sb.append(",updateImageDetails=").append(String.valueOf((Object)this.updateImageDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateImageRequest)) {
            return false;
        }
        UpdateImageRequest other = (UpdateImageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.imageId, other.imageId) && Objects.equals((Object)this.updateImageDetails, (Object)other.updateImageDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.updateImageDetails == null ? 43 : this.updateImageDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateImageRequest, UpdateImageDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String imageId = null;
        private UpdateImageDetails updateImageDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder updateImageDetails(UpdateImageDetails updateImageDetails) {
            this.updateImageDetails = updateImageDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateImageRequest o) {
            this.imageId(o.getImageId());
            this.updateImageDetails(o.getUpdateImageDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateImageRequest build() {
            UpdateImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateImageDetails body) {
            this.updateImageDetails(body);
            return this;
        }

        public UpdateImageRequest buildWithoutInvocationCallback() {
            UpdateImageRequest request = new UpdateImageRequest();
            request.imageId = this.imageId;
            request.updateImageDetails = this.updateImageDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

