/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PhaseTwoConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isCustomPhaseTwoConfig")
    private final Boolean isCustomPhaseTwoConfig;
    @JsonProperty(value="authenticationAlgorithm")
    private final AuthenticationAlgorithm authenticationAlgorithm;
    @JsonProperty(value="encryptionAlgorithm")
    private final EncryptionAlgorithm encryptionAlgorithm;
    @JsonProperty(value="lifetimeInSeconds")
    private final Integer lifetimeInSeconds;
    @JsonProperty(value="isPfsEnabled")
    private final Boolean isPfsEnabled;
    @JsonProperty(value="pfsDhGroup")
    private final PfsDhGroup pfsDhGroup;

    @Deprecated
    @ConstructorProperties(value={"isCustomPhaseTwoConfig", "authenticationAlgorithm", "encryptionAlgorithm", "lifetimeInSeconds", "isPfsEnabled", "pfsDhGroup"})
    public PhaseTwoConfigDetails(Boolean isCustomPhaseTwoConfig, AuthenticationAlgorithm authenticationAlgorithm, EncryptionAlgorithm encryptionAlgorithm, Integer lifetimeInSeconds, Boolean isPfsEnabled, PfsDhGroup pfsDhGroup) {
        this.isCustomPhaseTwoConfig = isCustomPhaseTwoConfig;
        this.authenticationAlgorithm = authenticationAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.lifetimeInSeconds = lifetimeInSeconds;
        this.isPfsEnabled = isPfsEnabled;
        this.pfsDhGroup = pfsDhGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsCustomPhaseTwoConfig() {
        return this.isCustomPhaseTwoConfig;
    }

    public AuthenticationAlgorithm getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public Integer getLifetimeInSeconds() {
        return this.lifetimeInSeconds;
    }

    public Boolean getIsPfsEnabled() {
        return this.isPfsEnabled;
    }

    public PfsDhGroup getPfsDhGroup() {
        return this.pfsDhGroup;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PhaseTwoConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isCustomPhaseTwoConfig=").append(String.valueOf(this.isCustomPhaseTwoConfig));
        sb.append(", authenticationAlgorithm=").append(String.valueOf((Object)this.authenticationAlgorithm));
        sb.append(", encryptionAlgorithm=").append(String.valueOf((Object)this.encryptionAlgorithm));
        sb.append(", lifetimeInSeconds=").append(String.valueOf(this.lifetimeInSeconds));
        sb.append(", isPfsEnabled=").append(String.valueOf(this.isPfsEnabled));
        sb.append(", pfsDhGroup=").append(String.valueOf((Object)this.pfsDhGroup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhaseTwoConfigDetails)) {
            return false;
        }
        PhaseTwoConfigDetails other = (PhaseTwoConfigDetails)((Object)o);
        return Objects.equals(this.isCustomPhaseTwoConfig, other.isCustomPhaseTwoConfig) && Objects.equals((Object)this.authenticationAlgorithm, (Object)other.authenticationAlgorithm) && Objects.equals((Object)this.encryptionAlgorithm, (Object)other.encryptionAlgorithm) && Objects.equals(this.lifetimeInSeconds, other.lifetimeInSeconds) && Objects.equals(this.isPfsEnabled, other.isPfsEnabled) && Objects.equals((Object)this.pfsDhGroup, (Object)other.pfsDhGroup) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCustomPhaseTwoConfig == null ? 43 : this.isCustomPhaseTwoConfig.hashCode());
        result = result * 59 + (this.authenticationAlgorithm == null ? 43 : this.authenticationAlgorithm.hashCode());
        result = result * 59 + (this.encryptionAlgorithm == null ? 43 : this.encryptionAlgorithm.hashCode());
        result = result * 59 + (this.lifetimeInSeconds == null ? 43 : this.lifetimeInSeconds.hashCode());
        result = result * 59 + (this.isPfsEnabled == null ? 43 : this.isPfsEnabled.hashCode());
        result = result * 59 + (this.pfsDhGroup == null ? 43 : this.pfsDhGroup.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PfsDhGroup implements BmcEnum
    {
        Group2("GROUP2"),
        Group5("GROUP5"),
        Group14("GROUP14"),
        Group19("GROUP19"),
        Group20("GROUP20"),
        Group24("GROUP24");

        private final String value;
        private static Map<String, PfsDhGroup> map;

        private PfsDhGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PfsDhGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PfsDhGroup: " + key);
        }

        static {
            map = new HashMap<String, PfsDhGroup>();
            for (PfsDhGroup v : PfsDhGroup.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EncryptionAlgorithm implements BmcEnum
    {
        Aes256Gcm("AES_256_GCM"),
        Aes192Gcm("AES_192_GCM"),
        Aes128Gcm("AES_128_GCM"),
        Aes256Cbc("AES_256_CBC"),
        Aes192Cbc("AES_192_CBC"),
        Aes128Cbc("AES_128_CBC");

        private final String value;
        private static Map<String, EncryptionAlgorithm> map;

        private EncryptionAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EncryptionAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EncryptionAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm v : EncryptionAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AuthenticationAlgorithm implements BmcEnum
    {
        HmacSha2256128("HMAC_SHA2_256_128"),
        HmacSha1128("HMAC_SHA1_128");

        private final String value;
        private static Map<String, AuthenticationAlgorithm> map;

        private AuthenticationAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuthenticationAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AuthenticationAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, AuthenticationAlgorithm>();
            for (AuthenticationAlgorithm v : AuthenticationAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isCustomPhaseTwoConfig")
        private Boolean isCustomPhaseTwoConfig;
        @JsonProperty(value="authenticationAlgorithm")
        private AuthenticationAlgorithm authenticationAlgorithm;
        @JsonProperty(value="encryptionAlgorithm")
        private EncryptionAlgorithm encryptionAlgorithm;
        @JsonProperty(value="lifetimeInSeconds")
        private Integer lifetimeInSeconds;
        @JsonProperty(value="isPfsEnabled")
        private Boolean isPfsEnabled;
        @JsonProperty(value="pfsDhGroup")
        private PfsDhGroup pfsDhGroup;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isCustomPhaseTwoConfig(Boolean isCustomPhaseTwoConfig) {
            this.isCustomPhaseTwoConfig = isCustomPhaseTwoConfig;
            this.__explicitlySet__.add("isCustomPhaseTwoConfig");
            return this;
        }

        public Builder authenticationAlgorithm(AuthenticationAlgorithm authenticationAlgorithm) {
            this.authenticationAlgorithm = authenticationAlgorithm;
            this.__explicitlySet__.add("authenticationAlgorithm");
            return this;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public Builder lifetimeInSeconds(Integer lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
            this.__explicitlySet__.add("lifetimeInSeconds");
            return this;
        }

        public Builder isPfsEnabled(Boolean isPfsEnabled) {
            this.isPfsEnabled = isPfsEnabled;
            this.__explicitlySet__.add("isPfsEnabled");
            return this;
        }

        public Builder pfsDhGroup(PfsDhGroup pfsDhGroup) {
            this.pfsDhGroup = pfsDhGroup;
            this.__explicitlySet__.add("pfsDhGroup");
            return this;
        }

        public PhaseTwoConfigDetails build() {
            PhaseTwoConfigDetails model = new PhaseTwoConfigDetails(this.isCustomPhaseTwoConfig, this.authenticationAlgorithm, this.encryptionAlgorithm, this.lifetimeInSeconds, this.isPfsEnabled, this.pfsDhGroup);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PhaseTwoConfigDetails model) {
            if (model.wasPropertyExplicitlySet("isCustomPhaseTwoConfig")) {
                this.isCustomPhaseTwoConfig(model.getIsCustomPhaseTwoConfig());
            }
            if (model.wasPropertyExplicitlySet("authenticationAlgorithm")) {
                this.authenticationAlgorithm(model.getAuthenticationAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("encryptionAlgorithm")) {
                this.encryptionAlgorithm(model.getEncryptionAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("lifetimeInSeconds")) {
                this.lifetimeInSeconds(model.getLifetimeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("isPfsEnabled")) {
                this.isPfsEnabled(model.getIsPfsEnabled());
            }
            if (model.wasPropertyExplicitlySet("pfsDhGroup")) {
                this.pfsDhGroup(model.getPfsDhGroup());
            }
            return this;
        }
    }
}

