/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.checkoutstep.CheckoutStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutWizard
implements ChangeListener {
    private WizardDescriptor.Panel[] panels;
    private RepositoryStep repositoryStep;
    private CheckoutStep checkoutStep;
    private AbstractStep.WizardMessage errorMessage;
    private WizardDescriptor wizardDescriptor;
    private PanelsIterator wizardIterator;

    public boolean show() {
        boolean finnished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CheckoutWizard.class, (String)"CTL_Checkout"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CheckoutWizard.class, (String)"CTL_Checkout"));
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finnished = value == WizardDescriptor.FINISH_OPTION;
        if (finnished) {
            this.onFinished();
        } else if (value == WizardDescriptor.CLOSED_OPTION || value == WizardDescriptor.CANCEL_OPTION) {
            this.repositoryStep.stop();
        }
        return finnished;
    }

    private void onFinished() {
        String checkout = this.checkoutStep.getWorkdir().getPath();
        SvnModuleConfig.getDefault().getPreferences().put("checkoutStep.checkoutDirectory", checkout);
    }

    private void setErrorMessage(AbstractStep.WizardMessage msg) {
        this.errorMessage = msg;
        if (this.wizardDescriptor != null) {
            if (this.errorMessage != null) {
                if (this.errorMessage.isInfo()) {
                    this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)this.errorMessage.getMessage());
                } else {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.errorMessage.getMessage());
                }
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.wizardIterator == null) {
            return;
        }
        AbstractStep step = (AbstractStep)this.wizardIterator.current();
        if (step == null) {
            return;
        }
        this.setErrorMessage(step.getErrorMessage());
    }

    public RepositoryFile[] getRepositoryFiles() {
        return this.checkoutStep.getRepositoryFiles();
    }

    public File getWorkdir() {
        return this.checkoutStep.getWorkdir();
    }

    public SVNUrl getRepositoryRoot() {
        return this.repositoryStep.getRepositoryFile().getRepositoryUrl();
    }

    public boolean isAtWorkingDirLevel() {
        return this.checkoutStep.isAtWorkingDirLevel();
    }

    public boolean isExport() {
        return this.checkoutStep.isExport();
    }

    public boolean isOldFormatPreferred() {
        return this.checkoutStep.isOldFormatPreferred();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[3];
            CheckoutWizard.this.repositoryStep = new RepositoryStep(8, "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.checkout");
            CheckoutWizard.this.repositoryStep.addChangeListener(CheckoutWizard.this);
            CheckoutWizard.this.checkoutStep = new CheckoutStep();
            CheckoutWizard.this.checkoutStep.addChangeListener(CheckoutWizard.this);
            panels = new WizardDescriptor.Panel[]{CheckoutWizard.this.repositoryStep, CheckoutWizard.this.checkoutStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public void nextPanel() {
            if (this.current() == CheckoutWizard.this.repositoryStep) {
                CheckoutWizard.this.checkoutStep.setup(CheckoutWizard.this.repositoryStep.getRepositoryFile());
            }
            super.nextPanel();
        }
    }
}

