/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class ContextAction
extends NodeAction {
    private static final Logger LOG = Logger.getLogger(ContextAction.class.getName());

    protected ContextAction() {
        this(null);
    }

    protected ContextAction(String iconResource) {
        if (iconResource == null) {
            this.setIcon(null);
            this.putValue("noIconInMenu", Boolean.TRUE);
        } else {
            this.setIcon(ImageUtilities.loadImageIcon((String)iconResource, (boolean)true));
        }
    }

    protected abstract String getBaseName(Node[] var1);

    protected boolean enable(Node[] nodes) {
        if (this.isCacheReady()) {
            File[] rootFiles = this.getCachedContext(nodes).getRootFiles();
            return rootFiles.length > 0 && SvnUtils.isManaged(rootFiles[0]);
        }
        LOG.log(Level.FINE, "Svn cache not yet ready, setting the action {0} disabled", ((Object)((Object)this)).getClass().getName());
        return false;
    }

    protected void performAction(Node[] nodes) {
        LifecycleManager.getDefault().saveAll();
        Utils.logVCSActionEvent((String)"SVN");
        this.performContextAction(nodes);
    }

    protected SVNUrl getSvnUrl(Node[] nodes) throws SVNClientException {
        return ContextAction.getSvnUrl(this.getContext(nodes));
    }

    public static SVNUrl getSvnUrl(Context ctx) throws SVNClientException {
        File[] roots = ctx.getRootFiles();
        return roots.length == 0 ? null : SvnUtils.getRepositoryRootUrl(roots[0]);
    }

    protected abstract void performContextAction(Node[] var1);

    protected final boolean isCacheReady() {
        return Subversion.getInstance().getStatusCache().ready();
    }

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public final void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
    }

    public final void performAction() {
        super.performAction();
    }

    public String getRunningName(Node[] activatedNodes) {
        return this.getName("Running", activatedNodes);
    }

    public String getName() {
        return this.getName("", TopComponent.getRegistry().getActivatedNodes());
    }

    public String getName(String role, Node[] activatedNodes) {
        String baseName = this.getBaseName(activatedNodes) + role;
        if (!this.isEnabled()) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName);
        }
        File[] nodes = this.getCachedContext(activatedNodes).getFiles();
        int objectCount = nodes.length;
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName);
        }
        if (objectCount == 1) {
            String name;
            if (projectsOnly) {
                String dispName = ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(baseName + "_Context"), (Object)dispName);
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                name = fo.getNameExt();
            } else {
                DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
                if (dao instanceof DataShadow) {
                    dao = ((DataShadow)dao).getOriginal();
                }
                name = dao != null ? dao.getPrimaryFile().getNameExt() : activatedNodes[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName + "_Context"), name);
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName + "_Projects"), objectCount);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName + "_Context_Multiple"), objectCount);
    }

    public String getContextDisplayName(Node[] activatedNodes) {
        File[] nodes = this.getCachedContext(activatedNodes).getFiles();
        int objectCount = nodes.length;
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return null;
        }
        if (objectCount == 1) {
            if (projectsOnly) {
                return ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                return fo.getNameExt();
            }
            DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            if (dao instanceof DataShadow) {
                dao = ((DataShadow)dao).getOriginal();
            }
            if (dao != null) {
                return dao.getPrimaryFile().getNameExt();
            }
            return activatedNodes[0].getDisplayName();
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle(ContextAction.class).getString("MSG_ActionContext_MultipleProjects"), objectCount);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(ContextAction.class).getString("MSG_ActionContext_MultipleFiles"), objectCount);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected Context getCachedContext(Node[] nodes) {
        return SvnUtils.getCurrentContext(nodes, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), true);
    }

    protected Context getContext(Node[] nodes) {
        return SvnUtils.getCurrentContext(nodes, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), false);
    }

    protected int getFileEnabledStatus() {
        return -1;
    }

    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected RequestProcessor createRequestProcessor(Context ctx) {
        SVNUrl repository = null;
        try {
            repository = ContextAction.getSvnUrl(ctx);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
        }
        return Subversion.getInstance().getRequestProcessor(repository);
    }

    protected RequestProcessor createRequestProcessor(Node[] nodes) {
        SVNUrl repository = null;
        try {
            repository = this.getSvnUrl(nodes);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
        }
        return Subversion.getInstance().getRequestProcessor(repository);
    }

    protected static abstract class ProgressSupport
    extends SvnProgressSupport {
        private final ContextAction action;
        private final Node[] nodes;
        private long progressStamp;
        private String runningName;
        private final Context ctx;

        public ProgressSupport(ContextAction action, Node[] nodes) {
            this(action, nodes, null);
        }

        public ProgressSupport(ContextAction action, Node[] nodes, Context ctx) {
            this.action = action;
            this.nodes = nodes;
            this.ctx = ctx;
        }

        public RequestProcessor.Task start(RequestProcessor rp) {
            this.runningName = ActionUtils.cutAmpersand(this.action.getRunningName(this.nodes));
            SVNUrl url = null;
            try {
                Context actionContext;
                Context context = actionContext = this.ctx == null ? this.action.getContext(this.nodes) : this.ctx;
                if (actionContext.getRootFiles().length == 0) {
                    LOG.log(Level.INFO, "Running a task with an empty context.");
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Running a task with an empty context.", new Exception());
                    }
                }
                url = ContextAction.getSvnUrl(actionContext);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
            return this.start(rp, url, this.runningName);
        }

        @Override
        public abstract void perform();

        @Override
        protected void startProgress() {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.runningName);
            ProgressHandle progress = this.getProgressHandle();
            progress.setInitialDelay(500);
            this.progressStamp = System.currentTimeMillis() + 500L;
            progress.start();
        }

        @Override
        protected void finnishProgress() {
            if (this.isCanceled()) {
                this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.runningName + " " + NbBundle.getMessage(ContextAction.class, (String)"MSG_Progress_Canceled"));
            } else {
                final ProgressHandle progress = this.getProgressHandle();
                progress.switchToDeterminate(100);
                progress.progress(NbBundle.getMessage(ContextAction.class, (String)"MSG_Progress_Done"), 100);
                if (System.currentTimeMillis() > this.progressStamp) {
                    Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){
                        final /* synthetic */ ProgressSupport this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            progress.finish();
                        }
                    }, 15000);
                } else {
                    progress.finish();
                }
                this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.runningName + " " + NbBundle.getMessage(ContextAction.class, (String)"MSG_Progress_Finished"));
            }
        }
    }
}

