/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui;

import java.io.StringWriter;

public class JsonFormattingWriter
extends StringWriter {
    private int indent = 0;
    private final int indentationWidth;

    public JsonFormattingWriter(int indentationWidth) {
        this.indentationWidth = indentationWidth;
    }

    @Override
    public void write(int c) {
        switch ((char)c) {
            case '[': 
            case '{': {
                super.write(c);
                super.write(10);
                ++this.indent;
                this.writeIndentation();
                break;
            }
            case ',': {
                super.write(c);
                super.write(10);
                this.writeIndentation();
                break;
            }
            case ']': 
            case '}': {
                super.write(10);
                --this.indent;
                this.writeIndentation();
                super.write(c);
                break;
            }
            default: {
                super.write(c);
            }
        }
    }

    private void writeIndentation() {
        for (int i = 0; i < this.indent; ++i) {
            for (int j = 0; j < this.indentationWidth; ++j) {
                super.write(32);
            }
        }
    }
}

