/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.netbeans.modules.java.testrunner.ui.api.NodeOpener;
import org.netbeans.modules.java.testrunner.ui.api.UIJavaUtils;
import org.netbeans.modules.testng.api.TestNGTestSuite;
import org.netbeans.modules.testng.ui.TestNGMethodNode;
import org.netbeans.modules.testng.ui.XmlSuiteHandler;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class TestNGNodeOpener
extends NodeOpener {
    private static final Logger LOGGER = Logger.getLogger(TestNGNodeOpener.class.getName());
    static final Action[] NO_ACTIONS = new Action[0];

    public void openTestsuite(TestsuiteNode node) {
        FileObject fo;
        TestSuite suite = node.getSuite();
        if (suite instanceof TestSuite && (fo = ((TestNGTestSuite)suite).getSuiteFO()) != null) {
            int[] location = XmlSuiteHandler.getSuiteLocation(fo, suite.getName());
            UIJavaUtils.openFile((FileObject)fo, (int)location[0], (int)location[1]);
        }
    }

    public void openTestMethod(final TestMethodNode node) {
        if (!(node instanceof TestNGMethodNode)) {
            return;
        }
        final FileObject fo = ((TestNGMethodNode)node).getTestcase().getClassFileObject();
        if (fo != null) {
            final long[] line = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){
                        final /* synthetic */ TestNGNodeOpener this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                            block0: for (Tree tree : typeDecls) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                                List<ExecutableElement> methodElements = ElementFilter.methodsIn(element.getEnclosedElements());
                                for (Element element2 : methodElements) {
                                    if (!element2.getSimpleName().contentEquals(((TestNGMethodNode)node).getTestcase().getTestName())) continue;
                                    long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree(element2));
                                    line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                    break block0;
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
            }
            UIJavaUtils.openFile((FileObject)fo, (int)((int)line[0]));
        }
    }

    public void openCallstackFrame(Node node, String frameInfo) {
        String[] st;
        if (!(node instanceof TestNGMethodNode)) {
            return;
        }
        TestNGMethodNode methodNode = (TestNGMethodNode)UIJavaUtils.getTestMethodNode((Node)node);
        LineConvertors.FileLocator locator = methodNode.getTestcase().getSession().getFileLocator();
        if (locator == null) {
            return;
        }
        int[] lineNumStorage = new int[1];
        FileObject file = UIJavaUtils.getFile((String)frameInfo, (int[])lineNumStorage, (LineConvertors.FileLocator)locator);
        if (file == null && methodNode.getTestcase().getTrouble() != null && (st = methodNode.getTestcase().getTrouble().getStackTrace()) != null && st.length > 0) {
            file = UIJavaUtils.getFile((String)st[st.length - 1], (int[])lineNumStorage, (LineConvertors.FileLocator)locator);
        }
        UIJavaUtils.openFile((FileObject)file, (int)lineNumStorage[0]);
    }
}

