/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

public class TaskPaneAddon
extends AbstractComponentAddon {
    public TaskPaneAddon() {
        super("JXTaskPane");
    }

    @Override
    protected void addBasicDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        Font font = UIManagerExt.getSafeFont("Label.font", new Font("Dialog", 0, 12));
        font = font.deriveFont(1);
        ColorUIResource colorUIResource = new ColorUIResource(SystemColor.menu);
        defaultsList.add("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI");
        defaultsList.add("TaskPane.font", new FontUIResource(font));
        defaultsList.add("TaskPane.background", UIManagerExt.getSafeColor("List.background", new ColorUIResource(Color.decode("#005C5C"))));
        defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(colorUIResource.darker()));
        defaultsList.add("TaskPane.titleBackgroundGradientStart", colorUIResource);
        defaultsList.add("TaskPane.titleBackgroundGradientEnd", colorUIResource);
        defaultsList.add("TaskPane.titleForeground", new ColorUIResource(SystemColor.menuText));
        defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(SystemColor.menuText.brighter()));
        defaultsList.add("TaskPane.animate", Boolean.TRUE);
        defaultsList.add("TaskPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "toggleExpanded", "SPACE", "toggleExpanded"}));
    }

    @Override
    protected void addLinuxDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        this.addMetalDefaults(lookAndFeelAddons, defaultsList);
    }

    @Override
    protected void addMetalDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addMetalDefaults(lookAndFeelAddons, defaultsList);
        if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
            defaultsList.add("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.misc.GlossyTaskPaneUI");
        } else {
            defaultsList.add("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.metal.MetalTaskPaneUI");
        }
        defaultsList.add("TaskPane.foreground", UIManager.getColor("activeCaptionText"));
        defaultsList.add("TaskPane.background", MetalLookAndFeel.getControl());
        defaultsList.add("TaskPane.specialTitleBackground", MetalLookAndFeel.getPrimaryControl());
        defaultsList.add("TaskPane.titleBackgroundGradientStart", MetalLookAndFeel.getPrimaryControl());
        defaultsList.add("TaskPane.titleBackgroundGradientEnd", MetalLookAndFeel.getPrimaryControlHighlight());
        defaultsList.add("TaskPane.titleForeground", MetalLookAndFeel.getControlTextColor());
        defaultsList.add("TaskPane.specialTitleForeground", MetalLookAndFeel.getControlTextColor());
        defaultsList.add("TaskPane.borderColor", MetalLookAndFeel.getPrimaryControl());
        defaultsList.add("TaskPane.titleOver", new ColorUIResource(MetalLookAndFeel.getControl().darker()));
        defaultsList.add("TaskPane.specialTitleOver", MetalLookAndFeel.getPrimaryControlHighlight());
    }

    @Override
    protected void addWindowsDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addWindowsDefaults(lookAndFeelAddons, defaultsList);
        if (lookAndFeelAddons instanceof WindowsLookAndFeelAddons) {
            defaultsList.add("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.windows.WindowsTaskPaneUI");
            String string = OS.getWindowsVisualStyle();
            if ("HomeStead".equalsIgnoreCase(string)) {
                defaultsList.add("TaskPane.foreground", new ColorUIResource(86, 102, 45));
                defaultsList.add("TaskPane.background", new ColorUIResource(246, 246, 236));
                defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(224, 231, 184));
                defaultsList.add("TaskPane.titleBackgroundGradientStart", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(224, 231, 184));
                defaultsList.add("TaskPane.titleForeground", new ColorUIResource(86, 102, 45));
                defaultsList.add("TaskPane.titleOver", new ColorUIResource(114, 146, 29));
                defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(86, 102, 45));
                defaultsList.add("TaskPane.specialTitleOver", new ColorUIResource(114, 146, 29));
                defaultsList.add("TaskPane.borderColor", new ColorUIResource(Color.WHITE));
            } else if ("Metallic".equalsIgnoreCase(string)) {
                defaultsList.add("TaskPane.foreground", new ColorUIResource(Color.BLACK));
                defaultsList.add("TaskPane.background", new ColorUIResource(240, 241, 245));
                defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(222, 222, 222));
                defaultsList.add("TaskPane.titleBackgroundGradientStart", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(214, 215, 224));
                defaultsList.add("TaskPane.titleForeground", new ColorUIResource(Color.BLACK));
                defaultsList.add("TaskPane.titleOver", new ColorUIResource(126, 124, 124));
                defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(Color.BLACK));
                defaultsList.add("TaskPane.specialTitleOver", new ColorUIResource(126, 124, 124));
                defaultsList.add("TaskPane.borderColor", new ColorUIResource(Color.WHITE));
            } else if (OS.isWindowsVista()) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                defaultsList.add("TaskPane.foreground", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.background", new ColorUIResource((Color)toolkit.getDesktopProperty("win.3d.backgroundColor")));
                defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(33, 89, 201));
                defaultsList.add("TaskPane.titleBackgroundGradientStart", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.titleBackgroundGradientEnd", new ColorUIResource((Color)toolkit.getDesktopProperty("win.frame.inactiveCaptionColor")));
                defaultsList.add("TaskPane.titleForeground", new ColorUIResource((Color)toolkit.getDesktopProperty("win.frame.inactiveCaptionTextColor")));
                defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.borderColor", new ColorUIResource(Color.WHITE));
            } else {
                defaultsList.add("TaskPane.foreground", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.background", new ColorUIResource(214, 223, 247));
                defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(33, 89, 201));
                defaultsList.add("TaskPane.titleBackgroundGradientStart", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(199, 212, 247));
                defaultsList.add("TaskPane.titleForeground", new ColorUIResource(33, 89, 201));
                defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(Color.WHITE));
                defaultsList.add("TaskPane.borderColor", new ColorUIResource(Color.WHITE));
            }
        }
        if (lookAndFeelAddons instanceof WindowsClassicLookAndFeelAddons) {
            defaultsList.add("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.windows.WindowsClassicTaskPaneUI");
            defaultsList.add("TaskPane.foreground", new ColorUIResource(Color.BLACK));
            defaultsList.add("TaskPane.background", new ColorUIResource(Color.WHITE));
            defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(10, 36, 106));
            defaultsList.add("TaskPane.titleBackgroundGradientStart", new ColorUIResource(212, 208, 200));
            defaultsList.add("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(212, 208, 200));
            defaultsList.add("TaskPane.titleForeground", new ColorUIResource(Color.BLACK));
            defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(Color.WHITE));
            defaultsList.add("TaskPane.borderColor", new ColorUIResource(212, 208, 200));
        }
    }

    @Override
    protected void addMacDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addMacDefaults(lookAndFeelAddons, defaultsList);
        defaultsList.add("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.misc.GlossyTaskPaneUI");
        defaultsList.add("TaskPane.background", new ColorUIResource(245, 245, 245));
        defaultsList.add("TaskPane.titleForeground", new ColorUIResource(Color.BLACK));
        defaultsList.add("TaskPane.specialTitleBackground", new ColorUIResource(188, 188, 188));
        defaultsList.add("TaskPane.specialTitleForeground", new ColorUIResource(Color.BLACK));
        defaultsList.add("TaskPane.titleBackgroundGradientStart", new ColorUIResource(250, 250, 250));
        defaultsList.add("TaskPane.titleBackgroundGradientEnd", new ColorUIResource(188, 188, 188));
        defaultsList.add("TaskPane.borderColor", new ColorUIResource(97, 97, 97));
        defaultsList.add("TaskPane.titleOver", new ColorUIResource(125, 125, 97));
        defaultsList.add("TaskPane.specialTitleOver", new ColorUIResource(125, 125, 97));
    }
}

