/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.pagination.ColorProfile;
import org.apache.fop.fo.pagination.Declarations;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.ColorUtil;

class RGBICCColorFunction
extends FunctionBase {
    private int colors = 3;

    public RGBICCColorFunction(boolean fox) {
        if (fox) {
            this.colors = 4;
        }
    }

    @Override
    public int getRequiredArgsCount() {
        return 4;
    }

    @Override
    public boolean hasVariableArgs() {
        return true;
    }

    @Override
    public PercentBase getPercentBase() {
        return new ICCPercentBase();
    }

    @Override
    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        String colorProfileName = args[this.colors].getString();
        if (this.colors == 4 && colorProfileName == null) {
            throw new PropertyException("Alpha channel value missing");
        }
        Declarations decls = pInfo.getFO().getRoot().getDeclarations();
        ColorProfile cp = null;
        if (decls == null) {
            if (!ColorUtil.isPseudoProfile(colorProfileName)) {
                Property[] rgbArgs = new Property[3];
                System.arraycopy(args, 0, rgbArgs, 0, 3);
                return new RGBColorFunction().eval(rgbArgs, pInfo);
            }
        } else {
            cp = decls.getColorProfile(colorProfileName);
            if (cp == null && !ColorUtil.isPseudoProfile(colorProfileName)) {
                PropertyException pe = new PropertyException("The " + colorProfileName + " color profile was not declared");
                pe.setPropertyInfo(pInfo);
                throw pe;
            }
        }
        String src = cp != null ? cp.getSrc() : "";
        float red = args[0].getNumber().floatValue();
        float green = args[1].getNumber().floatValue();
        float blue = args[2].getNumber().floatValue();
        float alpha = 255.0f;
        if (this.colors == 4) {
            alpha = args[3].getNumber().floatValue();
        }
        if (red < 0.0f || red > 255.0f || green < 0.0f || green > 255.0f || blue < 0.0f || blue > 255.0f) {
            throw new PropertyException("Color values out of range. Arguments to rgb-icc() must be [0..255] or [0%..100%]");
        }
        StringBuilder sb = new StringBuilder("fop-rgb-icc(");
        sb.append(red / 255.0f);
        sb.append(',').append(green / 255.0f);
        sb.append(',').append(blue / 255.0f);
        if (this.colors == 4) {
            sb.append(",#alpha,").append(alpha / 255.0f);
        }
        for (int i = this.colors; i < args.length; ++i) {
            if (i == this.colors) {
                sb.append(',').append(colorProfileName);
                sb.append(',').append(src);
                continue;
            }
            sb.append(',').append(args[i]);
        }
        sb.append(")");
        return ColorProperty.getInstance(pInfo.getUserAgent(), sb.toString());
    }

    private static final class ICCPercentBase
    implements PercentBase {
        private ICCPercentBase() {
        }

        @Override
        public int getBaseLength(PercentBaseContext context) throws PropertyException {
            return 0;
        }

        @Override
        public double getBaseValue() {
            return 255.0;
        }

        @Override
        public int getDimension() {
            return 0;
        }
    }
}

