/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MavenMetadataCache.class)
public class DefaultMavenMetadataCache
implements MavenMetadataCache {
    protected final Map<CacheKey, CacheRecord> cache = new ConcurrentHashMap<CacheKey, CacheRecord>();

    private static int artifactHashCode(Artifact a) {
        int result = 17;
        result = 31 * result + a.getGroupId().hashCode();
        result = 31 * result + a.getArtifactId().hashCode();
        result = 31 * result + a.getType().hashCode();
        if (a.getVersion() != null) {
            result = 31 * result + a.getVersion().hashCode();
        }
        result = 31 * result + (a.getClassifier() != null ? a.getClassifier().hashCode() : 0);
        result = 31 * result + (a.getScope() != null ? a.getScope().hashCode() : 0);
        result = 31 * result + (a.getDependencyFilter() != null ? a.getDependencyFilter().hashCode() : 0);
        result = 31 * result + (a.isOptional() ? 1 : 0);
        return result;
    }

    private static boolean artifactEquals(Artifact a1, Artifact a2) {
        if (a1 == a2) {
            return true;
        }
        return Objects.equals(a1.getGroupId(), a2.getGroupId()) && Objects.equals(a1.getArtifactId(), a2.getArtifactId()) && Objects.equals(a1.getType(), a2.getType()) && Objects.equals(a1.getVersion(), a2.getVersion()) && Objects.equals(a1.getClassifier(), a2.getClassifier()) && Objects.equals(a1.getScope(), a2.getScope()) && Objects.equals(a1.getDependencyFilter(), a2.getDependencyFilter()) && a1.isOptional() == a2.isOptional();
    }

    private static int repositoryHashCode(ArtifactRepository repository) {
        int result = 17;
        result = 31 * result + (repository.getId() != null ? repository.getId().hashCode() : 0);
        return result;
    }

    private static int repositoriesHashCode(List<ArtifactRepository> repositories) {
        int result = 17;
        for (ArtifactRepository repository : repositories) {
            result = 31 * result + DefaultMavenMetadataCache.repositoryHashCode(repository);
        }
        return result;
    }

    private static boolean repositoryEquals(ArtifactRepository r1, ArtifactRepository r2) {
        if (r1 == r2) {
            return true;
        }
        return Objects.equals(r1.getId(), r2.getId()) && Objects.equals(r1.getUrl(), r2.getUrl()) && DefaultMavenMetadataCache.repositoryPolicyEquals(r1.getReleases(), r2.getReleases()) && DefaultMavenMetadataCache.repositoryPolicyEquals(r1.getSnapshots(), r2.getSnapshots());
    }

    private static boolean repositoryPolicyEquals(ArtifactRepositoryPolicy p1, ArtifactRepositoryPolicy p2) {
        if (p1 == p2) {
            return true;
        }
        return p1.isEnabled() == p2.isEnabled() && Objects.equals(p1.getUpdatePolicy(), p2.getUpdatePolicy());
    }

    private static boolean repositoriesEquals(List<ArtifactRepository> r1, List<ArtifactRepository> r2) {
        if (r1.size() != r2.size()) {
            return false;
        }
        Iterator<ArtifactRepository> it1 = r1.iterator();
        Iterator<ArtifactRepository> it2 = r2.iterator();
        while (it1.hasNext()) {
            if (DefaultMavenMetadataCache.repositoryEquals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResolutionGroup get(Artifact artifact, boolean resolveManagedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        CacheKey cacheKey = this.newCacheKey(artifact, resolveManagedVersions, localRepository, remoteRepositories);
        CacheRecord cacheRecord = this.cache.get(cacheKey);
        if (cacheRecord != null && !cacheRecord.isStale()) {
            Artifact pomArtifact = ArtifactUtils.copyArtifact(cacheRecord.getArtifact());
            Artifact relocatedArtifact = ArtifactUtils.copyArtifactSafe(cacheRecord.getRelocatedArtifact());
            Set artifacts = ArtifactUtils.copyArtifacts(cacheRecord.getArtifacts(), new LinkedHashSet());
            Map<String, Artifact> managedVersions = cacheRecord.getManagedVersions();
            if (managedVersions != null) {
                managedVersions = ArtifactUtils.copyArtifacts(managedVersions, new LinkedHashMap());
            }
            return new ResolutionGroup(pomArtifact, relocatedArtifact, artifacts, managedVersions, cacheRecord.getRemoteRepositories());
        }
        this.cache.remove(cacheKey);
        return null;
    }

    @Override
    public void put(Artifact artifact, boolean resolveManagedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ResolutionGroup result) {
        this.put(this.newCacheKey(artifact, resolveManagedVersions, localRepository, remoteRepositories), result);
    }

    protected CacheKey newCacheKey(Artifact artifact, boolean resolveManagedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        return new CacheKey(artifact, resolveManagedVersions, localRepository, remoteRepositories);
    }

    protected void put(CacheKey cacheKey, ResolutionGroup result) {
        CacheRecord cacheRecord = new CacheRecord(result.getPomArtifact(), result.getRelocatedArtifact(), result.getArtifacts(), result.getManagedVersions(), result.getResolutionRepositories());
        this.cache.put(cacheKey, cacheRecord);
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    public class CacheRecord {
        private Artifact pomArtifact;
        private Artifact relocatedArtifact;
        private List<Artifact> artifacts;
        private Map<String, Artifact> managedVersions;
        private List<ArtifactRepository> remoteRepositories;
        private long length;
        private long timestamp;

        CacheRecord(Artifact pomArtifact, Artifact relocatedArtifact, Set<Artifact> artifacts, Map<String, Artifact> managedVersions, List<ArtifactRepository> remoteRepositories) {
            File pomFile;
            this.pomArtifact = ArtifactUtils.copyArtifact(pomArtifact);
            this.relocatedArtifact = ArtifactUtils.copyArtifactSafe(relocatedArtifact);
            this.artifacts = ArtifactUtils.copyArtifacts(artifacts, new ArrayList());
            this.remoteRepositories = new ArrayList<ArtifactRepository>(remoteRepositories);
            this.managedVersions = managedVersions;
            if (managedVersions != null) {
                this.managedVersions = ArtifactUtils.copyArtifacts(managedVersions, new LinkedHashMap());
            }
            if ((pomFile = pomArtifact.getFile()) != null && pomFile.canRead()) {
                this.length = pomFile.length();
                this.timestamp = pomFile.lastModified();
            } else {
                this.length = -1L;
                this.timestamp = -1L;
            }
        }

        public Artifact getArtifact() {
            return this.pomArtifact;
        }

        public Artifact getRelocatedArtifact() {
            return this.relocatedArtifact;
        }

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }

        public Map<String, Artifact> getManagedVersions() {
            return this.managedVersions;
        }

        public List<ArtifactRepository> getRemoteRepositories() {
            return this.remoteRepositories;
        }

        public boolean isStale() {
            File pomFile = this.pomArtifact.getFile();
            if (pomFile != null) {
                if (pomFile.canRead()) {
                    return this.length != pomFile.length() || this.timestamp != pomFile.lastModified();
                }
                boolean snapshot2 = this.pomArtifact.isSnapshot();
                for (ArtifactRepository repository : this.remoteRepositories) {
                    ArtifactRepositoryPolicy policy = snapshot2 ? repository.getSnapshots() : repository.getReleases();
                    if (!"always".equals(policy.getUpdatePolicy())) continue;
                    return true;
                }
            }
            return this.length != -1L || this.timestamp != -1L;
        }
    }

    public static class CacheKey {
        private final Artifact artifact;
        private final long pomHash;
        private final boolean resolveManagedVersions;
        private final List<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        private final int hashCode;

        public CacheKey(Artifact artifact, boolean resolveManagedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
            File file2 = artifact.getFile();
            this.artifact = ArtifactUtils.copyArtifact(artifact);
            this.pomHash = "pom".equals(artifact.getType()) && file2 != null ? (long)file2.getPath().hashCode() + file2.lastModified() : 0L;
            this.resolveManagedVersions = resolveManagedVersions;
            this.repositories.add(localRepository);
            this.repositories.addAll(remoteRepositories);
            int hash2 = 17;
            hash2 = hash2 * 31 + DefaultMavenMetadataCache.artifactHashCode(artifact);
            hash2 = hash2 * 31 + (resolveManagedVersions ? 1 : 2);
            this.hashCode = hash2 = hash2 * 31 + DefaultMavenMetadataCache.repositoriesHashCode(this.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.pomHash == other.pomHash && DefaultMavenMetadataCache.artifactEquals(this.artifact, other.artifact) && this.resolveManagedVersions == other.resolveManagedVersions && DefaultMavenMetadataCache.repositoriesEquals(this.repositories, other.repositories);
        }
    }
}

