﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticache/ElastiCacheRequest.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ElastiCache {
namespace Model {

/**
 */
class DisassociateGlobalReplicationGroupRequest : public ElastiCacheRequest {
 public:
  AWS_ELASTICACHE_API DisassociateGlobalReplicationGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DisassociateGlobalReplicationGroup"; }

  AWS_ELASTICACHE_API Aws::String SerializePayload() const override;

 protected:
  AWS_ELASTICACHE_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The name of the Global datastore</p>
   */
  inline const Aws::String& GetGlobalReplicationGroupId() const { return m_globalReplicationGroupId; }
  inline bool GlobalReplicationGroupIdHasBeenSet() const { return m_globalReplicationGroupIdHasBeenSet; }
  template <typename GlobalReplicationGroupIdT = Aws::String>
  void SetGlobalReplicationGroupId(GlobalReplicationGroupIdT&& value) {
    m_globalReplicationGroupIdHasBeenSet = true;
    m_globalReplicationGroupId = std::forward<GlobalReplicationGroupIdT>(value);
  }
  template <typename GlobalReplicationGroupIdT = Aws::String>
  DisassociateGlobalReplicationGroupRequest& WithGlobalReplicationGroupId(GlobalReplicationGroupIdT&& value) {
    SetGlobalReplicationGroupId(std::forward<GlobalReplicationGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the secondary cluster you wish to remove from the Global
   * datastore</p>
   */
  inline const Aws::String& GetReplicationGroupId() const { return m_replicationGroupId; }
  inline bool ReplicationGroupIdHasBeenSet() const { return m_replicationGroupIdHasBeenSet; }
  template <typename ReplicationGroupIdT = Aws::String>
  void SetReplicationGroupId(ReplicationGroupIdT&& value) {
    m_replicationGroupIdHasBeenSet = true;
    m_replicationGroupId = std::forward<ReplicationGroupIdT>(value);
  }
  template <typename ReplicationGroupIdT = Aws::String>
  DisassociateGlobalReplicationGroupRequest& WithReplicationGroupId(ReplicationGroupIdT&& value) {
    SetReplicationGroupId(std::forward<ReplicationGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon region of secondary cluster you wish to remove from the Global
   * datastore</p>
   */
  inline const Aws::String& GetReplicationGroupRegion() const { return m_replicationGroupRegion; }
  inline bool ReplicationGroupRegionHasBeenSet() const { return m_replicationGroupRegionHasBeenSet; }
  template <typename ReplicationGroupRegionT = Aws::String>
  void SetReplicationGroupRegion(ReplicationGroupRegionT&& value) {
    m_replicationGroupRegionHasBeenSet = true;
    m_replicationGroupRegion = std::forward<ReplicationGroupRegionT>(value);
  }
  template <typename ReplicationGroupRegionT = Aws::String>
  DisassociateGlobalReplicationGroupRequest& WithReplicationGroupRegion(ReplicationGroupRegionT&& value) {
    SetReplicationGroupRegion(std::forward<ReplicationGroupRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_globalReplicationGroupId;

  Aws::String m_replicationGroupId;

  Aws::String m_replicationGroupRegion;
  bool m_globalReplicationGroupIdHasBeenSet = false;
  bool m_replicationGroupIdHasBeenSet = false;
  bool m_replicationGroupRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElastiCache
}  // namespace Aws
