/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime.rtti;

import java.util.Objects;
import org.apache.calcite.runtime.rtti.RuntimeTypeInformation;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BasicSqlTypeRtti
extends RuntimeTypeInformation {
    public BasicSqlTypeRtti(RuntimeTypeInformation.RuntimeSqlTypeName typeName) {
        super(typeName);
        assert (typeName.isScalar()) : "Base SQL type must be a scalar type " + (Object)((Object)typeName);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSqlTypeRtti that = (BasicSqlTypeRtti)o;
        return this.typeName == that.typeName;
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.typeName);
    }

    @Override
    public String getTypeString() {
        switch (this.typeName) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case UTINYINT: {
                return "TINYINT UNSIGNED";
            }
            case USMALLINT: {
                return "SMALLINT UNSIGNED";
            }
            case UINTEGER: {
                return "INTEGER UNSIGNED";
            }
            case UBIGINT: {
                return "BIGINT UNSIGNED";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case REAL: {
                return "REAL";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return "TIME_WITH_LOCAL_TIME_ZONE";
            }
            case TIME_TZ: {
                return "TIME_WITH_TIME_ZONE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return "TIMESTAMP_WITH_LOCAL_TIME_ZONE";
            }
            case TIMESTAMP_TZ: {
                return "TIMESTAMP_WITH_TIME_ZONE";
            }
            case INTERVAL_LONG: 
            case INTERVAL_SHORT: {
                return "INTERVAL";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case VARBINARY: {
                return "VARBINARY";
            }
            case NULL: {
                return "NULL";
            }
            case GEOMETRY: {
                return "GEOMETRY";
            }
            case VARIANT: {
                return "VARIANT";
            }
        }
        throw new RuntimeException("Unexpected type " + (Object)((Object)this.typeName));
    }

    public String toString() {
        return "new BasicSqlTypeRtti(" + this.getTypeString() + ")";
    }
}

