/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.Multimap;
import java.util.function.Predicate;
import org.apache.calcite.plan.CommonRelExpressionRegistry;
import org.apache.calcite.plan.CommonRelSubExprRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableCommonRelSubExprRegisterRule;
import org.immutables.value.Value;

@Value.Enclosing
public final class CommonRelSubExprRegisterRule
extends CommonRelSubExprRule {
    private CommonRelSubExprRegisterRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        CommonRelExpressionRegistry r = call.getPlanner().getContext().unwrap(CommonRelExpressionRegistry.class);
        if (r != null) {
            r.add((RelNode)call.rel(0));
        }
    }

    @Value.Immutable
    public static interface Config
    extends CommonRelSubExprRule.Config {
        public static final Config JOIN = ImmutableCommonRelSubExprRegisterRule.Config.builder().withOperandSupplier(o -> o.operand(Join.class).predicate(j -> JoinRelType.INNER == j.getJoinType()).anyInputs()).build();
        public static final Config AGGREGATE = ImmutableCommonRelSubExprRegisterRule.Config.builder().withOperandSupplier(o -> o.operand(Aggregate.class).anyInputs()).build();
        public static final Config FILTER = ImmutableCommonRelSubExprRegisterRule.Config.builder().withOperandSupplier(o -> o.operand(Filter.class).anyInputs()).build();
        public static final Config PROJECT = ImmutableCommonRelSubExprRegisterRule.Config.builder().withOperandSupplier(o -> o.operand(Project.class).predicate(new InterestingRelNodePredicate()).anyInputs()).build();

        @Override
        default public CommonRelSubExprRegisterRule toRule() {
            return new CommonRelSubExprRegisterRule(this);
        }
    }

    private static final class InterestingRelNodePredicate
    implements Predicate<RelNode> {
        private InterestingRelNodePredicate() {
        }

        @Override
        public boolean test(RelNode rel) {
            RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
            Multimap<Class<? extends RelNode>, RelNode> types = mq.getNodeTypes(rel);
            if (types == null) {
                return false;
            }
            return types.keySet().stream().anyMatch(t -> Join.class.isAssignableFrom((Class<?>)t) || Aggregate.class.isAssignableFrom((Class<?>)t) || Filter.class.isAssignableFrom((Class<?>)t));
        }
    }
}

