/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtVisitor;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;

public class DefaultJwt<H extends Header, P>
implements Jwt<H, P> {
    private final H header;
    private final P payload;

    public DefaultJwt(H header, P payload) {
        this.header = (Header)Assert.notNull(header, (String)"header cannot be null.");
        this.payload = Assert.notNull(payload, (String)"payload cannot be null.");
    }

    public H getHeader() {
        return this.header;
    }

    public P getBody() {
        return this.getPayload();
    }

    public P getPayload() {
        return this.payload;
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("header=").append(this.header).append(",payload=");
        if (this.payload instanceof byte[]) {
            String encoded = (String)Encoders.BASE64URL.encode((Object)((byte[])this.payload));
            sb.append(encoded);
        } else {
            sb.append(this.payload);
        }
        return sb;
    }

    public final String toString() {
        return this.toStringBuilder().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Jwt) {
            Jwt jwt = (Jwt)obj;
            return Objects.nullSafeEquals(this.header, (Object)jwt.getHeader()) && Objects.nullSafeEquals(this.payload, (Object)jwt.getPayload());
        }
        return false;
    }

    public int hashCode() {
        return Objects.nullSafeHashCode((Object[])new Object[]{this.header, this.payload});
    }

    public <T> T accept(JwtVisitor<T> v) {
        return (T)v.visit((Jwt)this);
    }
}

