/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.file.collections.FailingFileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.scala.ScalaPluginExtension;
import org.gradle.api.tasks.scala.internal.ScalaRuntimeHelper;
import org.jspecify.annotations.Nullable;

public abstract class ScalaRuntime {
    private final Project project;
    private final JvmPluginServices jvmPluginServices;

    public ScalaRuntime(Project project) {
        this.project = project;
        this.jvmPluginServices = (JvmPluginServices)((ProjectInternal)project).getServices().get(JvmPluginServices.class);
    }

    public FileCollection inferScalaClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(((ProjectInternal)this.project).getTaskDependencyFactory()){

            public String getDisplayName() {
                return "Scala runtime classpath";
            }

            public FileCollection createDelegate() {
                try {
                    return this.inferScalaClasspath();
                }
                catch (RuntimeException e) {
                    return new FailingFileCollection(this.getDisplayName(), e);
                }
            }

            private Configuration inferScalaClasspath() {
                boolean isScala3;
                File scalaLibraryJar = ScalaRuntime.this.findScalaJar(classpath, "library");
                File scala3LibraryJar = ScalaRuntime.this.findScalaJar(classpath, "library_3");
                boolean bl = isScala3 = scala3LibraryJar != null;
                if (scalaLibraryJar == null && scala3LibraryJar == null) {
                    throw new GradleException(String.format("Cannot infer Scala class path because no Scala library Jar was found. Does %s declare dependency to scala-library? Searched classpath: %s.", ScalaRuntime.this.project, classpath));
                }
                String scalaVersion = isScala3 ? ScalaRuntime.this.getScalaVersion(scala3LibraryJar) : ScalaRuntime.this.getScalaVersion(scalaLibraryJar);
                if (scalaVersion == null) {
                    throw new AssertionError((Object)String.format("Unexpectedly failed to parse version of Scala Jar file: %s in %s", scalaLibraryJar, ScalaRuntime.this.project));
                }
                String zincVersion = (String)((ScalaPluginExtension)ScalaRuntime.this.project.getExtensions().getByType(ScalaPluginExtension.class)).getZincVersion().get();
                DefaultExternalModuleDependency compilerBridgeJar = ScalaRuntime.this.getScalaBridgeDependency(scalaVersion, zincVersion);
                compilerBridgeJar.setTransitive(false);
                compilerBridgeJar.artifact(artifact -> {
                    if (!isScala3) {
                        artifact.setClassifier("sources");
                    }
                    artifact.setType("jar");
                    artifact.setExtension("jar");
                    artifact.setName(compilerBridgeJar.getName());
                });
                DefaultExternalModuleDependency compilerInterfaceJar = ScalaRuntime.this.getScalaCompilerInterfaceDependency(scalaVersion, zincVersion);
                Configuration scalaRuntimeClasspath = isScala3 ? ScalaRuntime.this.project.getConfigurations().detachedConfiguration(new Dependency[]{ScalaRuntime.this.getScalaCompilerDependency(scalaVersion), compilerBridgeJar, compilerInterfaceJar, ScalaRuntime.this.getScaladocDependency(scalaVersion)}) : ScalaRuntime.this.project.getConfigurations().detachedConfiguration(new Dependency[]{ScalaRuntime.this.getScalaCompilerDependency(scalaVersion), compilerBridgeJar, compilerInterfaceJar});
                ScalaRuntime.this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)scalaRuntimeClasspath);
                return scalaRuntimeClasspath;
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add((Object)classpath);
                }
            }
        };
    }

    public @Nullable File findScalaJar(Iterable<File> classpath, String appendix) {
        return ScalaRuntimeHelper.findScalaJar(classpath, appendix);
    }

    public @Nullable String getScalaVersion(File scalaJar) {
        return ScalaRuntimeHelper.getScalaVersion(scalaJar);
    }

    private DefaultExternalModuleDependency getScalaBridgeDependency(String scalaVersion, String zincVersion) {
        if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
            return new DefaultExternalModuleDependency("org.scala-lang", "scala3-sbt-bridge", scalaVersion);
        }
        String scalaMajorMinorVersion = Joiner.on((char)'.').join(Splitter.on((char)'.').splitToList((CharSequence)scalaVersion).subList(0, 2));
        return new DefaultExternalModuleDependency("org.scala-sbt", "compiler-bridge_" + scalaMajorMinorVersion, zincVersion);
    }

    private DefaultExternalModuleDependency getScalaCompilerDependency(String scalaVersion) {
        if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
            return new DefaultExternalModuleDependency("org.scala-lang", "scala3-compiler_3", scalaVersion);
        }
        return new DefaultExternalModuleDependency("org.scala-lang", "scala-compiler", scalaVersion);
    }

    private DefaultExternalModuleDependency getScalaCompilerInterfaceDependency(String scalaVersion, String zincVersion) {
        if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
            return new DefaultExternalModuleDependency("org.scala-lang", "scala3-interfaces", scalaVersion);
        }
        return new DefaultExternalModuleDependency("org.scala-sbt", "compiler-interface", zincVersion);
    }

    private DefaultExternalModuleDependency getScaladocDependency(String scalaVersion) {
        if (scalaVersion.startsWith("3.")) {
            return new DefaultExternalModuleDependency("org.scala-lang", "scaladoc_3", scalaVersion);
        }
        return null;
    }
}

