/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.internal.tooling.EclipseModelBuilder;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultRunClosedProjectBuildDependencies;
import org.gradle.tooling.model.eclipse.EclipseRuntime;
import org.gradle.tooling.model.eclipse.EclipseWorkspaceProject;
import org.gradle.tooling.model.eclipse.RunClosedProjectBuildDependencies;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RunBuildDependenciesTaskBuilder
implements ParameterizedToolingModelBuilder<EclipseRuntime> {
    private Map<String, Boolean> projectOpenStatus;

    public Class<EclipseRuntime> getParameterType() {
        return EclipseRuntime.class;
    }

    public RunClosedProjectBuildDependencies buildAll(String modelName, EclipseRuntime eclipseRuntime, Project project) {
        this.projectOpenStatus = eclipseRuntime.getWorkspace().getProjects().stream().collect(Collectors.toMap(EclipseWorkspaceProject::getName, EclipseModelBuilder::isProjectOpen, (a, b) -> a != false || b != false));
        ProjectState rootProjectState = ((ProjectInternal)project.getRootProject()).getOwner();
        List<TaskDependency> buildDependencies = this.populate(rootProjectState);
        if (!buildDependencies.isEmpty()) {
            Gradle rootGradle = this.getRootGradle(project.getGradle());
            Project rootProject = rootGradle.getRootProject();
            StartParameter startParameter = rootGradle.getStartParameter();
            ArrayList<String> taskPaths = new ArrayList<String>(startParameter.getTaskNames());
            String parentTaskName = RunBuildDependenciesTaskBuilder.parentTaskName(rootProject, "eclipseClosedDependencies");
            rootProject.getTasks().register(parentTaskName, task -> task.dependsOn(buildDependencies.toArray(new Object[0])));
            taskPaths.add(parentTaskName);
            startParameter.setTaskNames(taskPaths);
        }
        return DefaultRunClosedProjectBuildDependencies.INSTANCE;
    }

    private Gradle getRootGradle(Gradle gradle) {
        Gradle parent = gradle.getParent();
        if (parent == null) {
            return gradle;
        }
        return this.getRootGradle(parent);
    }

    private List<TaskDependency> populate(ProjectState p) {
        List currentElements = (List)p.fromMutableState(project -> {
            project.getPluginManager().apply(EclipsePlugin.class);
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
            EclipseModelBuilder.ClasspathElements elements = EclipseModelBuilder.gatherClasspathElements(this.projectOpenStatus, eclipseClasspath, false);
            return elements.getBuildDependencies();
        });
        ArrayList<TaskDependency> buildDependencies = new ArrayList<TaskDependency>(currentElements);
        for (ProjectState childProject : p.getChildProjects()) {
            buildDependencies.addAll(this.populate(childProject));
        }
        return buildDependencies;
    }

    public boolean canBuild(String modelName) {
        return "org.gradle.tooling.model.eclipse.RunClosedProjectBuildDependencies".equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        return DefaultRunClosedProjectBuildDependencies.INSTANCE;
    }

    private static String parentTaskName(Project project, String baseName) {
        if (project.getTasks().findByName(baseName) == null) {
            return baseName;
        }
        return RunBuildDependenciesTaskBuilder.parentTaskName(project, baseName + "_");
    }
}

